/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste Parameter Algorithmus2 (Belegung).
<p>
&lt;absatz&gt;
						Attributliste für Definition der Parameter Steuerung für lokale Beeinflussung Algorithmus2 (Belegung)
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlNbaStrgParameterAlgorithmus2 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _bStufeEin
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _bStufeAus
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vBStufeEin
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vBStufeAus
			;
	
		/**
		Einschaltkriterium Belegung.
		<p>
		
		</p>
		
		@return der Wert von BStufeEin.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 getBStufeEin() {
			return _bStufeEin;
		}
	
		/**
		Einschaltkriterium Belegung.
		<p>
		
		</p>
		
		@param _bStufeEin der neue Wert von BStufeEin.
		*/
		public void setBStufeEin(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
		 _bStufeEin) {
			this._bStufeEin = _bStufeEin;
		}
	
		/**
		Ausschaltkriterium Belegung.
		<p>
		
		</p>
		
		@return der Wert von BStufeAus.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 getBStufeAus() {
			return _bStufeAus;
		}
	
		/**
		Ausschaltkriterium Belegung.
		<p>
		
		</p>
		
		@param _bStufeAus der neue Wert von BStufeAus.
		*/
		public void setBStufeAus(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
		 _bStufeAus) {
			this._bStufeAus = _bStufeAus;
		}
	
		/**
		Einschaltkriterium VB  (vKfz auf FS 1).
		<p>
		
		</p>
		
		@return der Wert von VBStufeEin.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getVBStufeEin() {
			return _vBStufeEin;
		}
	
		/**
		Einschaltkriterium VB  (vKfz auf FS 1).
		<p>
		
		</p>
		
		@param _vBStufeEin der neue Wert von VBStufeEin.
		*/
		public void setVBStufeEin(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _vBStufeEin) {
			this._vBStufeEin = _vBStufeEin;
		}
	
		/**
		Ausschaltkriterium VB  (vKfzP).
		<p>
		
		</p>
		
		@return der Wert von VBStufeAus.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getVBStufeAus() {
			return _vBStufeAus;
		}
	
		/**
		Ausschaltkriterium VB  (vKfzP).
		<p>
		
		</p>
		
		@param _vBStufeAus der neue Wert von VBStufeAus.
		*/
		public void setVBStufeAus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _vBStufeAus) {
			this._vBStufeAus = _vBStufeAus;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getBStufeEin() != null) {
	                if (getBStufeEin().isZustand()) {
	                    datum.getUnscaledValue("bStufeEin").setText(getBStufeEin().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("bStufeEin").set(getBStufeEin().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getBStufeAus() != null) {
	                if (getBStufeAus().isZustand()) {
	                    datum.getUnscaledValue("bStufeAus").setText(getBStufeAus().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("bStufeAus").set(getBStufeAus().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVBStufeEin() != null) {
	                if (getVBStufeEin().isZustand()) {
	                    datum.getUnscaledValue("vBStufeEin").setText(getVBStufeEin().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("vBStufeEin").set(getVBStufeEin().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVBStufeAus() != null) {
	                if (getVBStufeAus().isZustand()) {
	                    datum.getUnscaledValue("vBStufeAus").setText(getVBStufeAus().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("vBStufeAus").set(getVBStufeAus().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("bStufeEin").isState()) {
							setBStufeEin(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							.getZustand(daten.getScaledValue("bStufeEin").getText()));
						} else {
						setBStufeEin(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
						(daten.
							getUnscaledValue
						("bStufeEin").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("bStufeAus").isState()) {
							setBStufeAus(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							.getZustand(daten.getScaledValue("bStufeAus").getText()));
						} else {
						setBStufeAus(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
						(daten.
							getUnscaledValue
						("bStufeAus").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("vBStufeEin").isState()) {
							setVBStufeEin(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("vBStufeEin").getText()));
						} else {
						setVBStufeEin(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("vBStufeEin").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("vBStufeAus").isState()) {
							setVBStufeAus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("vBStufeAus").getText()));
						} else {
						setVBStufeAus(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("vBStufeAus").
								shortValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgParameterAlgorithmus2 clone() {
		AtlNbaStrgParameterAlgorithmus2 klon = new AtlNbaStrgParameterAlgorithmus2();
		
						klon.setBStufeEin(getBStufeEin());
						klon.setBStufeAus(getBStufeAus());
						klon.setVBStufeEin(getVBStufeEin());
						klon.setVBStufeAus(getVBStufeAus());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
