/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste Parameter Algorithmus5 (aktuelle Reisezeit).
<p>
&lt;absatz&gt;
						Attributliste für Definition der Parameter Steuerung für lokale Beeinflussung Algorithmus5 (aktuelle Reisezeit)
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgParameterAlgorithmus5 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaAuswahlGeschwindigkeit
			 _geschwindigkeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 _bEin
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _offsetEin
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 _bAus
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _offsetAus
			;
	
		/**
		Geschwindigkeit im Abschnitt, 0 = lokale Geschwindigkeit, 1 = streckenbezogene Geschwindigkeit.
		<p>
		
		</p>
		
		@return der Wert von Geschwindigkeit.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaAuswahlGeschwindigkeit
			 getGeschwindigkeit() {
			return _geschwindigkeit;
		}
	
		/**
		Geschwindigkeit im Abschnitt, 0 = lokale Geschwindigkeit, 1 = streckenbezogene Geschwindigkeit.
		<p>
		
		</p>
		
		@param _geschwindigkeit der neue Wert von Geschwindigkeit.
		*/
		public void setGeschwindigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaAuswahlGeschwindigkeit
		 _geschwindigkeit) {
			this._geschwindigkeit = _geschwindigkeit;
		}
	
		/**
		Faktor Reisezeit Alternativroute Einschaltkriterium.
		<p>
		
		</p>
		
		@return der Wert von BEin.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 getBEin() {
			return _bEin;
		}
	
		/**
		Faktor Reisezeit Alternativroute Einschaltkriterium.
		<p>
		
		</p>
		
		@param _bEin der neue Wert von BEin.
		*/
		public void setBEin(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
		 _bEin) {
			this._bEin = _bEin;
		}
	
		/**
		Offset Reisezeit Alternativroute Einschaltkriterium.
		<p>
		
		</p>
		
		@return der Wert von OffsetEin.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getOffsetEin() {
			return _offsetEin;
		}
	
		/**
		Offset Reisezeit Alternativroute Einschaltkriterium.
		<p>
		
		</p>
		
		@param _offsetEin der neue Wert von OffsetEin.
		*/
		public void setOffsetEin(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _offsetEin) {
			this._offsetEin = _offsetEin;
		}
	
		/**
		Faktor Reisezeit Alternativroute Ausschaltkriterium.
		<p>
		
		</p>
		
		@return der Wert von BAus.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 getBAus() {
			return _bAus;
		}
	
		/**
		Faktor Reisezeit Alternativroute Ausschaltkriterium.
		<p>
		
		</p>
		
		@param _bAus der neue Wert von BAus.
		*/
		public void setBAus(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
		 _bAus) {
			this._bAus = _bAus;
		}
	
		/**
		Offset Reisezeit Alternativroute Einschaltkriterium.
		<p>
		
		</p>
		
		@return der Wert von OffsetAus.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getOffsetAus() {
			return _offsetAus;
		}
	
		/**
		Offset Reisezeit Alternativroute Einschaltkriterium.
		<p>
		
		</p>
		
		@param _offsetAus der neue Wert von OffsetAus.
		*/
		public void setOffsetAus(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _offsetAus) {
			this._offsetAus = _offsetAus;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getGeschwindigkeit() != null) {
	                if (getGeschwindigkeit().isZustand()) {
	                    datum.getUnscaledValue("Geschwindigkeit").setText(getGeschwindigkeit().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Geschwindigkeit").set(getGeschwindigkeit().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getBEin() != null) {
	                if (getBEin().isZustand()) {
	                    datum.getUnscaledValue("bEin").setText(getBEin().toString());
	                } else {
						datum.
						getScaledValue
	                	("bEin").set(getBEin().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getOffsetEin() != null) {
	                if (getOffsetEin().isZustand()) {
	                    datum.getUnscaledValue("offsetEin").setText(getOffsetEin().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("offsetEin").set(getOffsetEin().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getBAus() != null) {
	                if (getBAus().isZustand()) {
	                    datum.getUnscaledValue("bAus").setText(getBAus().toString());
	                } else {
						datum.
						getScaledValue
	                	("bAus").set(getBAus().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getOffsetAus() != null) {
	                if (getOffsetAus().isZustand()) {
	                    datum.getUnscaledValue("offsetAus").setText(getOffsetAus().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("offsetAus").set(getOffsetAus().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Geschwindigkeit").isState()) {
							setGeschwindigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaAuswahlGeschwindigkeit
							.getZustand(daten.getScaledValue("Geschwindigkeit").getText()));
						} else {
						setGeschwindigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaAuswahlGeschwindigkeit
						(daten.
							getUnscaledValue
						("Geschwindigkeit").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setBEin(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
						(daten.
							getScaledValue
						("bEin").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setOffsetEin(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("offsetEin").
								longValue
						()));
				// GanzzahlAttributTyp
						setBAus(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
						(daten.
							getScaledValue
						("bAus").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setOffsetAus(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("offsetAus").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgParameterAlgorithmus5 clone() {
		AtlNbaStrgParameterAlgorithmus5 klon = new AtlNbaStrgParameterAlgorithmus5();
		
						klon.setGeschwindigkeit(getGeschwindigkeit());
						klon.setBEin(getBEin());
						klon.setOffsetEin(getOffsetEin());
						klon.setBAus(getBAus());
						klon.setOffsetAus(getOffsetAus());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
