/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
???.
<p>
&lt;absatz&gt;
            ???
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgSteuerlogikAlgorithmus2 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _aktiv
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaUrsachenEinheitAlgorithmus2
			> _ursachenEinheit = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaUrsachenEinheitAlgorithmus2
			>(0, true);
	
		/**
		Algorithmus aktiviert&#47;deaktiviert.
		<p>
		
		</p>
		
		@return der Wert von Aktiv.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getAktiv() {
			return _aktiv;
		}
	
		/**
		Algorithmus aktiviert&#47;deaktiviert.
		<p>
		
		</p>
		
		@param _aktiv der neue Wert von Aktiv.
		*/
		public void setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _aktiv) {
			this._aktiv = _aktiv;
		}
	
		/**
		Ursacheneinheiten Algorithmus 2 für lokale Steuerung.
		<p>
		
		</p>
		
		@return der Wert von UrsachenEinheit.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaUrsachenEinheitAlgorithmus2
			> getUrsachenEinheit() {
			return _ursachenEinheit;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getAktiv() != null) {
	                if (getAktiv().isZustand()) {
	                    datum.getUnscaledValue("aktiv").setText(getAktiv().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("aktiv").set(getAktiv().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayUrsachenEinheit = datum.getReferenceArray("UrsachenEinheit");
					arrayUrsachenEinheit.setLength(getUrsachenEinheit().size());
					for (int i = 0; i < arrayUrsachenEinheit.getLength(); ++i) {
						final Object soUrsachenEinheit = getUrsachenEinheit().get(i);
						final SystemObject tmpUrsachenEinheit;
						if (soUrsachenEinheit instanceof SystemObject) {
							tmpUrsachenEinheit = (SystemObject)soUrsachenEinheit;
						} else if(soUrsachenEinheit instanceof SystemObjekt){
							tmpUrsachenEinheit = ((SystemObjekt)soUrsachenEinheit).getSystemObject();
						} else{
							tmpUrsachenEinheit = null;
						}
						arrayUrsachenEinheit.getReferenceValue(i).setSystemObject(tmpUrsachenEinheit);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("aktiv").isState()) {
							setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("aktiv").getText()));
						} else {
						setAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("aktiv").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayUrsachenEinheit = daten.getReferenceArray("UrsachenEinheit");
					for (int i = 0; i < arrayUrsachenEinheit.getLength(); ++i) {
						final long idUrsachenEinheit = daten.getReferenceArray("UrsachenEinheit").getReferenceValue(i).getId();
						final SystemObjekt tmpUrsachenEinheit;
						if (idUrsachenEinheit == 0) {
							tmpUrsachenEinheit = null;
						} else {
							final SystemObject soUrsachenEinheit = factory.getDav().getDataModel().getObject(idUrsachenEinheit);
							if (soUrsachenEinheit == null) {
									tmpUrsachenEinheit = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl.NbaUrsachenEinheitAlgorithmus2Ungueltig(idUrsachenEinheit);
							} else {
								tmpUrsachenEinheit = factory.getModellobjekt(soUrsachenEinheit);
							}
						}
							getUrsachenEinheit().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaUrsachenEinheitAlgorithmus2
							) tmpUrsachenEinheit);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgSteuerlogikAlgorithmus2 clone() {
		AtlNbaStrgSteuerlogikAlgorithmus2 klon = new AtlNbaStrgSteuerlogikAlgorithmus2();
		
						klon.setAktiv(getAktiv());
					klon._ursachenEinheit = getUrsachenEinheit().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
