/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste Parameter Algorithmus3 pro Ursacheneinheit.
<p>
&lt;absatz&gt;
						Attributliste für Definition der Parameter Steuerung für lokale Beeinflussung Algorithmus3 Ursacheneinheit
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlNbaStrgUrsachenEinheitAlg3 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			> _messQuerschnitt = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgParameterAlgorithmus3
			 _parameter
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgParameterAlgorithmus3
			()
			;
	
		/**
		Referenz auf einen Messquerschnitt.
		<p>
		
		</p>
		
		@return der Wert von MessQuerschnitt.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			> getMessQuerschnitt() {
			return _messQuerschnitt;
		}
	
	
		/**
		Parameter für Stufe 1 .. N für Algorithmus3.
		<p>
		
		</p>
		
		@return der Wert von Parameter.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgParameterAlgorithmus3
			 getParameter() {
			return _parameter;
		}
	
		/**
		Parameter für Stufe 1 .. N für Algorithmus3.
		<p>
		
		</p>
		
		@param _parameter der neue Wert von Parameter.
		*/
		public void setParameter(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgParameterAlgorithmus3
		 _parameter) {
			this._parameter = _parameter;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayMessQuerschnitt = datum.getReferenceArray("MessQuerschnitt");
					arrayMessQuerschnitt.setLength(getMessQuerschnitt().size());
					for (int i = 0; i < arrayMessQuerschnitt.getLength(); ++i) {
						final Object soMessQuerschnitt = getMessQuerschnitt().get(i);
						final SystemObject tmpMessQuerschnitt;
						if (soMessQuerschnitt instanceof SystemObject) {
							tmpMessQuerschnitt = (SystemObject)soMessQuerschnitt;
						} else if(soMessQuerschnitt instanceof SystemObjekt){
							tmpMessQuerschnitt = ((SystemObjekt)soMessQuerschnitt).getSystemObject();
						} else{
							tmpMessQuerschnitt = null;
						}
						arrayMessQuerschnitt.getReferenceValue(i).setSystemObject(tmpMessQuerschnitt);
					}
				// AttributListenDefinition
					getParameter().bean2Atl(datum.getItem("Parameter"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayMessQuerschnitt = daten.getReferenceArray("MessQuerschnitt");
					for (int i = 0; i < arrayMessQuerschnitt.getLength(); ++i) {
						final long idMessQuerschnitt = daten.getReferenceArray("MessQuerschnitt").getReferenceValue(i).getId();
						final SystemObjekt tmpMessQuerschnitt;
						if (idMessQuerschnitt == 0) {
							tmpMessQuerschnitt = null;
						} else {
							final SystemObject soMessQuerschnitt = factory.getDav().getDataModel().getObject(idMessQuerschnitt);
							if (soMessQuerschnitt == null) {
									tmpMessQuerschnitt = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idMessQuerschnitt);
							} else {
								tmpMessQuerschnitt = factory.getModellobjekt(soMessQuerschnitt);
							}
						}
							getMessQuerschnitt().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
							) tmpMessQuerschnitt);
					}
				// AttributListenDefinition
					getParameter().atl2Bean(daten.getItem("Parameter"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgUrsachenEinheitAlg3 clone() {
		AtlNbaStrgUrsachenEinheitAlg3 klon = new AtlNbaStrgUrsachenEinheitAlg3();
		
					klon._messQuerschnitt = getMessQuerschnitt().clone();
						klon._parameter = getParameter().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
