/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste Parameter Algorithmus5 pro Ursacheneinheit.
<p>
&lt;absatz&gt;
						Attributliste für Definition der Parameter Steuerung für lokale Beeinflussung Algorithmus5 Ursacheneinheit
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgUrsachenEinheitAlg5 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	Object
			> _route = new Feld<	Object
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgParameterAlgorithmus5
			 _parameter
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgParameterAlgorithmus5
			()
			;
	
		/**
		Referenz auf eine Normalroute.
		<p>
		
		</p>
		
		@return der Wert von Route.
		*/
			public Feld<	Object
			> getRoute() {
			return _route;
		}
	
	
		/**
		Parameter für Stufe 1 .. N für Algorithmus5.
		<p>
		
		</p>
		
		@return der Wert von Parameter.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgParameterAlgorithmus5
			 getParameter() {
			return _parameter;
		}
	
		/**
		Parameter für Stufe 1 .. N für Algorithmus5.
		<p>
		
		</p>
		
		@param _parameter der neue Wert von Parameter.
		*/
		public void setParameter(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgParameterAlgorithmus5
		 _parameter) {
			this._parameter = _parameter;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayRoute = datum.getReferenceArray("Route");
					arrayRoute.setLength(getRoute().size());
					for (int i = 0; i < arrayRoute.getLength(); ++i) {
						final Object soRoute = getRoute().get(i);
						final SystemObject tmpRoute;
						if (soRoute instanceof SystemObject) {
							tmpRoute = (SystemObject)soRoute;
						} else if(soRoute instanceof SystemObjekt){
							tmpRoute = ((SystemObjekt)soRoute).getSystemObject();
						} else{
							tmpRoute = null;
						}
						arrayRoute.getReferenceValue(i).setSystemObject(tmpRoute);
					}
				// AttributListenDefinition
					getParameter().bean2Atl(datum.getItem("Parameter"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayRoute = daten.getReferenceArray("Route");
					for (int i = 0; i < arrayRoute.getLength(); ++i) {
						final long idRoute = daten.getReferenceArray("Route").getReferenceValue(i).getId();
						final SystemObjekt tmpRoute;
						if (idRoute == 0) {
							tmpRoute = null;
						} else {
							final SystemObject soRoute = factory.getDav().getDataModel().getObject(idRoute);
							if (soRoute == null) {
									tmpRoute = new BaseUngueltigesSystemObjekt(idRoute);
							} else {
								tmpRoute = factory.getModellobjekt(soRoute);
							}
						}
							getRoute().add((	Object
							) tmpRoute);
					}
				// AttributListenDefinition
					getParameter().atl2Bean(daten.getItem("Parameter"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgUrsachenEinheitAlg5 clone() {
		AtlNbaStrgUrsachenEinheitAlg5 klon = new AtlNbaStrgUrsachenEinheitAlg5();
		
					klon._route = getRoute().clone();
						klon._parameter = getParameter().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
