/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste für die Verkehrszustandsermittlung.
<p>
&lt;absatz&gt;
						???
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlNbaVerkehrszustandVerfahren1 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _v1
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _v2
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _k1
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _k2
			;
	
		/**
		Grenzgeschwindigkeit 1.
		<p>
		
		</p>
		
		@return der Wert von V1.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getV1() {
			return _v1;
		}
	
		/**
		Grenzgeschwindigkeit 1.
		<p>
		
		</p>
		
		@param _v1 der neue Wert von V1.
		*/
		public void setV1(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _v1) {
			this._v1 = _v1;
		}
	
		/**
		Grenzgeschwindigkeit 2.
		<p>
		
		</p>
		
		@return der Wert von V2.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getV2() {
			return _v2;
		}
	
		/**
		Grenzgeschwindigkeit 2.
		<p>
		
		</p>
		
		@param _v2 der neue Wert von V2.
		*/
		public void setV2(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _v2) {
			this._v2 = _v2;
		}
	
		/**
		Grenzfahrzeugdichte 1.
		<p>
		
		</p>
		
		@return der Wert von K1.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 getK1() {
			return _k1;
		}
	
		/**
		Grenzfahrzeugdichte 1.
		<p>
		
		</p>
		
		@param _k1 der neue Wert von K1.
		*/
		public void setK1(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
		 _k1) {
			this._k1 = _k1;
		}
	
		/**
		Grenzfahrzeugdichte 2.
		<p>
		
		</p>
		
		@return der Wert von K2.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 getK2() {
			return _k2;
		}
	
		/**
		Grenzfahrzeugdichte 2.
		<p>
		
		</p>
		
		@param _k2 der neue Wert von K2.
		*/
		public void setK2(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
		 _k2) {
			this._k2 = _k2;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getV1() != null) {
	                if (getV1().isZustand()) {
	                    datum.getUnscaledValue("v1").setText(getV1().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("v1").set(getV1().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getV2() != null) {
	                if (getV2().isZustand()) {
	                    datum.getUnscaledValue("v2").setText(getV2().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("v2").set(getV2().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getK1() != null) {
	                if (getK1().isZustand()) {
	                    datum.getUnscaledValue("k1").setText(getK1().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("k1").set(getK1().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getK2() != null) {
	                if (getK2().isZustand()) {
	                    datum.getUnscaledValue("k2").setText(getK2().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("k2").set(getK2().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("v1").isState()) {
							setV1(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("v1").getText()));
						} else {
						setV1(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("v1").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("v2").isState()) {
							setV2(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("v2").getText()));
						} else {
						setV2(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("v2").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("k1").isState()) {
							setK1(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							.getZustand(daten.getScaledValue("k1").getText()));
						} else {
						setK1(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
						(daten.
							getUnscaledValue
						("k1").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("k2").isState()) {
							setK2(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							.getZustand(daten.getScaledValue("k2").getText()));
						} else {
						setK2(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
						(daten.
							getUnscaledValue
						("k2").
								shortValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaVerkehrszustandVerfahren1 clone() {
		AtlNbaVerkehrszustandVerfahren1 klon = new AtlNbaVerkehrszustandVerfahren1();
		
						klon.setV1(getV1());
						klon.setV2(getV2());
						klon.setK1(getK1());
						klon.setK2(getK2());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
