/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
FahrtRichtung-Prognose-Informationen für alle Prognosezeitpunkte des Entscheidungspunktes.
<p>
&lt;absatz&gt;
						FahrtRichtung-Prognose-Informationen für alle Prognosezeitpunkte des Entscheidungspunktes.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 12
 */
public class AtlNbaZielEntscheidungspunktePrognose implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
			 _entscheidungspunktReferenz
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielEntscheidungspunktePrognoseZeitpunkt
			> _fahrtRichtungPrognose = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielEntscheidungspunktePrognoseZeitpunkt
			>(0, true);
	
		/**
		Referenz auf den Entscheidungspunkt, für den die FahrtRichtung-Prognose-Informationen gelten.
		<p>
		
		</p>
		
		@return der Wert von EntscheidungspunktReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
			 getEntscheidungspunktReferenz() {
			return _entscheidungspunktReferenz;
		}
	
		/**
		Referenz auf den Entscheidungspunkt, für den die FahrtRichtung-Prognose-Informationen gelten.
		<p>
		
		</p>
		
		@param _entscheidungspunktReferenz der neue Wert von EntscheidungspunktReferenz.
		*/
		public void setEntscheidungspunktReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
		 _entscheidungspunktReferenz) {
			this._entscheidungspunktReferenz = _entscheidungspunktReferenz;
		}
	
		/**
		FahrtRichtung-Prognose-Informationen für alle Prognosezeitpunkte des Entscheidungspunktes für die NBA.
		<p>
		
		</p>
		
		@return der Wert von FahrtRichtungPrognose.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielEntscheidungspunktePrognoseZeitpunkt
			> getFahrtRichtungPrognose() {
			return _fahrtRichtungPrognose;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soEntscheidungspunktReferenz = getEntscheidungspunktReferenz();
					final SystemObject tmpEntscheidungspunktReferenz;
						if (soEntscheidungspunktReferenz instanceof SystemObject) {
							tmpEntscheidungspunktReferenz = (SystemObject)soEntscheidungspunktReferenz;
						} else if(soEntscheidungspunktReferenz instanceof SystemObjekt){
							tmpEntscheidungspunktReferenz = ((SystemObjekt)soEntscheidungspunktReferenz).getSystemObject();
						} else{
							tmpEntscheidungspunktReferenz = null;
						}
					datum.getReferenceValue("EntscheidungspunktReferenz").setSystemObject(tmpEntscheidungspunktReferenz);
				// AttributListenDefinition
					final Data.Array arrayFahrtRichtungPrognose = datum.getArray("FahrtRichtungPrognose");
					arrayFahrtRichtungPrognose.setLength(getFahrtRichtungPrognose().size());
					for (int i = 0; i < arrayFahrtRichtungPrognose.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielEntscheidungspunktePrognoseZeitpunkt
						 atl = getFahrtRichtungPrognose().get(i);
						atl.bean2Atl(arrayFahrtRichtungPrognose.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idEntscheidungspunktReferenz = daten.getReferenceValue("EntscheidungspunktReferenz").getId();
					final SystemObjekt tmpEntscheidungspunktReferenz;
					if (idEntscheidungspunktReferenz == 0) {
						tmpEntscheidungspunktReferenz = null;
					} else {
						final SystemObject soEntscheidungspunktReferenz = factory.getDav().getDataModel().getObject(idEntscheidungspunktReferenz);
						if (soEntscheidungspunktReferenz == null) {
								tmpEntscheidungspunktReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl.NbaEntscheidungspunktUngueltig(idEntscheidungspunktReferenz);
						} else {
							tmpEntscheidungspunktReferenz = factory.getModellobjekt(soEntscheidungspunktReferenz);
						}
					}
					setEntscheidungspunktReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
					) tmpEntscheidungspunktReferenz);
				// AttributListenDefinition
					final Data.Array arrayFahrtRichtungPrognose = daten.getArray("FahrtRichtungPrognose");
					for (int i = 0; i < arrayFahrtRichtungPrognose.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielEntscheidungspunktePrognoseZeitpunkt
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielEntscheidungspunktePrognoseZeitpunkt
						 ();
						atl.atl2Bean(arrayFahrtRichtungPrognose.getItem(i), factory);
						getFahrtRichtungPrognose().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaZielEntscheidungspunktePrognose clone() {
		AtlNbaZielEntscheidungspunktePrognose klon = new AtlNbaZielEntscheidungspunktePrognose();
		
						klon.setEntscheidungspunktReferenz(getEntscheidungspunktReferenz());
					klon._fahrtRichtungPrognose = getFahrtRichtungPrognose().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
