/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Informationen zu einem RoutenStück (RoutenElement) in einer Route.
<p>
&lt;absatz&gt;
						Informationen zu einem RoutenStück (RoutenElement) in einer Route.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 22
 */
public class AtlNbaZielRoutenDiagnoseRoutenElement implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
			 _entscheidungsPunkt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 _fahrtRichtung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _fahrtRichtungAutomatisch
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.RoutenStueck
			 _routenStueck
			;
			private 	Zeitstempel
			 _zeitpunktReisezeit
			;
			private 	RelativerZeitstempel
			 _reisezeit
			;
	
		/**
		EntscheidungsPunkt vor dem RoutenStück.
		<p>
		
		</p>
		
		@return der Wert von EntscheidungsPunkt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
			 getEntscheidungsPunkt() {
			return _entscheidungsPunkt;
		}
	
		/**
		EntscheidungsPunkt vor dem RoutenStück.
		<p>
		
		</p>
		
		@param _entscheidungsPunkt der neue Wert von EntscheidungsPunkt.
		*/
		public void setEntscheidungsPunkt(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
		 _entscheidungsPunkt) {
			this._entscheidungsPunkt = _entscheidungsPunkt;
		}
	
		/**
		FahrtRichtung am EntscheidungsPunkt, um zum RoutenStück zu gelangen.
		<p>
		
		</p>
		
		@return der Wert von FahrtRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 getFahrtRichtung() {
			return _fahrtRichtung;
		}
	
		/**
		FahrtRichtung am EntscheidungsPunkt, um zum RoutenStück zu gelangen.
		<p>
		
		</p>
		
		@param _fahrtRichtung der neue Wert von FahrtRichtung.
		*/
		public void setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
		 _fahrtRichtung) {
			this._fahrtRichtung = _fahrtRichtung;
		}
	
		/**
		FahrtRichtung am EntscheidungsPunkt durch netzweite Steuerung automatisch bestimmt oder durch Vorgabe festgelegt.
		<p>
		
		</p>
		
		@return der Wert von FahrtRichtungAutomatisch.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getFahrtRichtungAutomatisch() {
			return _fahrtRichtungAutomatisch;
		}
	
		/**
		FahrtRichtung am EntscheidungsPunkt durch netzweite Steuerung automatisch bestimmt oder durch Vorgabe festgelegt.
		<p>
		
		</p>
		
		@param _fahrtRichtungAutomatisch der neue Wert von FahrtRichtungAutomatisch.
		*/
		public void setFahrtRichtungAutomatisch(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _fahrtRichtungAutomatisch) {
			this._fahrtRichtungAutomatisch = _fahrtRichtungAutomatisch;
		}
	
		/**
		RoutenStück der Route.
		<p>
		
		</p>
		
		@return der Wert von RoutenStueck.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.RoutenStueck
			 getRoutenStueck() {
			return _routenStueck;
		}
	
		/**
		RoutenStück der Route.
		<p>
		
		</p>
		
		@param _routenStueck der neue Wert von RoutenStueck.
		*/
		public void setRoutenStueck(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.RoutenStueck
		 _routenStueck) {
			this._routenStueck = _routenStueck;
		}
	
		/**
		Zeitpunkt für den die Reisezeit auf dem RoutenStück gilt.
		<p>
		
		</p>
		
		@return der Wert von ZeitpunktReisezeit.
		*/
			public 	Zeitstempel
			 getZeitpunktReisezeit() {
			return _zeitpunktReisezeit;
		}
	
		/**
		Zeitpunkt für den die Reisezeit auf dem RoutenStück gilt.
		<p>
		
		</p>
		
		@param _zeitpunktReisezeit der neue Wert von ZeitpunktReisezeit.
		*/
		public void setZeitpunktReisezeit(	Zeitstempel
		 _zeitpunktReisezeit) {
			this._zeitpunktReisezeit = _zeitpunktReisezeit;
		}
	
		/**
		Reisezeit auf dem RoutenStück.
		<p>
		
		</p>
		
		@return der Wert von Reisezeit.
		*/
			public 	RelativerZeitstempel
			 getReisezeit() {
			return _reisezeit;
		}
	
		/**
		Reisezeit auf dem RoutenStück.
		<p>
		
		</p>
		
		@param _reisezeit der neue Wert von Reisezeit.
		*/
		public void setReisezeit(	RelativerZeitstempel
		 _reisezeit) {
			this._reisezeit = _reisezeit;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soEntscheidungsPunkt = getEntscheidungsPunkt();
					final SystemObject tmpEntscheidungsPunkt;
						if (soEntscheidungsPunkt instanceof SystemObject) {
							tmpEntscheidungsPunkt = (SystemObject)soEntscheidungsPunkt;
						} else if(soEntscheidungsPunkt instanceof SystemObjekt){
							tmpEntscheidungsPunkt = ((SystemObjekt)soEntscheidungsPunkt).getSystemObject();
						} else{
							tmpEntscheidungsPunkt = null;
						}
					datum.getReferenceValue("EntscheidungsPunkt").setSystemObject(tmpEntscheidungsPunkt);
				// GanzzahlAttributTyp
				if (getFahrtRichtung() != null) {
	                if (getFahrtRichtung().isZustand()) {
	                    datum.getUnscaledValue("FahrtRichtung").setText(getFahrtRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FahrtRichtung").set(getFahrtRichtung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFahrtRichtungAutomatisch() != null) {
	                if (getFahrtRichtungAutomatisch().isZustand()) {
	                    datum.getUnscaledValue("FahrtRichtungAutomatisch").setText(getFahrtRichtungAutomatisch().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FahrtRichtungAutomatisch").set(getFahrtRichtungAutomatisch().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soRoutenStueck = getRoutenStueck();
					final SystemObject tmpRoutenStueck;
						if (soRoutenStueck instanceof SystemObject) {
							tmpRoutenStueck = (SystemObject)soRoutenStueck;
						} else if(soRoutenStueck instanceof SystemObjekt){
							tmpRoutenStueck = ((SystemObjekt)soRoutenStueck).getSystemObject();
						} else{
							tmpRoutenStueck = null;
						}
					datum.getReferenceValue("RoutenStück").setSystemObject(tmpRoutenStueck);
				// ZeitstempelAttributTyp
					datum.getTimeValue("ZeitpunktReisezeit").setMillis(getZeitpunktReisezeit().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("Reisezeit").setMillis(getReisezeit().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idEntscheidungsPunkt = daten.getReferenceValue("EntscheidungsPunkt").getId();
					final SystemObjekt tmpEntscheidungsPunkt;
					if (idEntscheidungsPunkt == 0) {
						tmpEntscheidungsPunkt = null;
					} else {
						final SystemObject soEntscheidungsPunkt = factory.getDav().getDataModel().getObject(idEntscheidungsPunkt);
						if (soEntscheidungsPunkt == null) {
								tmpEntscheidungsPunkt = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl.NbaEntscheidungspunktUngueltig(idEntscheidungsPunkt);
						} else {
							tmpEntscheidungsPunkt = factory.getModellobjekt(soEntscheidungsPunkt);
						}
					}
					setEntscheidungsPunkt((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
					) tmpEntscheidungsPunkt);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrtRichtung").isState()) {
							setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
							.getZustand(daten.getScaledValue("FahrtRichtung").getText()));
						} else {
						setFahrtRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
						(daten.
							getUnscaledValue
						("FahrtRichtung").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrtRichtungAutomatisch").isState()) {
							setFahrtRichtungAutomatisch(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("FahrtRichtungAutomatisch").getText()));
						} else {
						setFahrtRichtungAutomatisch(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("FahrtRichtungAutomatisch").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idRoutenStueck = daten.getReferenceValue("RoutenStück").getId();
					final SystemObjekt tmpRoutenStueck;
					if (idRoutenStueck == 0) {
						tmpRoutenStueck = null;
					} else {
						final SystemObject soRoutenStueck = factory.getDav().getDataModel().getObject(idRoutenStueck);
						if (soRoutenStueck == null) {
								tmpRoutenStueck = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.RoutenStueckUngueltig(idRoutenStueck);
						} else {
							tmpRoutenStueck = factory.getModellobjekt(soRoutenStueck);
						}
					}
					setRoutenStueck((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.RoutenStueck
					) tmpRoutenStueck);
				// ZeitstempelAttributTyp
					setZeitpunktReisezeit(new
						Zeitstempel
						(daten.getTimeValue("ZeitpunktReisezeit").getMillis()));
				// ZeitstempelAttributTyp
					setReisezeit(new
						RelativerZeitstempel
						(daten.getTimeValue("Reisezeit").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaZielRoutenDiagnoseRoutenElement clone() {
		AtlNbaZielRoutenDiagnoseRoutenElement klon = new AtlNbaZielRoutenDiagnoseRoutenElement();
		
						klon.setEntscheidungsPunkt(getEntscheidungsPunkt());
						klon.setFahrtRichtung(getFahrtRichtung());
						klon.setFahrtRichtungAutomatisch(getFahrtRichtungAutomatisch());
						klon.setRoutenStueck(getRoutenStueck());
						klon.setZeitpunktReisezeit(getZeitpunktReisezeit());
						klon.setReisezeit(getReisezeit());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
