/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zwischenergebnisse der Stauprognose für jeden vom Stau betroffenen Abschnitt.
<p>
&lt;absatz&gt;
						Zwischenergebnisse der Stauprognose für jeden vom Stau betroffenen Abschnitt
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 21
 */
public class AtlNbaZwischenErgebnisseAbschnitt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
			 _strassenteilsegment
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _offset
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _leistungsfaehigkeitAbschnitt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _leistungsfaehigkeitFahrstreifen
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _abschnittsLaenge
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vStauBerechnet
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vStau
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _lFZ
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _anzFzgAbschnitt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _n
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _l
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _korrekturFahrzeuge
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _korrekturLaenge
			;
	
		/**
		Strassenteilsegment zu dem der Abschnitt gehört.
		<p>
		
		</p>
		
		@return der Wert von Strassenteilsegment.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
			 getStrassenteilsegment() {
			return _strassenteilsegment;
		}
	
		/**
		Strassenteilsegment zu dem der Abschnitt gehört.
		<p>
		
		</p>
		
		@param _strassenteilsegment der neue Wert von Strassenteilsegment.
		*/
		public void setStrassenteilsegment(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
		 _strassenteilsegment) {
			this._strassenteilsegment = _strassenteilsegment;
		}
	
		/**
		Offset des Abschnitts innerhalb des Strassenteilsegments.
		<p>
		
		</p>
		
		@return der Wert von Offset.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getOffset() {
			return _offset;
		}
	
		/**
		Offset des Abschnitts innerhalb des Strassenteilsegments.
		<p>
		
		</p>
		
		@param _offset der neue Wert von Offset.
		*/
		public void setOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _offset) {
			this._offset = _offset;
		}
	
		/**
		Leistungsfähigkeit des Abschnitts.
		<p>
		
		</p>
		
		@return der Wert von LeistungsfaehigkeitAbschnitt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 getLeistungsfaehigkeitAbschnitt() {
			return _leistungsfaehigkeitAbschnitt;
		}
	
		/**
		Leistungsfähigkeit des Abschnitts.
		<p>
		
		</p>
		
		@param _leistungsfaehigkeitAbschnitt der neue Wert von LeistungsfaehigkeitAbschnitt.
		*/
		public void setLeistungsfaehigkeitAbschnitt(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
		 _leistungsfaehigkeitAbschnitt) {
			this._leistungsfaehigkeitAbschnitt = _leistungsfaehigkeitAbschnitt;
		}
	
		/**
		Leistungsfähigkeit eines Fahrstreifens des Abschnitts.
		<p>
		
		</p>
		
		@return der Wert von LeistungsfaehigkeitFahrstreifen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 getLeistungsfaehigkeitFahrstreifen() {
			return _leistungsfaehigkeitFahrstreifen;
		}
	
		/**
		Leistungsfähigkeit eines Fahrstreifens des Abschnitts.
		<p>
		
		</p>
		
		@param _leistungsfaehigkeitFahrstreifen der neue Wert von LeistungsfaehigkeitFahrstreifen.
		*/
		public void setLeistungsfaehigkeitFahrstreifen(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
		 _leistungsfaehigkeitFahrstreifen) {
			this._leistungsfaehigkeitFahrstreifen = _leistungsfaehigkeitFahrstreifen;
		}
	
		/**
		Länge des Abschnitts.
		<p>
		
		</p>
		
		@return der Wert von AbschnittsLaenge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getAbschnittsLaenge() {
			return _abschnittsLaenge;
		}
	
		/**
		Länge des Abschnitts.
		<p>
		
		</p>
		
		@param _abschnittsLaenge der neue Wert von AbschnittsLaenge.
		*/
		public void setAbschnittsLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _abschnittsLaenge) {
			this._abschnittsLaenge = _abschnittsLaenge;
		}
	
		/**
		berechnetes VStau (vor Vergleich mit Parameter VmaxStau.
		<p>
		
		</p>
		
		@return der Wert von VStauBerechnet.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getVStauBerechnet() {
			return _vStauBerechnet;
		}
	
		/**
		berechnetes VStau (vor Vergleich mit Parameter VmaxStau.
		<p>
		
		</p>
		
		@param _vStauBerechnet der neue Wert von VStauBerechnet.
		*/
		public void setVStauBerechnet(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _vStauBerechnet) {
			this._vStauBerechnet = _vStauBerechnet;
		}
	
		/**
		VStau (nach Vergleich mit Parameter VmaxStau.
		<p>
		
		</p>
		
		@return der Wert von VStau.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getVStau() {
			return _vStau;
		}
	
		/**
		VStau (nach Vergleich mit Parameter VmaxStau.
		<p>
		
		</p>
		
		@param _vStau der neue Wert von VStau.
		*/
		public void setVStau(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _vStau) {
			this._vStau = _vStau;
		}
	
		/**
		Länge eines Fahrzeugs im Stau.
		<p>
		
		</p>
		
		@return der Wert von LFZ.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getLFZ() {
			return _lFZ;
		}
	
		/**
		Länge eines Fahrzeugs im Stau.
		<p>
		
		</p>
		
		@param _lFZ der neue Wert von LFZ.
		*/
		public void setLFZ(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _lFZ) {
			this._lFZ = _lFZ;
		}
	
		/**
		Anzahl möglicher Fahrzeuge im Abschnitt.
		<p>
		
		</p>
		
		@return der Wert von AnzFzgAbschnitt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 getAnzFzgAbschnitt() {
			return _anzFzgAbschnitt;
		}
	
		/**
		Anzahl möglicher Fahrzeuge im Abschnitt.
		<p>
		
		</p>
		
		@param _anzFzgAbschnitt der neue Wert von AnzFzgAbschnitt.
		*/
		public void setAnzFzgAbschnitt(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
		 _anzFzgAbschnitt) {
			this._anzFzgAbschnitt = _anzFzgAbschnitt;
		}
	
		/**
		Anzahl Fahrzeuge im Stau unter Berücksichtigung dieses Abschnitts.
		<p>
		
		</p>
		
		@return der Wert von N.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 getN() {
			return _n;
		}
	
		/**
		Anzahl Fahrzeuge im Stau unter Berücksichtigung dieses Abschnitts.
		<p>
		
		</p>
		
		@param _n der neue Wert von N.
		*/
		public void setN(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
		 _n) {
			this._n = _n;
		}
	
		/**
		LÃ¤nge des Staus unter BerÃ¼cksichtigung dieses Abschnitts.
		<p>
		
		</p>
		
		@return der Wert von L.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getL() {
			return _l;
		}
	
		/**
		LÃ¤nge des Staus unter BerÃ¼cksichtigung dieses Abschnitts.
		<p>
		
		</p>
		
		@param _l der neue Wert von L.
		*/
		public void setL(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _l) {
			this._l = _l;
		}
	
		/**
		Anzahl Fahrzeuge um die die mögliche Anzahl korrigiert wurde. 
						                Korrektur ist dann notwendig, wenn der Stauanfang bzw. das Stauende 
						                nicht mit dem Offset eines Abschnitts übereinstimmt.
		<p>
		
		</p>
		
		@return der Wert von KorrekturFahrzeuge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getKorrekturFahrzeuge() {
			return _korrekturFahrzeuge;
		}
	
		/**
		Anzahl Fahrzeuge um die die mögliche Anzahl korrigiert wurde. 
						                Korrektur ist dann notwendig, wenn der Stauanfang bzw. das Stauende 
						                nicht mit dem Offset eines Abschnitts übereinstimmt.
		<p>
		
		</p>
		
		@param _korrekturFahrzeuge der neue Wert von KorrekturFahrzeuge.
		*/
		public void setKorrekturFahrzeuge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _korrekturFahrzeuge) {
			this._korrekturFahrzeuge = _korrekturFahrzeuge;
		}
	
		/**
		Anzahl Meter um die die Länge des Staus korrigiert wurde. 
						                Korrektur ist dann notwendig, wenn der Stauanfang bzw. das Stauende 
						                nicht mit dem Offset eines Abschnitts übereinstimmt.
		<p>
		
		</p>
		
		@return der Wert von KorrekturLaenge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getKorrekturLaenge() {
			return _korrekturLaenge;
		}
	
		/**
		Anzahl Meter um die die Länge des Staus korrigiert wurde. 
						                Korrektur ist dann notwendig, wenn der Stauanfang bzw. das Stauende 
						                nicht mit dem Offset eines Abschnitts übereinstimmt.
		<p>
		
		</p>
		
		@param _korrekturLaenge der neue Wert von KorrekturLaenge.
		*/
		public void setKorrekturLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _korrekturLaenge) {
			this._korrekturLaenge = _korrekturLaenge;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soStrassenteilsegment = getStrassenteilsegment();
					final SystemObject tmpStrassenteilsegment;
						if (soStrassenteilsegment instanceof SystemObject) {
							tmpStrassenteilsegment = (SystemObject)soStrassenteilsegment;
						} else if(soStrassenteilsegment instanceof SystemObjekt){
							tmpStrassenteilsegment = ((SystemObjekt)soStrassenteilsegment).getSystemObject();
						} else{
							tmpStrassenteilsegment = null;
						}
					datum.getReferenceValue("Strassenteilsegment").setSystemObject(tmpStrassenteilsegment);
				// GanzzahlAttributTyp
				if (getOffset() != null) {
	                if (getOffset().isZustand()) {
	                    datum.getUnscaledValue("Offset").setText(getOffset().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Offset").set(getOffset().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLeistungsfaehigkeitAbschnitt() != null) {
	                if (getLeistungsfaehigkeitAbschnitt().isZustand()) {
	                    datum.getUnscaledValue("LeistungsfähigkeitAbschnitt").setText(getLeistungsfaehigkeitAbschnitt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LeistungsfähigkeitAbschnitt").set(getLeistungsfaehigkeitAbschnitt().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLeistungsfaehigkeitFahrstreifen() != null) {
	                if (getLeistungsfaehigkeitFahrstreifen().isZustand()) {
	                    datum.getUnscaledValue("LeistungsfähigkeitFahrstreifen").setText(getLeistungsfaehigkeitFahrstreifen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LeistungsfähigkeitFahrstreifen").set(getLeistungsfaehigkeitFahrstreifen().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAbschnittsLaenge() != null) {
	                if (getAbschnittsLaenge().isZustand()) {
	                    datum.getUnscaledValue("AbschnittsLänge").setText(getAbschnittsLaenge().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AbschnittsLänge").set(getAbschnittsLaenge().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVStauBerechnet() != null) {
	                if (getVStauBerechnet().isZustand()) {
	                    datum.getUnscaledValue("VStauBerechnet").setText(getVStauBerechnet().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("VStauBerechnet").set(getVStauBerechnet().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVStau() != null) {
	                if (getVStau().isZustand()) {
	                    datum.getUnscaledValue("VStau").setText(getVStau().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("VStau").set(getVStau().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLFZ() != null) {
	                if (getLFZ().isZustand()) {
	                    datum.getUnscaledValue("LFZ").setText(getLFZ().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LFZ").set(getLFZ().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAnzFzgAbschnitt() != null) {
	                if (getAnzFzgAbschnitt().isZustand()) {
	                    datum.getUnscaledValue("AnzFzgAbschnitt").setText(getAnzFzgAbschnitt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AnzFzgAbschnitt").set(getAnzFzgAbschnitt().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getN() != null) {
	                if (getN().isZustand()) {
	                    datum.getUnscaledValue("N").setText(getN().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("N").set(getN().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getL() != null) {
	                if (getL().isZustand()) {
	                    datum.getUnscaledValue("L").setText(getL().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("L").set(getL().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getKorrekturFahrzeuge() != null) {
	                if (getKorrekturFahrzeuge().isZustand()) {
	                    datum.getUnscaledValue("KorrekturFahrzeuge").setText(getKorrekturFahrzeuge().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("KorrekturFahrzeuge").set(getKorrekturFahrzeuge().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getKorrekturLaenge() != null) {
	                if (getKorrekturLaenge().isZustand()) {
	                    datum.getUnscaledValue("KorrekturLänge").setText(getKorrekturLaenge().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("KorrekturLänge").set(getKorrekturLaenge().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idStrassenteilsegment = daten.getReferenceValue("Strassenteilsegment").getId();
					final SystemObjekt tmpStrassenteilsegment;
					if (idStrassenteilsegment == 0) {
						tmpStrassenteilsegment = null;
					} else {
						final SystemObject soStrassenteilsegment = factory.getDav().getDataModel().getObject(idStrassenteilsegment);
						if (soStrassenteilsegment == null) {
								tmpStrassenteilsegment = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrassenTeilSegmentUngueltig(idStrassenteilsegment);
						} else {
							tmpStrassenteilsegment = factory.getModellobjekt(soStrassenteilsegment);
						}
					}
					setStrassenteilsegment((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
					) tmpStrassenteilsegment);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Offset").isState()) {
							setOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("Offset").getText()));
						} else {
						setOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("Offset").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LeistungsfähigkeitAbschnitt").isState()) {
							setLeistungsfaehigkeitAbschnitt(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							.getZustand(daten.getScaledValue("LeistungsfähigkeitAbschnitt").getText()));
						} else {
						setLeistungsfaehigkeitAbschnitt(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
						(daten.
							getUnscaledValue
						("LeistungsfähigkeitAbschnitt").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LeistungsfähigkeitFahrstreifen").isState()) {
							setLeistungsfaehigkeitFahrstreifen(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							.getZustand(daten.getScaledValue("LeistungsfähigkeitFahrstreifen").getText()));
						} else {
						setLeistungsfaehigkeitFahrstreifen(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
						(daten.
							getUnscaledValue
						("LeistungsfähigkeitFahrstreifen").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AbschnittsLänge").isState()) {
							setAbschnittsLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("AbschnittsLänge").getText()));
						} else {
						setAbschnittsLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("AbschnittsLänge").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("VStauBerechnet").isState()) {
							setVStauBerechnet(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("VStauBerechnet").getText()));
						} else {
						setVStauBerechnet(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("VStauBerechnet").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("VStau").isState()) {
							setVStau(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("VStau").getText()));
						} else {
						setVStau(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("VStau").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LFZ").isState()) {
							setLFZ(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("LFZ").getText()));
						} else {
						setLFZ(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("LFZ").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AnzFzgAbschnitt").isState()) {
							setAnzFzgAbschnitt(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							.getZustand(daten.getScaledValue("AnzFzgAbschnitt").getText()));
						} else {
						setAnzFzgAbschnitt(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
						(daten.
							getUnscaledValue
						("AnzFzgAbschnitt").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("N").isState()) {
							setN(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							.getZustand(daten.getScaledValue("N").getText()));
						} else {
						setN(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
						(daten.
							getUnscaledValue
						("N").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("L").isState()) {
							setL(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("L").getText()));
						} else {
						setL(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("L").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						setKorrekturFahrzeuge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("KorrekturFahrzeuge").
								longValue
						()));
				// GanzzahlAttributTyp
						setKorrekturLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("KorrekturLänge").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaZwischenErgebnisseAbschnitt clone() {
		AtlNbaZwischenErgebnisseAbschnitt klon = new AtlNbaZwischenErgebnisseAbschnitt();
		
						klon.setStrassenteilsegment(getStrassenteilsegment());
						klon.setOffset(getOffset());
						klon.setLeistungsfaehigkeitAbschnitt(getLeistungsfaehigkeitAbschnitt());
						klon.setLeistungsfaehigkeitFahrstreifen(getLeistungsfaehigkeitFahrstreifen());
						klon.setAbschnittsLaenge(getAbschnittsLaenge());
						klon.setVStauBerechnet(getVStauBerechnet());
						klon.setVStau(getVStau());
						klon.setLFZ(getLFZ());
						klon.setAnzFzgAbschnitt(getAnzFzgAbschnitt());
						klon.setN(getN());
						klon.setL(getL());
						klon.setKorrekturFahrzeuge(getKorrekturFahrzeuge());
						klon.setKorrekturLaenge(getKorrekturLaenge());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
