/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zwischenergebnisse der Stauprognose.
<p>
&lt;absatz&gt;
						Zwischenergebnisse der Stauprognose
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 21
 */
public class AtlNbaZwischenErgebnisseStau implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _zeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _zufluss
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _abfluss
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _zuUndAbfahrten
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _deltaN
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _anzahlFzgImStau
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _staulaenge
			;
			private 	RelativerZeitstempel
			 _verlustzeit
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseAbschnitt
			> _abschnitte = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseAbschnitt
			>(0, true);
	
		/**
		Zeitstempel des Prognoseintervall.
		<p>
		
		</p>
		
		@return der Wert von Zeit.
		*/
			public 	Zeitstempel
			 getZeit() {
			return _zeit;
		}
	
		/**
		Zeitstempel des Prognoseintervall.
		<p>
		
		</p>
		
		@param _zeit der neue Wert von Zeit.
		*/
		public void setZeit(	Zeitstempel
		 _zeit) {
			this._zeit = _zeit;
		}
	
		/**
		zufließende Verkehrsmenge für das Prognoseintervall.
		<p>
		
		</p>
		
		@return der Wert von Zufluss.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 getZufluss() {
			return _zufluss;
		}
	
		/**
		zufließende Verkehrsmenge für das Prognoseintervall.
		<p>
		
		</p>
		
		@param _zufluss der neue Wert von Zufluss.
		*/
		public void setZufluss(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
		 _zufluss) {
			this._zufluss = _zufluss;
		}
	
		/**
		abfließende Verkehrsmenge für das Prognoseintervall.
		<p>
		
		</p>
		
		@return der Wert von Abfluss.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 getAbfluss() {
			return _abfluss;
		}
	
		/**
		abfließende Verkehrsmenge für das Prognoseintervall.
		<p>
		
		</p>
		
		@param _abfluss der neue Wert von Abfluss.
		*/
		public void setAbfluss(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
		 _abfluss) {
			this._abfluss = _abfluss;
		}
	
		/**
		Verkehrsmenge an den Zu- und Abfahrten innerhalb des Staus für das Prognoseintervall.
		<p>
		
		</p>
		
		@return der Wert von ZuUndAbfahrten.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 getZuUndAbfahrten() {
			return _zuUndAbfahrten;
		}
	
		/**
		Verkehrsmenge an den Zu- und Abfahrten innerhalb des Staus für das Prognoseintervall.
		<p>
		
		</p>
		
		@param _zuUndAbfahrten der neue Wert von ZuUndAbfahrten.
		*/
		public void setZuUndAbfahrten(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
		 _zuUndAbfahrten) {
			this._zuUndAbfahrten = _zuUndAbfahrten;
		}
	
		/**
		neu angestaute Fahrzeugmenge für das Prognoseintervall.
		<p>
		
		</p>
		
		@return der Wert von DeltaN.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 getDeltaN() {
			return _deltaN;
		}
	
		/**
		neu angestaute Fahrzeugmenge für das Prognoseintervall.
		<p>
		
		</p>
		
		@param _deltaN der neue Wert von DeltaN.
		*/
		public void setDeltaN(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
		 _deltaN) {
			this._deltaN = _deltaN;
		}
	
		/**
		angestaute Fahrzeugmenge für das Prognoseintervall.
		<p>
		
		</p>
		
		@return der Wert von AnzahlFzgImStau.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 getAnzahlFzgImStau() {
			return _anzahlFzgImStau;
		}
	
		/**
		angestaute Fahrzeugmenge für das Prognoseintervall.
		<p>
		
		</p>
		
		@param _anzahlFzgImStau der neue Wert von AnzahlFzgImStau.
		*/
		public void setAnzahlFzgImStau(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
		 _anzahlFzgImStau) {
			this._anzahlFzgImStau = _anzahlFzgImStau;
		}
	
		/**
		Staulänge für das Prognoseintervall.
		<p>
		
		</p>
		
		@return der Wert von Staulaenge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getStaulaenge() {
			return _staulaenge;
		}
	
		/**
		Staulänge für das Prognoseintervall.
		<p>
		
		</p>
		
		@param _staulaenge der neue Wert von Staulaenge.
		*/
		public void setStaulaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _staulaenge) {
			this._staulaenge = _staulaenge;
		}
	
		/**
		Verlustzeit im Stau.
		<p>
		
		</p>
		
		@return der Wert von Verlustzeit.
		*/
			public 	RelativerZeitstempel
			 getVerlustzeit() {
			return _verlustzeit;
		}
	
		/**
		Verlustzeit im Stau.
		<p>
		
		</p>
		
		@param _verlustzeit der neue Wert von Verlustzeit.
		*/
		public void setVerlustzeit(	RelativerZeitstempel
		 _verlustzeit) {
			this._verlustzeit = _verlustzeit;
		}
	
		/**
		Detaillierte Zwischenergebnisse der einzelnen Abschnitte.
		<p>
		
		</p>
		
		@return der Wert von Abschnitte.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseAbschnitt
			> getAbschnitte() {
			return _abschnitte;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeit").setMillis(getZeit().getTime());
				// GanzzahlAttributTyp
				if (getZufluss() != null) {
	                if (getZufluss().isZustand()) {
	                    datum.getUnscaledValue("Zufluss").setText(getZufluss().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Zufluss").set(getZufluss().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAbfluss() != null) {
	                if (getAbfluss().isZustand()) {
	                    datum.getUnscaledValue("Abfluss").setText(getAbfluss().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Abfluss").set(getAbfluss().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getZuUndAbfahrten() != null) {
	                if (getZuUndAbfahrten().isZustand()) {
	                    datum.getUnscaledValue("ZuUndAbfahrten").setText(getZuUndAbfahrten().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ZuUndAbfahrten").set(getZuUndAbfahrten().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getDeltaN() != null) {
	                if (getDeltaN().isZustand()) {
	                    datum.getUnscaledValue("DeltaN").setText(getDeltaN().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("DeltaN").set(getDeltaN().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAnzahlFzgImStau() != null) {
	                if (getAnzahlFzgImStau().isZustand()) {
	                    datum.getUnscaledValue("AnzahlFzgImStau").setText(getAnzahlFzgImStau().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AnzahlFzgImStau").set(getAnzahlFzgImStau().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getStaulaenge() != null) {
	                if (getStaulaenge().isZustand()) {
	                    datum.getUnscaledValue("Staulänge").setText(getStaulaenge().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Staulänge").set(getStaulaenge().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("Verlustzeit").setMillis(getVerlustzeit().getTime());
				// AttributListenDefinition
					final Data.Array arrayAbschnitte = datum.getArray("Abschnitte");
					arrayAbschnitte.setLength(getAbschnitte().size());
					for (int i = 0; i < arrayAbschnitte.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseAbschnitt
						 atl = getAbschnitte().get(i);
						atl.bean2Atl(arrayAbschnitte.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setZeit(new
						Zeitstempel
						(daten.getTimeValue("Zeit").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Zufluss").isState()) {
							setZufluss(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							.getZustand(daten.getScaledValue("Zufluss").getText()));
						} else {
						setZufluss(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
						(daten.
							getUnscaledValue
						("Zufluss").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Abfluss").isState()) {
							setAbfluss(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							.getZustand(daten.getScaledValue("Abfluss").getText()));
						} else {
						setAbfluss(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
						(daten.
							getUnscaledValue
						("Abfluss").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ZuUndAbfahrten").isState()) {
							setZuUndAbfahrten(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							.getZustand(daten.getScaledValue("ZuUndAbfahrten").getText()));
						} else {
						setZuUndAbfahrten(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
						(daten.
							getUnscaledValue
						("ZuUndAbfahrten").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("DeltaN").isState()) {
							setDeltaN(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							.getZustand(daten.getScaledValue("DeltaN").getText()));
						} else {
						setDeltaN(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
						(daten.
							getUnscaledValue
						("DeltaN").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AnzahlFzgImStau").isState()) {
							setAnzahlFzgImStau(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							.getZustand(daten.getScaledValue("AnzahlFzgImStau").getText()));
						} else {
						setAnzahlFzgImStau(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
						(daten.
							getUnscaledValue
						("AnzahlFzgImStau").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Staulänge").isState()) {
							setStaulaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("Staulänge").getText()));
						} else {
						setStaulaenge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("Staulänge").
								longValue
						()));
						}
				// ZeitstempelAttributTyp
					setVerlustzeit(new
						RelativerZeitstempel
						(daten.getTimeValue("Verlustzeit").getMillis()));
				// AttributListenDefinition
					final Data.Array arrayAbschnitte = daten.getArray("Abschnitte");
					for (int i = 0; i < arrayAbschnitte.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseAbschnitt
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseAbschnitt
						 ();
						atl.atl2Bean(arrayAbschnitte.getItem(i), factory);
						getAbschnitte().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaZwischenErgebnisseStau clone() {
		AtlNbaZwischenErgebnisseStau klon = new AtlNbaZwischenErgebnisseStau();
		
						klon.setZeit(getZeit());
						klon.setZufluss(getZufluss());
						klon.setAbfluss(getAbfluss());
						klon.setZuUndAbfahrten(getZuUndAbfahrten());
						klon.setDeltaN(getDeltaN());
						klon.setAnzahlFzgImStau(getAnzahlFzgImStau());
						klon.setStaulaenge(getStaulaenge());
						klon.setVerlustzeit(getVerlustzeit());
					klon._abschnitte = getAbschnitte().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
