/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Objekte für die Bestimmung des Abfluss.
<p>
&lt;absatz&gt;
						Objekte für die Bestimmung des Abfluss.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 32
 */
public class AtlNbaZwischenErgebnisseStauObjekteAbfluss implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
			> _betrachteteStrassenTeilSegmente = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
			>(0, true);
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
			 _strassenTeilSegmentMitGeringstemDurchsatz
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _offset
			;
	
		/**
		Berücksichtigte Straßenteilsegmente bei der Bestimmung des Abfluss.
		<p>
		
		</p>
		
		@return der Wert von BetrachteteStrassenTeilSegmente.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
			> getBetrachteteStrassenTeilSegmente() {
			return _betrachteteStrassenTeilSegmente;
		}
	
	
		/**
		Straßenteilsegment mit dem geringsten Durchsatz.
		<p>
		
		</p>
		
		@return der Wert von StrassenTeilSegmentMitGeringstemDurchsatz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
			 getStrassenTeilSegmentMitGeringstemDurchsatz() {
			return _strassenTeilSegmentMitGeringstemDurchsatz;
		}
	
		/**
		Straßenteilsegment mit dem geringsten Durchsatz.
		<p>
		
		</p>
		
		@param _strassenTeilSegmentMitGeringstemDurchsatz der neue Wert von StrassenTeilSegmentMitGeringstemDurchsatz.
		*/
		public void setStrassenTeilSegmentMitGeringstemDurchsatz(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
		 _strassenTeilSegmentMitGeringstemDurchsatz) {
			this._strassenTeilSegmentMitGeringstemDurchsatz = _strassenTeilSegmentMitGeringstemDurchsatz;
		}
	
		/**
		Offset des Abschnitts innerhalb des Strassenteilsegments mit dem geringstem Durchsatz.
		<p>
		
		</p>
		
		@return der Wert von Offset.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getOffset() {
			return _offset;
		}
	
		/**
		Offset des Abschnitts innerhalb des Strassenteilsegments mit dem geringstem Durchsatz.
		<p>
		
		</p>
		
		@param _offset der neue Wert von Offset.
		*/
		public void setOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _offset) {
			this._offset = _offset;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayBetrachteteStrassenTeilSegmente = datum.getReferenceArray("BetrachteteStrassenTeilSegmente");
					arrayBetrachteteStrassenTeilSegmente.setLength(getBetrachteteStrassenTeilSegmente().size());
					for (int i = 0; i < arrayBetrachteteStrassenTeilSegmente.getLength(); ++i) {
						final Object soBetrachteteStrassenTeilSegmente = getBetrachteteStrassenTeilSegmente().get(i);
						final SystemObject tmpBetrachteteStrassenTeilSegmente;
						if (soBetrachteteStrassenTeilSegmente instanceof SystemObject) {
							tmpBetrachteteStrassenTeilSegmente = (SystemObject)soBetrachteteStrassenTeilSegmente;
						} else if(soBetrachteteStrassenTeilSegmente instanceof SystemObjekt){
							tmpBetrachteteStrassenTeilSegmente = ((SystemObjekt)soBetrachteteStrassenTeilSegmente).getSystemObject();
						} else{
							tmpBetrachteteStrassenTeilSegmente = null;
						}
						arrayBetrachteteStrassenTeilSegmente.getReferenceValue(i).setSystemObject(tmpBetrachteteStrassenTeilSegmente);
					}
				// ObjektReferenzAttributTyp
					final Object soStrassenTeilSegmentMitGeringstemDurchsatz = getStrassenTeilSegmentMitGeringstemDurchsatz();
					final SystemObject tmpStrassenTeilSegmentMitGeringstemDurchsatz;
						if (soStrassenTeilSegmentMitGeringstemDurchsatz instanceof SystemObject) {
							tmpStrassenTeilSegmentMitGeringstemDurchsatz = (SystemObject)soStrassenTeilSegmentMitGeringstemDurchsatz;
						} else if(soStrassenTeilSegmentMitGeringstemDurchsatz instanceof SystemObjekt){
							tmpStrassenTeilSegmentMitGeringstemDurchsatz = ((SystemObjekt)soStrassenTeilSegmentMitGeringstemDurchsatz).getSystemObject();
						} else{
							tmpStrassenTeilSegmentMitGeringstemDurchsatz = null;
						}
					datum.getReferenceValue("StraßenTeilSegmentMitGeringstemDurchsatz").setSystemObject(tmpStrassenTeilSegmentMitGeringstemDurchsatz);
				// GanzzahlAttributTyp
				if (getOffset() != null) {
	                if (getOffset().isZustand()) {
	                    datum.getUnscaledValue("Offset").setText(getOffset().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Offset").set(getOffset().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayBetrachteteStrassenTeilSegmente = daten.getReferenceArray("BetrachteteStrassenTeilSegmente");
					for (int i = 0; i < arrayBetrachteteStrassenTeilSegmente.getLength(); ++i) {
						final long idBetrachteteStrassenTeilSegmente = daten.getReferenceArray("BetrachteteStrassenTeilSegmente").getReferenceValue(i).getId();
						final SystemObjekt tmpBetrachteteStrassenTeilSegmente;
						if (idBetrachteteStrassenTeilSegmente == 0) {
							tmpBetrachteteStrassenTeilSegmente = null;
						} else {
							final SystemObject soBetrachteteStrassenTeilSegmente = factory.getDav().getDataModel().getObject(idBetrachteteStrassenTeilSegmente);
							if (soBetrachteteStrassenTeilSegmente == null) {
									tmpBetrachteteStrassenTeilSegmente = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrassenTeilSegmentUngueltig(idBetrachteteStrassenTeilSegmente);
							} else {
								tmpBetrachteteStrassenTeilSegmente = factory.getModellobjekt(soBetrachteteStrassenTeilSegmente);
							}
						}
							getBetrachteteStrassenTeilSegmente().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
							) tmpBetrachteteStrassenTeilSegmente);
					}
				// ObjektReferenzAttributTyp
					final long idStrassenTeilSegmentMitGeringstemDurchsatz = daten.getReferenceValue("StraßenTeilSegmentMitGeringstemDurchsatz").getId();
					final SystemObjekt tmpStrassenTeilSegmentMitGeringstemDurchsatz;
					if (idStrassenTeilSegmentMitGeringstemDurchsatz == 0) {
						tmpStrassenTeilSegmentMitGeringstemDurchsatz = null;
					} else {
						final SystemObject soStrassenTeilSegmentMitGeringstemDurchsatz = factory.getDav().getDataModel().getObject(idStrassenTeilSegmentMitGeringstemDurchsatz);
						if (soStrassenTeilSegmentMitGeringstemDurchsatz == null) {
								tmpStrassenTeilSegmentMitGeringstemDurchsatz = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrassenTeilSegmentUngueltig(idStrassenTeilSegmentMitGeringstemDurchsatz);
						} else {
							tmpStrassenTeilSegmentMitGeringstemDurchsatz = factory.getModellobjekt(soStrassenTeilSegmentMitGeringstemDurchsatz);
						}
					}
					setStrassenTeilSegmentMitGeringstemDurchsatz((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
					) tmpStrassenTeilSegmentMitGeringstemDurchsatz);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Offset").isState()) {
							setOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("Offset").getText()));
						} else {
						setOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("Offset").
								longValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaZwischenErgebnisseStauObjekteAbfluss clone() {
		AtlNbaZwischenErgebnisseStauObjekteAbfluss klon = new AtlNbaZwischenErgebnisseStauObjekteAbfluss();
		
					klon._betrachteteStrassenTeilSegmente = getBetrachteteStrassenTeilSegmente().clone();
						klon.setStrassenTeilSegmentMitGeringstemDurchsatz(getStrassenTeilSegmentMitGeringstemDurchsatz());
						klon.setOffset(getOffset());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
