/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Objekte für die Bestimmung des Zu- und Abfahrten.
<p>
&lt;absatz&gt;
						Objekte für die Bestimmung der Zu- und Abfahrten.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 31
 */
public class AtlNbaZwischenErgebnisseStauObjekteZuUndAbfahrten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			> _einfahrendeMessQuerschnitteImStau = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			> _ausfahrendeMessQuerschnitteImStau = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			>(0, true);
	
		/**
		Einfahrende Messquerschnitte innerhalb des Staus.
		<p>
		
		</p>
		
		@return der Wert von EinfahrendeMessQuerschnitteImStau.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			> getEinfahrendeMessQuerschnitteImStau() {
			return _einfahrendeMessQuerschnitteImStau;
		}
	
	
		/**
		Ausfahrende Messquerschnitte innerhalb des Staus.
		<p>
		
		</p>
		
		@return der Wert von AusfahrendeMessQuerschnitteImStau.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			> getAusfahrendeMessQuerschnitteImStau() {
			return _ausfahrendeMessQuerschnitteImStau;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayEinfahrendeMessQuerschnitteImStau = datum.getReferenceArray("EinfahrendeMessQuerschnitteImStau");
					arrayEinfahrendeMessQuerschnitteImStau.setLength(getEinfahrendeMessQuerschnitteImStau().size());
					for (int i = 0; i < arrayEinfahrendeMessQuerschnitteImStau.getLength(); ++i) {
						final Object soEinfahrendeMessQuerschnitteImStau = getEinfahrendeMessQuerschnitteImStau().get(i);
						final SystemObject tmpEinfahrendeMessQuerschnitteImStau;
						if (soEinfahrendeMessQuerschnitteImStau instanceof SystemObject) {
							tmpEinfahrendeMessQuerschnitteImStau = (SystemObject)soEinfahrendeMessQuerschnitteImStau;
						} else if(soEinfahrendeMessQuerschnitteImStau instanceof SystemObjekt){
							tmpEinfahrendeMessQuerschnitteImStau = ((SystemObjekt)soEinfahrendeMessQuerschnitteImStau).getSystemObject();
						} else{
							tmpEinfahrendeMessQuerschnitteImStau = null;
						}
						arrayEinfahrendeMessQuerschnitteImStau.getReferenceValue(i).setSystemObject(tmpEinfahrendeMessQuerschnitteImStau);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAusfahrendeMessQuerschnitteImStau = datum.getReferenceArray("AusfahrendeMessQuerschnitteImStau");
					arrayAusfahrendeMessQuerschnitteImStau.setLength(getAusfahrendeMessQuerschnitteImStau().size());
					for (int i = 0; i < arrayAusfahrendeMessQuerschnitteImStau.getLength(); ++i) {
						final Object soAusfahrendeMessQuerschnitteImStau = getAusfahrendeMessQuerschnitteImStau().get(i);
						final SystemObject tmpAusfahrendeMessQuerschnitteImStau;
						if (soAusfahrendeMessQuerschnitteImStau instanceof SystemObject) {
							tmpAusfahrendeMessQuerschnitteImStau = (SystemObject)soAusfahrendeMessQuerschnitteImStau;
						} else if(soAusfahrendeMessQuerschnitteImStau instanceof SystemObjekt){
							tmpAusfahrendeMessQuerschnitteImStau = ((SystemObjekt)soAusfahrendeMessQuerschnitteImStau).getSystemObject();
						} else{
							tmpAusfahrendeMessQuerschnitteImStau = null;
						}
						arrayAusfahrendeMessQuerschnitteImStau.getReferenceValue(i).setSystemObject(tmpAusfahrendeMessQuerschnitteImStau);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayEinfahrendeMessQuerschnitteImStau = daten.getReferenceArray("EinfahrendeMessQuerschnitteImStau");
					for (int i = 0; i < arrayEinfahrendeMessQuerschnitteImStau.getLength(); ++i) {
						final long idEinfahrendeMessQuerschnitteImStau = daten.getReferenceArray("EinfahrendeMessQuerschnitteImStau").getReferenceValue(i).getId();
						final SystemObjekt tmpEinfahrendeMessQuerschnitteImStau;
						if (idEinfahrendeMessQuerschnitteImStau == 0) {
							tmpEinfahrendeMessQuerschnitteImStau = null;
						} else {
							final SystemObject soEinfahrendeMessQuerschnitteImStau = factory.getDav().getDataModel().getObject(idEinfahrendeMessQuerschnitteImStau);
							if (soEinfahrendeMessQuerschnitteImStau == null) {
									tmpEinfahrendeMessQuerschnitteImStau = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idEinfahrendeMessQuerschnitteImStau);
							} else {
								tmpEinfahrendeMessQuerschnitteImStau = factory.getModellobjekt(soEinfahrendeMessQuerschnitteImStau);
							}
						}
							getEinfahrendeMessQuerschnitteImStau().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
							) tmpEinfahrendeMessQuerschnitteImStau);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAusfahrendeMessQuerschnitteImStau = daten.getReferenceArray("AusfahrendeMessQuerschnitteImStau");
					for (int i = 0; i < arrayAusfahrendeMessQuerschnitteImStau.getLength(); ++i) {
						final long idAusfahrendeMessQuerschnitteImStau = daten.getReferenceArray("AusfahrendeMessQuerschnitteImStau").getReferenceValue(i).getId();
						final SystemObjekt tmpAusfahrendeMessQuerschnitteImStau;
						if (idAusfahrendeMessQuerschnitteImStau == 0) {
							tmpAusfahrendeMessQuerschnitteImStau = null;
						} else {
							final SystemObject soAusfahrendeMessQuerschnitteImStau = factory.getDav().getDataModel().getObject(idAusfahrendeMessQuerschnitteImStau);
							if (soAusfahrendeMessQuerschnitteImStau == null) {
									tmpAusfahrendeMessQuerschnitteImStau = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idAusfahrendeMessQuerschnitteImStau);
							} else {
								tmpAusfahrendeMessQuerschnitteImStau = factory.getModellobjekt(soAusfahrendeMessQuerschnitteImStau);
							}
						}
							getAusfahrendeMessQuerschnitteImStau().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
							) tmpAusfahrendeMessQuerschnitteImStau);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaZwischenErgebnisseStauObjekteZuUndAbfahrten clone() {
		AtlNbaZwischenErgebnisseStauObjekteZuUndAbfahrten klon = new AtlNbaZwischenErgebnisseStauObjekteZuUndAbfahrten();
		
					klon._einfahrendeMessQuerschnitteImStau = getEinfahrendeMessQuerschnitteImStau().clone();
					klon._ausfahrendeMessQuerschnitteImStau = getAusfahrendeMessQuerschnitteImStau().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
