/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zwischenergebnisse der Stauprognose pro Stau.
<p>
&lt;absatz&gt;
						Zwischenergebnisse der Stauprognose pro Stau
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 32
 */
public class AtlNbaZwischenErgebnisseStauProStau implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau
			 _stau
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStauObjekteZufluss
			 _objekteZufluss
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStauObjekteZufluss
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStauObjekteAbfluss
			 _objekteAbfluss
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStauObjekteAbfluss
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStauObjekteZuUndAbfahrten
			 _objekteZuUndAbfahrten
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStauObjekteZuUndAbfahrten
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStau
			> _prognose = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStau
			>(0, true);
	
		/**
		Stau für den die ZwischenErgebnisse enthalten sind.
		<p>
		
		</p>
		
		@return der Wert von Stau.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau
			 getStau() {
			return _stau;
		}
	
		/**
		Stau für den die ZwischenErgebnisse enthalten sind.
		<p>
		
		</p>
		
		@param _stau der neue Wert von Stau.
		*/
		public void setStau(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau
		 _stau) {
			this._stau = _stau;
		}
	
		/**
		Objekte für die Bestimmung des Zufluss.
		<p>
		
		</p>
		
		@return der Wert von ObjekteZufluss.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStauObjekteZufluss
			 getObjekteZufluss() {
			return _objekteZufluss;
		}
	
		/**
		Objekte für die Bestimmung des Zufluss.
		<p>
		
		</p>
		
		@param _objekteZufluss der neue Wert von ObjekteZufluss.
		*/
		public void setObjekteZufluss(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStauObjekteZufluss
		 _objekteZufluss) {
			this._objekteZufluss = _objekteZufluss;
		}
	
		/**
		Objekte für die Bestimmung des Abfluss.
		<p>
		
		</p>
		
		@return der Wert von ObjekteAbfluss.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStauObjekteAbfluss
			 getObjekteAbfluss() {
			return _objekteAbfluss;
		}
	
		/**
		Objekte für die Bestimmung des Abfluss.
		<p>
		
		</p>
		
		@param _objekteAbfluss der neue Wert von ObjekteAbfluss.
		*/
		public void setObjekteAbfluss(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStauObjekteAbfluss
		 _objekteAbfluss) {
			this._objekteAbfluss = _objekteAbfluss;
		}
	
		/**
		Objekte für die Bestimmung der Zu- und Abfahrten.
		<p>
		
		</p>
		
		@return der Wert von ObjekteZuUndAbfahrten.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStauObjekteZuUndAbfahrten
			 getObjekteZuUndAbfahrten() {
			return _objekteZuUndAbfahrten;
		}
	
		/**
		Objekte für die Bestimmung der Zu- und Abfahrten.
		<p>
		
		</p>
		
		@param _objekteZuUndAbfahrten der neue Wert von ObjekteZuUndAbfahrten.
		*/
		public void setObjekteZuUndAbfahrten(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStauObjekteZuUndAbfahrten
		 _objekteZuUndAbfahrten) {
			this._objekteZuUndAbfahrten = _objekteZuUndAbfahrten;
		}
	
		/**
		Zwischenergebnisse der Stauprognose über den gesamten Prognosezeitraum.
		<p>
		
		</p>
		
		@return der Wert von Prognose.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStau
			> getPrognose() {
			return _prognose;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soStau = getStau();
					final SystemObject tmpStau;
						if (soStau instanceof SystemObject) {
							tmpStau = (SystemObject)soStau;
						} else if(soStau instanceof SystemObjekt){
							tmpStau = ((SystemObjekt)soStau).getSystemObject();
						} else{
							tmpStau = null;
						}
					datum.getReferenceValue("Stau").setSystemObject(tmpStau);
				// AttributListenDefinition
					getObjekteZufluss().bean2Atl(datum.getItem("ObjekteZufluss"), factory);
				// AttributListenDefinition
					getObjekteAbfluss().bean2Atl(datum.getItem("ObjekteAbfluss"), factory);
				// AttributListenDefinition
					getObjekteZuUndAbfahrten().bean2Atl(datum.getItem("ObjekteZuUndAbfahrten"), factory);
				// AttributListenDefinition
					final Data.Array arrayPrognose = datum.getArray("Prognose");
					arrayPrognose.setLength(getPrognose().size());
					for (int i = 0; i < arrayPrognose.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStau
						 atl = getPrognose().get(i);
						atl.bean2Atl(arrayPrognose.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idStau = daten.getReferenceValue("Stau").getId();
					final SystemObjekt tmpStau;
					if (idStau == 0) {
						tmpStau = null;
					} else {
						final SystemObject soStau = factory.getDav().getDataModel().getObject(idStau);
						if (soStau == null) {
								tmpStau = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StauUngueltig(idStau);
						} else {
							tmpStau = factory.getModellobjekt(soStau);
						}
					}
					setStau((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau
					) tmpStau);
				// AttributListenDefinition
					getObjekteZufluss().atl2Bean(daten.getItem("ObjekteZufluss"), factory);
				// AttributListenDefinition
					getObjekteAbfluss().atl2Bean(daten.getItem("ObjekteAbfluss"), factory);
				// AttributListenDefinition
					getObjekteZuUndAbfahrten().atl2Bean(daten.getItem("ObjekteZuUndAbfahrten"), factory);
				// AttributListenDefinition
					final Data.Array arrayPrognose = daten.getArray("Prognose");
					for (int i = 0; i < arrayPrognose.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStau
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZwischenErgebnisseStau
						 ();
						atl.atl2Bean(arrayPrognose.getItem(i), factory);
						getPrognose().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaZwischenErgebnisseStauProStau clone() {
		AtlNbaZwischenErgebnisseStauProStau klon = new AtlNbaZwischenErgebnisseStauProStau();
		
						klon.setStau(getStau());
						klon._objekteZufluss = getObjekteZufluss().clone();
						klon._objekteAbfluss = getObjekteAbfluss().clone();
						klon._objekteZuUndAbfahrten = getObjekteZuUndAbfahrten().clone();
					klon._prognose = getPrognose().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
