/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
AnzeigenBedeutung für Hinweise für die NBA.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class AttNbaAnzeigenBedeutung extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	1. Textzeile von oben.
	<p>
	
	</p>
	*/
	public static final AttNbaAnzeigenBedeutung ZUSTAND_0_TEXTZEILE1 = new AttNbaAnzeigenBedeutung("Textzeile1", 		Byte
	.valueOf("0"));

	/**
	2. Textzeile von oben.
	<p>
	
	</p>
	*/
	public static final AttNbaAnzeigenBedeutung ZUSTAND_1_TEXTZEILE2 = new AttNbaAnzeigenBedeutung("Textzeile2", 		Byte
	.valueOf("1"));

	/**
	3. Textzeile von oben.
	<p>
	
	</p>
	*/
	public static final AttNbaAnzeigenBedeutung ZUSTAND_2_TEXTZEILE3 = new AttNbaAnzeigenBedeutung("Textzeile3", 		Byte
	.valueOf("2"));

	/**
	Anzeige für WVZ-Inhalte vom Typ 1.
	<p>
	Folgende WVZ-Inhalte sind darstellbar: Achtung, Stau und Baustelle.
	</p>
	*/
	public static final AttNbaAnzeigenBedeutung ZUSTAND_20_PIKTOGRAMMZUSATZ1 = new AttNbaAnzeigenBedeutung("PiktogrammZusatz1", 		Byte
	.valueOf("20"));

	/**
	Anzeige für Centrico-Pfeile vom Typ 1.
	<p>
	
	</p>
	*/
	public static final AttNbaAnzeigenBedeutung ZUSTAND_40_PIKTOGRAMMCENTRICO1 = new AttNbaAnzeigenBedeutung("PiktogrammCentrico1", 		Byte
	.valueOf("40"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttNbaAnzeigenBedeutung getZustand(final 		Byte
	 value) {
		for (AttNbaAnzeigenBedeutung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttNbaAnzeigenBedeutung getZustand(final String value) {
		for (AttNbaAnzeigenBedeutung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttNbaAnzeigenBedeutung> getZustaende() {
		List<AttNbaAnzeigenBedeutung> list = new ArrayList<AttNbaAnzeigenBedeutung>();
		list.add(ZUSTAND_0_TEXTZEILE1);
		list.add(ZUSTAND_1_TEXTZEILE2);
		list.add(ZUSTAND_2_TEXTZEILE3);
		list.add(ZUSTAND_20_PIKTOGRAMMZUSATZ1);
		list.add(ZUSTAND_40_PIKTOGRAMMCENTRICO1);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut NbaAnzeigenBedeutung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttNbaAnzeigenBedeutung(final 		Byte
	 value) {
		super(value);
	}
	
	private AttNbaAnzeigenBedeutung(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
