/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Betriebsart für ein Ziel des Entscheidungspunkts.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class AttNbaEntscheidungspunktBetriebsartZiel extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Das Ziel erzeugt keine Befehle für die Anzeigen.
	<p>
	
	</p>
	*/
	public static final AttNbaEntscheidungspunktBetriebsartZiel ZUSTAND_0_AUS = new AttNbaEntscheidungspunktBetriebsartZiel("Aus", 		Byte
	.valueOf("0"));

	/**
	Das Ziel wird in NormalRichtung erreicht, intern erfolgt keine reisezeitabhängige Umschaltung.
	<p>
	
	</p>
	*/
	public static final AttNbaEntscheidungspunktBetriebsartZiel ZUSTAND_1_NORMALRICHTUNG = new AttNbaEntscheidungspunktBetriebsartZiel("NormalRichtung", 		Byte
	.valueOf("1"));

	/**
	Das Ziel wird in der automatisch bestimmten FahrtRichtung erreicht, intern erfolgt reisezeitabhängige Umschaltung.
	<p>
	
	</p>
	*/
	public static final AttNbaEntscheidungspunktBetriebsartZiel ZUSTAND_2_AUTOMATIK = new AttNbaEntscheidungspunktBetriebsartZiel("Automatik", 		Byte
	.valueOf("2"));

	/**
	Das Ziel wird in der separat angegebenen FahrtRichtung erreicht, intern wird mit dieser FahrtRichtung gearbeitet.
	<p>
	
	</p>
	*/
	public static final AttNbaEntscheidungspunktBetriebsartZiel ZUSTAND_3_MANUELL = new AttNbaEntscheidungspunktBetriebsartZiel("Manuell", 		Byte
	.valueOf("3"));

	/**
	Die Betriebsart für das Ziel wird durch die Betriebsart des Entscheidungspunktes festgelegt.
	<p>
	
	</p>
	*/
	public static final AttNbaEntscheidungspunktBetriebsartZiel ZUSTAND_4_UEBERNAHMEBETRIEBSARTENTSCHEIDUNGSPUNKT = new AttNbaEntscheidungspunktBetriebsartZiel("ÜbernahmeBetriebsartEntscheidungspunkt", 		Byte
	.valueOf("4"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttNbaEntscheidungspunktBetriebsartZiel getZustand(final 		Byte
	 value) {
		for (AttNbaEntscheidungspunktBetriebsartZiel e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttNbaEntscheidungspunktBetriebsartZiel getZustand(final String value) {
		for (AttNbaEntscheidungspunktBetriebsartZiel e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttNbaEntscheidungspunktBetriebsartZiel> getZustaende() {
		List<AttNbaEntscheidungspunktBetriebsartZiel> list = new ArrayList<AttNbaEntscheidungspunktBetriebsartZiel>();
		list.add(ZUSTAND_0_AUS);
		list.add(ZUSTAND_1_NORMALRICHTUNG);
		list.add(ZUSTAND_2_AUTOMATIK);
		list.add(ZUSTAND_3_MANUELL);
		list.add(ZUSTAND_4_UEBERNAHMEBETRIEBSARTENTSCHEIDUNGSPUNKT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut NbaEntscheidungspunktBetriebsartZiel.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttNbaEntscheidungspunktBetriebsartZiel(final 		Byte
	 value) {
		super(value);
	}
	
	private AttNbaEntscheidungspunktBetriebsartZiel(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
