/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition der Programmzustände NBA.
<p>
&lt;absatz&gt;
						Es wird festgelegt, in welchen Zuständen und in welchem Wertebereich
            ein Programmstatus versorgt werden kann.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
@Wertebereich(
	minimum = 3L,
	maximum = 10L,
	einheit = ""
)
public class AttNbaProgrammStatus extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MIN_VALUE =
				Byte
		.valueOf("3");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MAX_VALUE =
				Byte
		.valueOf("10");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaProgrammStatus ZUSTAND_1N_UNDEFINIERT = new AttNbaProgrammStatus("Undefiniert", 		Byte
	.valueOf("-1"));

	/**
	Anzeigeinhalt erzeugt durch ein Automatikprogramm der lokalen Steuerung.
	<p>
	
	</p>
	*/
	public static final AttNbaProgrammStatus ZUSTAND_0_AUTOMATIKLOKALESTEUERUNG = new AttNbaProgrammStatus("AutomatikLokaleSteuerung", 		Byte
	.valueOf("0"));

	/**
	Anzeigeinhalt erzeugt durch ein Sonderprogramm der lokalen Steuerung.
	<p>
	
	</p>
	*/
	public static final AttNbaProgrammStatus ZUSTAND_1_SONDERPROGRAMMLOKALESTEUERUNG = new AttNbaProgrammStatus("SonderprogrammLokaleSteuerung", 		Byte
	.valueOf("1"));

	/**
	Anzeigeinhalt erzeugt durch ein Automatikprogramm der netzweiten Steuerung.
	<p>
	
	</p>
	*/
	public static final AttNbaProgrammStatus ZUSTAND_2_AUTOMATIKNETZWEITESTEUERUNG = new AttNbaProgrammStatus("AutomatikNetzweiteSteuerung", 		Byte
	.valueOf("2"));

	/**
	Anzeigeinhalt erzeugt durch ein Handprogramm.
	<p>
	
	</p>
	*/
	public static final AttNbaProgrammStatus ZUSTAND_3_HANDPROGRAMM = new AttNbaProgrammStatus("Handprogramm", 		Byte
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttNbaProgrammStatus getZustand(final 		Byte
	 value) {
		for (AttNbaProgrammStatus e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttNbaProgrammStatus getZustand(final String value) {
		for (AttNbaProgrammStatus e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttNbaProgrammStatus> getZustaende() {
		List<AttNbaProgrammStatus> list = new ArrayList<AttNbaProgrammStatus>();
		list.add(ZUSTAND_1N_UNDEFINIERT);
		list.add(ZUSTAND_0_AUTOMATIKLOKALESTEUERUNG);
		list.add(ZUSTAND_1_SONDERPROGRAMMLOKALESTEUERUNG);
		list.add(ZUSTAND_2_AUTOMATIKNETZWEITESTEUERUNG);
		list.add(ZUSTAND_3_HANDPROGRAMM);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut nbaProgrammStatus.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttNbaProgrammStatus(final 		Byte
	 value) {
		super(value);
	}
	
	private AttNbaProgrammStatus(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
