/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Betriebsart einer Ursacheneinheit.
<p>
&lt;absatz&gt;
						Mögliche Betriebsarten einer Ursacheneinheit.
						0 = immer aus, 1 = immer ein, 2 = Open Loop, 3 = Automatik, -1 = nicht definiert
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttNbaUeBetriebsart extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUeBetriebsart ZUSTAND_1N_NICHT_DEFINIERT = new AttNbaUeBetriebsart("nicht definiert", 		Byte
	.valueOf("-1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUeBetriebsart ZUSTAND_0_IMMER_AUS = new AttNbaUeBetriebsart("immer aus", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUeBetriebsart ZUSTAND_1_IMMER_EIN = new AttNbaUeBetriebsart("immer ein", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUeBetriebsart ZUSTAND_2_OPEN_LOOP = new AttNbaUeBetriebsart("Open Loop", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUeBetriebsart ZUSTAND_3_AUTOMATIK = new AttNbaUeBetriebsart("Automatik", 		Byte
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttNbaUeBetriebsart getZustand(final 		Byte
	 value) {
		for (AttNbaUeBetriebsart e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttNbaUeBetriebsart getZustand(final String value) {
		for (AttNbaUeBetriebsart e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttNbaUeBetriebsart> getZustaende() {
		List<AttNbaUeBetriebsart> list = new ArrayList<AttNbaUeBetriebsart>();
		list.add(ZUSTAND_1N_NICHT_DEFINIERT);
		list.add(ZUSTAND_0_IMMER_AUS);
		list.add(ZUSTAND_1_IMMER_EIN);
		list.add(ZUSTAND_2_OPEN_LOOP);
		list.add(ZUSTAND_3_AUTOMATIK);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut nbaUeBetriebsart.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttNbaUeBetriebsart(final 		Byte
	 value) {
		super(value);
	}
	
	private AttNbaUeBetriebsart(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
