/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Positive Zahl mit 1 Machkommastelle im Bereich von 0,1 bis 1,0 (z.B. für Parameter).
<p>
&lt;absatz&gt;
						Es wird festgelegt, welcher Wertebereich bzw. Zustände der Wert
						annehmen kann.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 10L,
	skalierung = 0.1,
	einheit = ""
)
public class AttZahlPositiv1NachKommaStellenVon0Bis1 extends Zahl<		Double
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Double
	 MIN_VALUE =
			(		double
			) (		Double
			.valueOf("0") * 		Double
			.valueOf("0.1"));	
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Double
	 MAX_VALUE =
			(		double
			) (		Double
			.valueOf("10") * 		Double
			.valueOf("0.1"));	
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	
	/**
	 * Erzeugte eine neues Attribut ZahlPositiv1NachKommaStellenVon0Bis1.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttZahlPositiv1NachKommaStellenVon0Bis1(final 		Double
	 value) {
		super(value);
	}
	
	private AttZahlPositiv1NachKommaStellenVon0Bis1(final String zustand, final 		Double
	 value) {
		super(zustand, value);
	}
	
}
