/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Entscheidungspunkt für die Netzweite Steuerung.
<p>
&lt;absatz&gt;
						Entscheidungspunkt für die Netzweite Steuerung.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public interface NbaEntscheidungspunkt extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.nbaEntscheidungspunkt"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Festlegungen für Betriebsmeldungen für die Ziele des Entscheidungspunktes für die NBA.
	<p>
	
	</p>
	@return der Datensatz NbaEntscheidungspunktBetriebsmeldung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktBetriebsmeldung getPdNbaEntscheidungspunktBetriebsmeldung();
	
	/**
	Templates für die Hinweisanzeige an den AnzeigeQuerschnitten des Entscheidungspunktes.
	<p>
	
	</p>
	@return der Datensatz NbaEntscheidungspunktHinweisTemplates.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktHinweisTemplates getPdNbaEntscheidungspunktHinweisTemplates();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Abfluss-MessQuerschnitte pro Fahrtrichtung für den Entscheidungspunkt.
	<p>
	
	</p>
	@return der Datensatz NbaEntscheidungspunktZuordnungMessQuerschnittZuFahrtRichtung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten.KdNbaEntscheidungspunktZuordnungMessQuerschnittZuFahrtRichtung getKdNbaEntscheidungspunktZuordnungMessQuerschnittZuFahrtRichtung();
	
	/**
	Schaltbilder für alle Ziel-FahrtRichtungs-Kombinationen des Entscheidungspunktes.
	<p>
	
	</p>
	@return der Datensatz NbaEntscheidungspunktSchaltbilder.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktSchaltbilder getPdNbaEntscheidungspunktSchaltbilder();
	
	/**
	Betriebs-Parameter des Entscheidungspunktes.
	<p>
	
	</p>
	@return der Datensatz NbaEntscheidungspunktBetriebsParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktBetriebsParameter getPdNbaEntscheidungspunktBetriebsParameter();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	AnzeigeQuerschnitte mit der Zuordnung der Anzeigen zur FahrtRichtung mit Bedeutung der Anzeigen für Hinweise für die NBA.
	<p>
	
	</p>
	@return der Datensatz NbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten.KdNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtung getKdNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtung();
	
	/**
	RoutenStücke für alle FahrtRichtungen die für die Anzeige von Hinweisen relevant sind.
	<p>
	
	</p>
	@return der Datensatz NbaEntscheidungspunktRoutenStueckeFuerHinweise.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktRoutenStueckeFuerHinweise getPdNbaEntscheidungspunktRoutenStueckeFuerHinweise();
	
	/**
	ReisezeitHysterese für alle Ziele des Entscheidungspunktes für die NBA.
	<p>
	
	</p>
	@return der Datensatz NbaEntscheidungspunktReisezeitHysterese.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktReisezeitHysterese getPdNbaEntscheidungspunktReisezeitHysterese();
	
	/**
	Konfigurierende Eigenschaften des Entscheidungspunktes.
	<p>
	
	</p>
	@return der Datensatz NbaEntscheidungspunkt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten.KdNbaEntscheidungspunkt getKdNbaEntscheidungspunkt();
	
	/**
	Ziel-FahrtRichtungs-Kombinationen der statischen FahrtRichtungen des Entscheidungspunktes.
	<p>
	
	</p>
	@return der Datensatz NbaEntscheidungspunktStatischeFahrtRichtungen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktStatischeFahrtRichtungen getPdNbaEntscheidungspunktStatischeFahrtRichtungen();
	
	/**
	Ziel-FahrtRichtungs-Kombinationen der normalen FahrtRichtungen des Entscheidungspunktes.
	<p>
	
	</p>
	@return der Datensatz NbaEntscheidungspunktNormalFahrtRichtungen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktNormalFahrtRichtungen getPdNbaEntscheidungspunktNormalFahrtRichtungen();
	
	/**
	ReisezeitAlgorithmus für alle Ziele des Entscheidungspunktes für die NBA.
	<p>
	
	</p>
	@return der Datensatz NbaEntscheidungspunktReisezeitAlgorithmus.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktReisezeitAlgorithmus getPdNbaEntscheidungspunktReisezeitAlgorithmus();
	
	/**
	Prioritäten für die Hinweisanzeige an den AnzeigeQuerschnitten des Entscheidungspunktes.
	<p>
	
	</p>
	@return der Datensatz NbaEntscheidungspunktHinweisPrioritaet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktHinweisPrioritaet getPdNbaEntscheidungspunktHinweisPrioritaet();
	
	/**
	Betriebs-Parameter für die Ziele des Entscheidungspunktes.
	<p>
	
	</p>
	@return der Datensatz NbaEntscheidungspunktBetriebsParameterZiel.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktBetriebsParameterZiel getPdNbaEntscheidungspunktBetriebsParameterZiel();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
