/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Messquerschnitt für die NBA.
<p>
&lt;absatz&gt;
						Ein nbaMessQuerschnitt ist ein persistentes dynamisches Objekt, das nicht vom Benutzer konfiguriert oder parametriert werden kann.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Zu einem nbaMessQuerschnitt werden als konfigurierende Eigenschaften eine Referenz
						auf einen realen MessQuerschnitt verwaltet.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface NbaMessQuerschnitt extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.nbaMessQuerschnitt"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Ausgewähltes Fundamentaldiagramm pro
						StraßenTeilSegment.
	<p>
	
	</p>
	@return der Datensatz NbaFundamentaldiagrammAuswahl.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdNbaFundamentaldiagrammAuswahl getPdNbaFundamentaldiagrammAuswahl();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Parameter für die Ermittlung der Verkehrssituation.
	<p>
	
	</p>
	@return der Datensatz NbaParameterVerkehrssituation.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterVerkehrssituation getPdNbaParameterVerkehrssituation();
	
	/**
	Ergebnisdaten Aggregation der Prognoseüberwachung.
	<p>
	
	</p>
	@return der Datensatz NbaUeberwachungPrognoseAggregation.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdNbaUeberwachungPrognoseAggregation getOdNbaUeberwachungPrognoseAggregation();
	
	/**
	Ergebnisdaten Überwachung der Prognoseganglinie.
	<p>
	
	</p>
	@return der Datensatz NbaUeberwachungPrognoseGanglinie.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdNbaUeberwachungPrognoseGanglinie getOdNbaUeberwachungPrognoseGanglinie();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Verkehrszustandsprognose pro StraßenTeilSegment.
	<p>
	
	</p>
	@return der Datensatz NbaPrognoseGanglinie.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdNbaPrognoseGanglinie getPdNbaPrognoseGanglinie();
	
	/**
	Prognose der Stauentwicklung pro StraßenTeilSegment.
	<p>
	
	</p>
	@return der Datensatz NbaDatenStauPrognose.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdNbaDatenStauPrognose getOdNbaDatenStauPrognose();
	
	/**
	Referenz auf einen realen Messquerschnitt.
	<p>
	
	</p>
	@return der Datensatz NbaMessQuerschnitt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten.KdNbaMessQuerschnitt getKdNbaMessQuerschnitt();
	
	/**
	Ausgewählte Standardganglinie pro StraßenTeilSegment.
	<p>
	
	</p>
	@return der Datensatz NbaGanglinienAuswahl.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdNbaGanglinienAuswahl getPdNbaGanglinienAuswahl();
	
	/**
	Parameter für die Ermittlung der Verkehrssituation Verfahren1 (MARZ).
	<p>
	
	</p>
	@return der Datensatz NbaParameterVerkehrszustandVerfahren1.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterVerkehrszustandVerfahren1 getPdNbaParameterVerkehrszustandVerfahren1();
	
	/**
	Parameter für die Ermittlung der Verkehrssituation Verfahren1 (TMC-Meldungen).
	<p>
	
	</p>
	@return der Datensatz NbaParameterVerkehrszustandVerfahren2.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterVerkehrszustandVerfahren2 getPdNbaParameterVerkehrszustandVerfahren2();
	
	/**
	Parameter für die Ermittlung des Verkehrszustandes.
	<p>
	
	</p>
	@return der Datensatz NbaParameterVerkehrszustandAlgorithmus2.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterVerkehrszustandAlgorithmus2 getPdNbaParameterVerkehrszustandAlgorithmus2();
	
	/**
	Ergebnisdaten Kapazitätsermittlung. Festellung der
						verkehrstechnischen Leistungsfähigkeit pro
						StraßenTeilSegment.
	<p>
	
	</p>
	@return der Datensatz NbaDatenKapazitaetsermittlung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdNbaDatenKapazitaetsermittlung getOdNbaDatenKapazitaetsermittlung();
	
	/**
	Parameter für die Ermittlung der Verkehrssituation.
	<p>
	
	</p>
	@return der Datensatz NbaParameterVerkehrszustandAlgorithmus1.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterVerkehrszustandAlgorithmus1 getPdNbaParameterVerkehrszustandAlgorithmus1();
	
	/**
	Parameter für die Ermittlung des Verkehrszustandes.
	<p>
	
	</p>
	@return der Datensatz NbaParameterVerkehrszustandAlgorithmus3.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterVerkehrszustandAlgorithmus3 getPdNbaParameterVerkehrszustandAlgorithmus3();
	
	/**
	Ergebnisdaten Fundamentaldiagramm.
	<p>
	
	</p>
	@return der Datensatz NbaFundamentaldiagramm.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaFundamentaldiagramm getPdNbaFundamentaldiagramm();
	
	/**
	Parameter für das Objekt nbaGanglinie.
	<p>
	
	</p>
	@return der Datensatz NbaGanglinie.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaGanglinie getPdNbaGanglinie();
	
	/**
	Ergebnisdaten Verkehrszustandsanalyse pro
						StraßenTeilSegment.
	<p>
	
	</p>
	@return der Datensatz NbaDatenVerkehrszustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdNbaDatenVerkehrszustand getOdNbaDatenVerkehrszustand();
	
	/**
	Diagnosedaten für die Reisezeitprognose am MessQuerschnitt.
	<p>
	
	</p>
	@return der Datensatz NbaMessQuerschnittReisezeitPrognoseDiagnose.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdNbaMessQuerschnittReisezeitPrognoseDiagnose getOdNbaMessQuerschnittReisezeitPrognoseDiagnose();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
