/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Stellvetreter für AnzeigeQuerschnitt im Bereich der Steuerung.
<p>
&lt;absatz&gt;
						Stellvetreter für AnzeigeQuerschnitt im Bereich der Steuerung. Er wird für Handschaltungen der Bedienoberflächen verwendet.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AnzeigeQuerschnittSteuerungImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.AnzeigeQuerschnittSteuerung { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public AnzeigeQuerschnittSteuerungImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public AnzeigeQuerschnittSteuerungImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein AnzeigeQuerschnittSteuerung.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdHelligkeitSteuerungV1 getPdHelligkeitSteuerungV1() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdHelligkeitSteuerungV1.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaUeSchaltbild getPdNbaUeSchaltbild() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaUeSchaltbild.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdWechseltextZuordnungAnzeigen getPdWechseltextZuordnungAnzeigen() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdWechseltextZuordnungAnzeigen.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdAnzeigeQuerschnittStatusProgramm getOdAnzeigeQuerschnittStatusProgramm() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdAnzeigeQuerschnittStatusProgramm.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdHelligkeitSteuerungStufe getPdHelligkeitSteuerungStufe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdHelligkeitSteuerungStufe.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaUeberwachung getPdNbaUeberwachung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaUeberwachung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdAnzeigeQuerschnittStatusRueckmeldungen getOdAnzeigeQuerschnittStatusRueckmeldungen() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdAnzeigeQuerschnittStatusRueckmeldungen.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdAnzeigeQuerschnittStatusBefehle getOdAnzeigeQuerschnittStatusBefehle() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdAnzeigeQuerschnittStatusBefehle.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdHandeingriffHelligkeit getPdHandeingriffHelligkeit() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdHandeingriffHelligkeit.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten.KdAnzeigeQuerschnittSteuerung getKdAnzeigeQuerschnittSteuerung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten.KdAnzeigeQuerschnittSteuerung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdAnzeigeQuerschnittStatusAllgemein getOdAnzeigeQuerschnittStatusAllgemein() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdAnzeigeQuerschnittStatusAllgemein.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdAnzeigeQuerschnittStrategien getPdAnzeigeQuerschnittStrategien() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdAnzeigeQuerschnittStrategien.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdHandeingriffBetriebsart getPdHandeingriffBetriebsart() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdHandeingriffBetriebsart.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
