/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Entscheidungspunkt für die Netzweite Steuerung.
<p>
&lt;absatz&gt;
						Entscheidungspunkt für die Netzweite Steuerung.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class NbaEntscheidungspunktImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public NbaEntscheidungspunktImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public NbaEntscheidungspunktImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein Entscheidungspunkt netzweite Steuerung.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktBetriebsmeldung getPdNbaEntscheidungspunktBetriebsmeldung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktBetriebsmeldung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktHinweisTemplates getPdNbaEntscheidungspunktHinweisTemplates() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktHinweisTemplates.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten.KdNbaEntscheidungspunktZuordnungMessQuerschnittZuFahrtRichtung getKdNbaEntscheidungspunktZuordnungMessQuerschnittZuFahrtRichtung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten.KdNbaEntscheidungspunktZuordnungMessQuerschnittZuFahrtRichtung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktSchaltbilder getPdNbaEntscheidungspunktSchaltbilder() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktSchaltbilder.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktBetriebsParameter getPdNbaEntscheidungspunktBetriebsParameter() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktBetriebsParameter.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten.KdNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtung getKdNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten.KdNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktRoutenStueckeFuerHinweise getPdNbaEntscheidungspunktRoutenStueckeFuerHinweise() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktRoutenStueckeFuerHinweise.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktReisezeitHysterese getPdNbaEntscheidungspunktReisezeitHysterese() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktReisezeitHysterese.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten.KdNbaEntscheidungspunkt getKdNbaEntscheidungspunkt() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten.KdNbaEntscheidungspunkt.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktStatischeFahrtRichtungen getPdNbaEntscheidungspunktStatischeFahrtRichtungen() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktStatischeFahrtRichtungen.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktNormalFahrtRichtungen getPdNbaEntscheidungspunktNormalFahrtRichtungen() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktNormalFahrtRichtungen.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktReisezeitAlgorithmus getPdNbaEntscheidungspunktReisezeitAlgorithmus() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktReisezeitAlgorithmus.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktHinweisPrioritaet getPdNbaEntscheidungspunktHinweisPrioritaet() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktHinweisPrioritaet.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktBetriebsParameterZiel getPdNbaEntscheidungspunktBetriebsParameterZiel() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaEntscheidungspunktBetriebsParameterZiel.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
