/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnisdaten Aggregation der Prognoseüberwachung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 42
 */
public class OdNbaUeberwachungPrognoseAggregation extends AbstractOnlineDatensatz<OdNbaUeberwachungPrognoseAggregation.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.NbaAggregationJahr,
					Aspekte.NbaAggregationTag,
					Aspekte.NbaAggregationStunde,
					Aspekte.NbaAggregationWoche,
					Aspekte.NbaAggregationMonat,
				};
			}
	
			/**
			 * Statistik Jahr.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt NbaAggregationJahr = new Aspekte("AggregationJahr", "asp.nbaAggregationJahr");
			
			/**
			 * Statistik Tag.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt NbaAggregationTag = new Aspekte("AggregationTag", "asp.nbaAggregationTag");
			
			/**
			 * Statistik Stunde.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt NbaAggregationStunde = new Aspekte("AggregationStunde", "asp.nbaAggregationStunde");
			
			/**
			 * Statistik Woche.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt NbaAggregationWoche = new Aspekte("AggregationWoche", "asp.nbaAggregationWoche");
			
			/**
			 * Statistik Monat.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt NbaAggregationMonat = new Aspekte("AggregationMonat", "asp.nbaAggregationMonat");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	RelativerZeitstempel
				 _prognoseHorizont
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _mittlereAbweichung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _standardAbweichung
				;
		
			/**
			Prognosehorizont der Aggregation.
			<p>
			
			</p>
			
			@return der Wert von PrognoseHorizont.
			*/
				public 	RelativerZeitstempel
				 getPrognoseHorizont() {
				return _prognoseHorizont;
			}
		
			/**
			Prognosehorizont der Aggregation.
			<p>
			
			</p>
			
			@param _prognoseHorizont der neue Wert von PrognoseHorizont.
			*/
			public void setPrognoseHorizont(	RelativerZeitstempel
			 _prognoseHorizont) {
				this._prognoseHorizont = _prognoseHorizont;
			}
		
			/**
			mittlere absolute Abweichung.
			<p>
			
			</p>
			
			@return der Wert von MittlereAbweichung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getMittlereAbweichung() {
				return _mittlereAbweichung;
			}
		
			/**
			mittlere absolute Abweichung.
			<p>
			
			</p>
			
			@param _mittlereAbweichung der neue Wert von MittlereAbweichung.
			*/
			public void setMittlereAbweichung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _mittlereAbweichung) {
				this._mittlereAbweichung = _mittlereAbweichung;
			}
		
			/**
			Standardabweichung.
			<p>
			
			</p>
			
			@return der Wert von StandardAbweichung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getStandardAbweichung() {
				return _standardAbweichung;
			}
		
			/**
			Standardabweichung.
			<p>
			
			</p>
			
			@param _standardAbweichung der neue Wert von StandardAbweichung.
			*/
			public void setStandardAbweichung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _standardAbweichung) {
				this._standardAbweichung = _standardAbweichung;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("PrognoseHorizont").setMillis(getPrognoseHorizont().getTime());
					// GanzzahlAttributTyp
					if (getMittlereAbweichung() != null) {
		                if (getMittlereAbweichung().isZustand()) {
		                    datum.getUnscaledValue("mittlereAbweichung").setText(getMittlereAbweichung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("mittlereAbweichung").set(getMittlereAbweichung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getStandardAbweichung() != null) {
		                if (getStandardAbweichung().isZustand()) {
		                    datum.getUnscaledValue("StandardAbweichung").setText(getStandardAbweichung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StandardAbweichung").set(getStandardAbweichung().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setPrognoseHorizont(new
							RelativerZeitstempel
							(daten.getTimeValue("PrognoseHorizont").getMillis()));
					// GanzzahlAttributTyp
							setMittlereAbweichung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("mittlereAbweichung").
									longValue
							()));
					// GanzzahlAttributTyp
							setStandardAbweichung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("StandardAbweichung").
									longValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setPrognoseHorizont(getPrognoseHorizont());
							klon.setMittlereAbweichung(getMittlereAbweichung());
							klon.setStandardAbweichung(getStandardAbweichung());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.nbaUeberwachungPrognoseAggregation";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdNbaUeberwachungPrognoseAggregation(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
