/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe für die Definition der zu berechnenden Ursacheneinheiten durch die Steuerung.
<p>
&lt;absatz&gt;
						Liste der Ursacheneinheit&#47;Algorithmuskombinationen die durch die Steuerung berechnet werden sollen .
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class PdNbaStrgSteuerlogikLokal extends AbstractParameterDatensatz<PdNbaStrgSteuerlogikLokal.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus1
				 _algorithmus1
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus1
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus2
				 _algorithmus2
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus2
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus3
				 _algorithmus3
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus3
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus4
				 _algorithmus4
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus4
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus5
				 _algorithmus5
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus5
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus6
				 _algorithmus6
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus6
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus7
				 _algorithmus7
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus7
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
		
			/**
			Menge Ursacheneinheit Algorithmus 1.
			<p>
			
			</p>
			
			@return der Wert von Algorithmus1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus1
				 getAlgorithmus1() {
				return _algorithmus1;
			}
		
			/**
			Menge Ursacheneinheit Algorithmus 1.
			<p>
			
			</p>
			
			@param _algorithmus1 der neue Wert von Algorithmus1.
			*/
			public void setAlgorithmus1(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus1
			 _algorithmus1) {
				this._algorithmus1 = _algorithmus1;
			}
		
			/**
			Menge Ursacheneinheit Algorithmus 2.
			<p>
			
			</p>
			
			@return der Wert von Algorithmus2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus2
				 getAlgorithmus2() {
				return _algorithmus2;
			}
		
			/**
			Menge Ursacheneinheit Algorithmus 2.
			<p>
			
			</p>
			
			@param _algorithmus2 der neue Wert von Algorithmus2.
			*/
			public void setAlgorithmus2(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus2
			 _algorithmus2) {
				this._algorithmus2 = _algorithmus2;
			}
		
			/**
			Menge Ursacheneinheit Algorithmus 3.
			<p>
			
			</p>
			
			@return der Wert von Algorithmus3.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus3
				 getAlgorithmus3() {
				return _algorithmus3;
			}
		
			/**
			Menge Ursacheneinheit Algorithmus 3.
			<p>
			
			</p>
			
			@param _algorithmus3 der neue Wert von Algorithmus3.
			*/
			public void setAlgorithmus3(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus3
			 _algorithmus3) {
				this._algorithmus3 = _algorithmus3;
			}
		
			/**
			Menge Ursacheneinheit Algorithmus 4.
			<p>
			
			</p>
			
			@return der Wert von Algorithmus4.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus4
				 getAlgorithmus4() {
				return _algorithmus4;
			}
		
			/**
			Menge Ursacheneinheit Algorithmus 4.
			<p>
			
			</p>
			
			@param _algorithmus4 der neue Wert von Algorithmus4.
			*/
			public void setAlgorithmus4(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus4
			 _algorithmus4) {
				this._algorithmus4 = _algorithmus4;
			}
		
			/**
			Menge Ursacheneinheit Algorithmus 5.
			<p>
			
			</p>
			
			@return der Wert von Algorithmus5.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus5
				 getAlgorithmus5() {
				return _algorithmus5;
			}
		
			/**
			Menge Ursacheneinheit Algorithmus 5.
			<p>
			
			</p>
			
			@param _algorithmus5 der neue Wert von Algorithmus5.
			*/
			public void setAlgorithmus5(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus5
			 _algorithmus5) {
				this._algorithmus5 = _algorithmus5;
			}
		
			/**
			Menge Ursacheneinheit Algorithmus 6.
			<p>
			
			</p>
			
			@return der Wert von Algorithmus6.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus6
				 getAlgorithmus6() {
				return _algorithmus6;
			}
		
			/**
			Menge Ursacheneinheit Algorithmus 6.
			<p>
			
			</p>
			
			@param _algorithmus6 der neue Wert von Algorithmus6.
			*/
			public void setAlgorithmus6(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus6
			 _algorithmus6) {
				this._algorithmus6 = _algorithmus6;
			}
		
			/**
			Menge Ursacheneinheit Algorithmus 7.
			<p>
			
			</p>
			
			@return der Wert von Algorithmus7.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus7
				 getAlgorithmus7() {
				return _algorithmus7;
			}
		
			/**
			Menge Ursacheneinheit Algorithmus 7.
			<p>
			
			</p>
			
			@param _algorithmus7 der neue Wert von Algorithmus7.
			*/
			public void setAlgorithmus7(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgSteuerlogikAlgorithmus7
			 _algorithmus7) {
				this._algorithmus7 = _algorithmus7;
			}
		
			/**
			Urlasser Informationen.
			<p>
			
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasser Informationen.
			<p>
			
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getAlgorithmus1().bean2Atl(datum.getItem("Algorithmus1"), factory);
					// AttributListenDefinition
						getAlgorithmus2().bean2Atl(datum.getItem("Algorithmus2"), factory);
					// AttributListenDefinition
						getAlgorithmus3().bean2Atl(datum.getItem("Algorithmus3"), factory);
					// AttributListenDefinition
						getAlgorithmus4().bean2Atl(datum.getItem("Algorithmus4"), factory);
					// AttributListenDefinition
						getAlgorithmus5().bean2Atl(datum.getItem("Algorithmus5"), factory);
					// AttributListenDefinition
						getAlgorithmus6().bean2Atl(datum.getItem("Algorithmus6"), factory);
					// AttributListenDefinition
						getAlgorithmus7().bean2Atl(datum.getItem("Algorithmus7"), factory);
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getAlgorithmus1().atl2Bean(daten.getItem("Algorithmus1"), factory);
					// AttributListenDefinition
						getAlgorithmus2().atl2Bean(daten.getItem("Algorithmus2"), factory);
					// AttributListenDefinition
						getAlgorithmus3().atl2Bean(daten.getItem("Algorithmus3"), factory);
					// AttributListenDefinition
						getAlgorithmus4().atl2Bean(daten.getItem("Algorithmus4"), factory);
					// AttributListenDefinition
						getAlgorithmus5().atl2Bean(daten.getItem("Algorithmus5"), factory);
					// AttributListenDefinition
						getAlgorithmus6().atl2Bean(daten.getItem("Algorithmus6"), factory);
					// AttributListenDefinition
						getAlgorithmus7().atl2Bean(daten.getItem("Algorithmus7"), factory);
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._algorithmus1 = getAlgorithmus1().clone();
							klon._algorithmus2 = getAlgorithmus2().clone();
							klon._algorithmus3 = getAlgorithmus3().clone();
							klon._algorithmus4 = getAlgorithmus4().clone();
							klon._algorithmus5 = getAlgorithmus5().clone();
							klon._algorithmus6 = getAlgorithmus6().clone();
							klon._algorithmus7 = getAlgorithmus7().clone();
							klon._urlasser = getUrlasser().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.nbaStrgSteuerlogikLokal";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdNbaStrgSteuerlogikLokal(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
