/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ordnet einer Anzeige eine Anzeigeeigenschaft
					(Anzeigeinhalt) zu.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AtlNbaProgrammAnzeigeEigenschaft implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			 _anzeige
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlAnzeigeEigenschaft
			 _eigenschaft
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlAnzeigeEigenschaft
			()
			;
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.anzeige.
		<p>
		
		</p>
		
		@return der Wert von Anzeige.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			 getAnzeige() {
			return _anzeige;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.anzeige.
		<p>
		
		</p>
		
		@param _anzeige der neue Wert von Anzeige.
		*/
		public void setAnzeige(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
		 _anzeige) {
			this._anzeige = _anzeige;
		}
	
		/**
		Eigenschaften der Objekte des Typs.
		<p>
		
		</p>
		
		@return der Wert von Eigenschaft.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlAnzeigeEigenschaft
			 getEigenschaft() {
			return _eigenschaft;
		}
	
		/**
		Eigenschaften der Objekte des Typs.
		<p>
		
		</p>
		
		@param _eigenschaft der neue Wert von Eigenschaft.
		*/
		public void setEigenschaft(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlAnzeigeEigenschaft
		 _eigenschaft) {
			this._eigenschaft = _eigenschaft;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAnzeige = getAnzeige();
					final SystemObject tmpAnzeige;
						if (soAnzeige instanceof SystemObject) {
							tmpAnzeige = (SystemObject)soAnzeige;
						} else if(soAnzeige instanceof SystemObjekt){
							tmpAnzeige = ((SystemObjekt)soAnzeige).getSystemObject();
						} else{
							tmpAnzeige = null;
						}
					datum.getReferenceValue("Anzeige").setSystemObject(tmpAnzeige);
				// AttributListenDefinition
					getEigenschaft().bean2Atl(datum.getItem("Eigenschaft"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAnzeige = daten.getReferenceValue("Anzeige").getId();
					final SystemObjekt tmpAnzeige;
					if (idAnzeige == 0) {
						tmpAnzeige = null;
					} else {
						final SystemObject soAnzeige = factory.getDav().getDataModel().getObject(idAnzeige);
						if (soAnzeige == null) {
								tmpAnzeige = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeUngueltig(idAnzeige);
						} else {
							tmpAnzeige = factory.getModellobjekt(soAnzeige);
						}
					}
					setAnzeige((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
					) tmpAnzeige);
				// AttributListenDefinition
					getEigenschaft().atl2Bean(daten.getItem("Eigenschaft"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaProgrammAnzeigeEigenschaft clone() {
		AtlNbaProgrammAnzeigeEigenschaft klon = new AtlNbaProgrammAnzeigeEigenschaft();
		
						klon.setAnzeige(getAnzeige());
						klon._eigenschaft = getEigenschaft().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
