/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition einer Zuordnung von Masche und ausgewählter
					Alternativroute, die beim Schalten eines Programms zu aktivieren
					sind.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class AtlProgrammMasche implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Masche
			 _masche
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Route
			 _alternativRoute
			;
	
		/**
		Attribut zur Referenzierung des Objekttyps:
							typ.masche.
		<p>
		
		</p>
		
		@return der Wert von Masche.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Masche
			 getMasche() {
			return _masche;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps:
							typ.masche.
		<p>
		
		</p>
		
		@param _masche der neue Wert von Masche.
		*/
		public void setMasche(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Masche
		 _masche) {
			this._masche = _masche;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps:
							typ.route (Optionale Referenzierung erlaubt).
		<p>
		
		</p>
		
		@return der Wert von AlternativRoute.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Route
			 getAlternativRoute() {
			return _alternativRoute;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps:
							typ.route (Optionale Referenzierung erlaubt).
		<p>
		
		</p>
		
		@param _alternativRoute der neue Wert von AlternativRoute.
		*/
		public void setAlternativRoute(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Route
		 _alternativRoute) {
			this._alternativRoute = _alternativRoute;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soMasche = getMasche();
					final SystemObject tmpMasche;
						if (soMasche instanceof SystemObject) {
							tmpMasche = (SystemObject)soMasche;
						} else if(soMasche instanceof SystemObjekt){
							tmpMasche = ((SystemObjekt)soMasche).getSystemObject();
						} else{
							tmpMasche = null;
						}
					datum.getReferenceValue("Masche").setSystemObject(tmpMasche);
				// ObjektReferenzAttributTyp
					final Object soAlternativRoute = getAlternativRoute();
					final SystemObject tmpAlternativRoute;
						if (soAlternativRoute instanceof SystemObject) {
							tmpAlternativRoute = (SystemObject)soAlternativRoute;
						} else if(soAlternativRoute instanceof SystemObjekt){
							tmpAlternativRoute = ((SystemObjekt)soAlternativRoute).getSystemObject();
						} else{
							tmpAlternativRoute = null;
						}
					datum.getReferenceValue("AlternativRoute").setSystemObject(tmpAlternativRoute);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idMasche = daten.getReferenceValue("Masche").getId();
					final SystemObjekt tmpMasche;
					if (idMasche == 0) {
						tmpMasche = null;
					} else {
						final SystemObject soMasche = factory.getDav().getDataModel().getObject(idMasche);
						if (soMasche == null) {
								tmpMasche = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MascheUngueltig(idMasche);
						} else {
							tmpMasche = factory.getModellobjekt(soMasche);
						}
					}
					setMasche((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Masche
					) tmpMasche);
				// ObjektReferenzAttributTyp
					final long idAlternativRoute = daten.getReferenceValue("AlternativRoute").getId();
					final SystemObjekt tmpAlternativRoute;
					if (idAlternativRoute == 0) {
						tmpAlternativRoute = null;
					} else {
						final SystemObject soAlternativRoute = factory.getDav().getDataModel().getObject(idAlternativRoute);
						if (soAlternativRoute == null) {
								tmpAlternativRoute = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.RouteUngueltig(idAlternativRoute);
						} else {
							tmpAlternativRoute = factory.getModellobjekt(soAlternativRoute);
						}
					}
					setAlternativRoute((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Route
					) tmpAlternativRoute);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlProgrammMasche clone() {
		AtlProgrammMasche klon = new AtlProgrammMasche();
		
						klon.setMasche(getMasche());
						klon.setAlternativRoute(getAlternativRoute());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
