/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert den Typ eines NBA-Schaltprogramms.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class AttNbaProgrammTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Das Programmobjekt ist nicht in Verwendung.
	<p>
	
	</p>
	*/
	public static final AttNbaProgrammTyp ZUSTAND_0_GELOESCHT = new AttNbaProgrammTyp("Gelöscht", 		Byte
	.valueOf("0"));

	/**
	Der Grundsteuerungsfall ist ein Subtyp von
								Standardprogramm.
	<p>
	
	</p>
	*/
	public static final AttNbaProgrammTyp ZUSTAND_1_GRUNDSTEUERUNGSFALL = new AttNbaProgrammTyp("Grundsteuerungsfall", 		Byte
	.valueOf("1"));

	/**
	Die Umleitungsvariante ist ein Subtyp von
								Standardprogramm.
	<p>
	
	</p>
	*/
	public static final AttNbaProgrammTyp ZUSTAND_2_UMLEITUNGSVARIANTE = new AttNbaProgrammTyp("Umleitungsvariante", 		Byte
	.valueOf("2"));

	/**
	Die Variante der Störung ist ein Subtyp von
								Standardprogramm.
	<p>
	
	</p>
	*/
	public static final AttNbaProgrammTyp ZUSTAND_3_VARIANTE_DER_STOERUNG = new AttNbaProgrammTyp("Variante der Störung", 		Byte
	.valueOf("3"));

	/**
	Die Störungsgruppe ist ein Subtyp von Standardprogramm.
	<p>
	
	</p>
	*/
	public static final AttNbaProgrammTyp ZUSTAND_4_STOERUNGSGRUPPE = new AttNbaProgrammTyp("Störungsgruppe", 		Byte
	.valueOf("4"));

	/**
	Die Störung ist ein Subtyp von Standardprogramm.
	<p>
	
	</p>
	*/
	public static final AttNbaProgrammTyp ZUSTAND_5_STOERUNG = new AttNbaProgrammTyp("Störung", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaProgrammTyp ZUSTAND_6_SONDERPROGRAMM = new AttNbaProgrammTyp("Sonderprogramm", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaProgrammTyp ZUSTAND_7_SONDER_GRUPPENPROGRAMM = new AttNbaProgrammTyp("Sonder-Gruppenprogramm", 		Byte
	.valueOf("7"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttNbaProgrammTyp getZustand(final 		Byte
	 value) {
		for (AttNbaProgrammTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttNbaProgrammTyp getZustand(final String value) {
		for (AttNbaProgrammTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttNbaProgrammTyp> getZustaende() {
		List<AttNbaProgrammTyp> list = new ArrayList<AttNbaProgrammTyp>();
		list.add(ZUSTAND_0_GELOESCHT);
		list.add(ZUSTAND_1_GRUNDSTEUERUNGSFALL);
		list.add(ZUSTAND_2_UMLEITUNGSVARIANTE);
		list.add(ZUSTAND_3_VARIANTE_DER_STOERUNG);
		list.add(ZUSTAND_4_STOERUNGSGRUPPE);
		list.add(ZUSTAND_5_STOERUNG);
		list.add(ZUSTAND_6_SONDERPROGRAMM);
		list.add(ZUSTAND_7_SONDER_GRUPPENPROGRAMM);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut NbaProgrammTyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttNbaProgrammTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttNbaProgrammTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
