/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Anweisung zum Löschen eines Programms an den NBA-Programmverwaltungsserver.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public class OdNbaProgrammLoeschenAnfrage extends AbstractOnlineDatensatz<OdNbaProgrammLoeschenAnfrage.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Anfrage,
				};
			}
	
			/**
			 * Wird zur Anfrage von Informationen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Anfrage = new Aspekte("Anfrage", "asp.anfrage");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
				 _applikation
				;
				private String
				 _anfrageId
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _name
				= new String
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
				 _programm
				;
		
			/**
			Attribut zur Referenzierung von Applikationen.
			<p>
			
			</p>
			
			@return der Wert von Applikation.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
				 getApplikation() {
				return _applikation;
			}
		
			/**
			Attribut zur Referenzierung von Applikationen.
			<p>
			
			</p>
			
			@param _applikation der neue Wert von Applikation.
			*/
			public void setApplikation(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
			 _applikation) {
				this._applikation = _applikation;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von AnfrageId.
			*/
				public String
				 getAnfrageId() {
				return _anfrageId;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _anfrageId der neue Wert von AnfrageId.
			*/
			public void setAnfrageId(String
			 _anfrageId) {
				if (_anfrageId.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._anfrageId = _anfrageId;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Name.
			*/
				public String
				 getName() {
				return _name;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _name der neue Wert von Name.
			*/
			public void setName(String
			 _name) {
				if (_name.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._name = _name;
			}
		
			/**
			Eine Referenz auf ein NBA-Schaltprogramm.
			<p>
			
			</p>
			
			@return der Wert von Programm.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
				 getProgramm() {
				return _programm;
			}
		
			/**
			Eine Referenz auf ein NBA-Schaltprogramm.
			<p>
			
			</p>
			
			@param _programm der neue Wert von Programm.
			*/
			public void setProgramm(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
			 _programm) {
				this._programm = _programm;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soApplikation = getApplikation();
						final SystemObject tmpApplikation;
							if (soApplikation instanceof SystemObject) {
								tmpApplikation = (SystemObject)soApplikation;
							} else if(soApplikation instanceof SystemObjekt){
								tmpApplikation = ((SystemObjekt)soApplikation).getSystemObject();
							} else{
								tmpApplikation = null;
							}
						datum.getReferenceValue("Applikation").setSystemObject(tmpApplikation);
					// ZeichenkettenAttributTyp
					if (getAnfrageId() != null) {
						datum.getTextValue("AnfrageId").setText(getAnfrageId());
					}
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getName() != null) {
						datum.getTextValue("Name").setText(getName());
					}
					// ObjektReferenzAttributTyp
						final Object soProgramm = getProgramm();
						final SystemObject tmpProgramm;
							if (soProgramm instanceof SystemObject) {
								tmpProgramm = (SystemObject)soProgramm;
							} else if(soProgramm instanceof SystemObjekt){
								tmpProgramm = ((SystemObjekt)soProgramm).getSystemObject();
							} else{
								tmpProgramm = null;
							}
						datum.getReferenceValue("Programm").setSystemObject(tmpProgramm);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idApplikation = daten.getReferenceValue("Applikation").getId();
						final SystemObjekt tmpApplikation;
						if (idApplikation == 0) {
							tmpApplikation = null;
						} else {
							final SystemObject soApplikation = factory.getDav().getDataModel().getObject(idApplikation);
							if (soApplikation == null) {
									tmpApplikation = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.ApplikationUngueltig(idApplikation);
							} else {
								tmpApplikation = factory.getModellobjekt(soApplikation);
							}
						}
						setApplikation((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
						) tmpApplikation);
					// ZeichenkettenAttributTyp
						setAnfrageId(daten.getTextValue("AnfrageId").getText());
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setName(daten.getTextValue("Name").getText());
					// ObjektReferenzAttributTyp
						final long idProgramm = daten.getReferenceValue("Programm").getId();
						final SystemObjekt tmpProgramm;
						if (idProgramm == 0) {
							tmpProgramm = null;
						} else {
							final SystemObject soProgramm = factory.getDav().getDataModel().getObject(idProgramm);
							if (soProgramm == null) {
									tmpProgramm = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.impl.NbaProgrammUngueltig(idProgramm);
							} else {
								tmpProgramm = factory.getModellobjekt(soProgramm);
							}
						}
						setProgramm((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
						) tmpProgramm);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setApplikation(getApplikation());
							klon.setAnfrageId(getAnfrageId());
							klon._urlasser = getUrlasser().clone();
							klon.setName(getName());
							klon.setProgramm(getProgramm());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.nbaProgrammLoeschenAnfrage";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdNbaProgrammLoeschenAnfrage(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
