/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Der Inhalt des NBA-Schaltprogramms.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class PdNbaProgramm extends AbstractParameterDatensatz<PdNbaProgramm.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _name
				= new String
				()
				;
				private String
				 _alias
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AttNbaProgrammTyp
				 _typ
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
				 _vater
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.Standort
				> _standorte = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.Standort
				>(0, true);
				private String
				 _bedienerhinweise
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlProgrammMasche
				> _aktiveMaschen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlProgrammMasche
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
				> _nachzuschaltendeProgramme = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlNbaProgrammAnzeigeEigenschaft
				> _anzeigeEigenschaften = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlNbaProgrammAnzeigeEigenschaft
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Name.
			*/
				public String
				 getName() {
				return _name;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _name der neue Wert von Name.
			*/
			public void setName(String
			 _name) {
				if (_name.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._name = _name;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Alias.
			*/
				public String
				 getAlias() {
				return _alias;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _alias der neue Wert von Alias.
			*/
			public void setAlias(String
			 _alias) {
				if (_alias.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._alias = _alias;
			}
		
			/**
			Definiert den Typ eines NBA-Schaltprogramms.
			<p>
			
			</p>
			
			@return der Wert von Typ.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AttNbaProgrammTyp
				 getTyp() {
				return _typ;
			}
		
			/**
			Definiert den Typ eines NBA-Schaltprogramms.
			<p>
			
			</p>
			
			@param _typ der neue Wert von Typ.
			*/
			public void setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AttNbaProgrammTyp
			 _typ) {
				this._typ = _typ;
			}
		
			/**
			Eine optionale Referenz auf ein NBA-Schaltprogramm.
			<p>
			
			</p>
			
			@return der Wert von Vater.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
				 getVater() {
				return _vater;
			}
		
			/**
			Eine optionale Referenz auf ein NBA-Schaltprogramm.
			<p>
			
			</p>
			
			@param _vater der neue Wert von Vater.
			*/
			public void setVater(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
			 _vater) {
				this._vater = _vater;
			}
		
			/**
			Eine Referenz auf einen Standort.
			<p>
			
			</p>
			
			@return der Wert von Standorte.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.Standort
				> getStandorte() {
				return _standorte;
			}
		
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Bedienerhinweise.
			*/
				public String
				 getBedienerhinweise() {
				return _bedienerhinweise;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _bedienerhinweise der neue Wert von Bedienerhinweise.
			*/
			public void setBedienerhinweise(String
			 _bedienerhinweise) {
				if (_bedienerhinweise.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bedienerhinweise = _bedienerhinweise;
			}
		
			/**
			Definition einer Zuordnung von Masche und ausgewählter
								Alternativroute, die beim Schalten eines Programms zu aktivieren
								sind.
			<p>
			
			</p>
			
			@return der Wert von AktiveMaschen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlProgrammMasche
				> getAktiveMaschen() {
				return _aktiveMaschen;
			}
		
		
			/**
			Eine Referenz auf ein NBA-Schaltprogramm.
			<p>
			
			</p>
			
			@return der Wert von NachzuschaltendeProgramme.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
				> getNachzuschaltendeProgramme() {
				return _nachzuschaltendeProgramme;
			}
		
		
			/**
			Ordnet einer Anzeige eine Anzeigeeigenschaft
								(Anzeigeinhalt) zu.
			<p>
			
			</p>
			
			@return der Wert von AnzeigeEigenschaften.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlNbaProgrammAnzeigeEigenschaft
				> getAnzeigeEigenschaften() {
				return _anzeigeEigenschaften;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getName() != null) {
						datum.getTextValue("Name").setText(getName());
					}
					// ZeichenkettenAttributTyp
					if (getAlias() != null) {
						datum.getTextValue("Alias").setText(getAlias());
					}
					// GanzzahlAttributTyp
					if (getTyp() != null) {
		                if (getTyp().isZustand()) {
		                    datum.getUnscaledValue("Typ").setText(getTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Typ").set(getTyp().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Object soVater = getVater();
						final SystemObject tmpVater;
							if (soVater instanceof SystemObject) {
								tmpVater = (SystemObject)soVater;
							} else if(soVater instanceof SystemObjekt){
								tmpVater = ((SystemObjekt)soVater).getSystemObject();
							} else{
								tmpVater = null;
							}
						datum.getReferenceValue("Vater").setSystemObject(tmpVater);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayStandorte = datum.getReferenceArray("Standorte");
						arrayStandorte.setLength(getStandorte().size());
						for (int i = 0; i < arrayStandorte.getLength(); ++i) {
							final Object soStandorte = getStandorte().get(i);
							final SystemObject tmpStandorte;
							if (soStandorte instanceof SystemObject) {
								tmpStandorte = (SystemObject)soStandorte;
							} else if(soStandorte instanceof SystemObjekt){
								tmpStandorte = ((SystemObjekt)soStandorte).getSystemObject();
							} else{
								tmpStandorte = null;
							}
							arrayStandorte.getReferenceValue(i).setSystemObject(tmpStandorte);
						}
					// ZeichenkettenAttributTyp
					if (getBedienerhinweise() != null) {
						datum.getTextValue("Bedienerhinweise").setText(getBedienerhinweise());
					}
					// AttributListenDefinition
						final Data.Array arrayAktiveMaschen = datum.getArray("AktiveMaschen");
						arrayAktiveMaschen.setLength(getAktiveMaschen().size());
						for (int i = 0; i < arrayAktiveMaschen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlProgrammMasche
							 atl = getAktiveMaschen().get(i);
							atl.bean2Atl(arrayAktiveMaschen.getItem(i), factory);
		
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayNachzuschaltendeProgramme = datum.getReferenceArray("NachzuschaltendeProgramme");
						arrayNachzuschaltendeProgramme.setLength(getNachzuschaltendeProgramme().size());
						for (int i = 0; i < arrayNachzuschaltendeProgramme.getLength(); ++i) {
							final Object soNachzuschaltendeProgramme = getNachzuschaltendeProgramme().get(i);
							final SystemObject tmpNachzuschaltendeProgramme;
							if (soNachzuschaltendeProgramme instanceof SystemObject) {
								tmpNachzuschaltendeProgramme = (SystemObject)soNachzuschaltendeProgramme;
							} else if(soNachzuschaltendeProgramme instanceof SystemObjekt){
								tmpNachzuschaltendeProgramme = ((SystemObjekt)soNachzuschaltendeProgramme).getSystemObject();
							} else{
								tmpNachzuschaltendeProgramme = null;
							}
							arrayNachzuschaltendeProgramme.getReferenceValue(i).setSystemObject(tmpNachzuschaltendeProgramme);
						}
					// AttributListenDefinition
						final Data.Array arrayAnzeigeEigenschaften = datum.getArray("AnzeigeEigenschaften");
						arrayAnzeigeEigenschaften.setLength(getAnzeigeEigenschaften().size());
						for (int i = 0; i < arrayAnzeigeEigenschaften.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlNbaProgrammAnzeigeEigenschaft
							 atl = getAnzeigeEigenschaften().get(i);
							atl.bean2Atl(arrayAnzeigeEigenschaften.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setName(daten.getTextValue("Name").getText());
					// ZeichenkettenAttributTyp
						setAlias(daten.getTextValue("Alias").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Typ").isState()) {
								setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AttNbaProgrammTyp
								.getZustand(daten.getScaledValue("Typ").getText()));
							} else {
							setTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AttNbaProgrammTyp
							(daten.
								getUnscaledValue
							("Typ").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final long idVater = daten.getReferenceValue("Vater").getId();
						final SystemObjekt tmpVater;
						if (idVater == 0) {
							tmpVater = null;
						} else {
							final SystemObject soVater = factory.getDav().getDataModel().getObject(idVater);
							if (soVater == null) {
									tmpVater = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.impl.NbaProgrammUngueltig(idVater);
							} else {
								tmpVater = factory.getModellobjekt(soVater);
							}
						}
						setVater((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
						) tmpVater);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayStandorte = daten.getReferenceArray("Standorte");
						for (int i = 0; i < arrayStandorte.getLength(); ++i) {
							final long idStandorte = daten.getReferenceArray("Standorte").getReferenceValue(i).getId();
							final SystemObjekt tmpStandorte;
							if (idStandorte == 0) {
								tmpStandorte = null;
							} else {
								final SystemObject soStandorte = factory.getDav().getDataModel().getObject(idStandorte);
								if (soStandorte == null) {
										tmpStandorte = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.impl.StandortUngueltig(idStandorte);
								} else {
									tmpStandorte = factory.getModellobjekt(soStandorte);
								}
							}
								getStandorte().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.Standort
								) tmpStandorte);
						}
					// ZeichenkettenAttributTyp
						setBedienerhinweise(daten.getTextValue("Bedienerhinweise").getText());
					// AttributListenDefinition
						final Data.Array arrayAktiveMaschen = daten.getArray("AktiveMaschen");
						for (int i = 0; i < arrayAktiveMaschen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlProgrammMasche
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlProgrammMasche
							 ();
							atl.atl2Bean(arrayAktiveMaschen.getItem(i), factory);
							getAktiveMaschen().add(atl);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayNachzuschaltendeProgramme = daten.getReferenceArray("NachzuschaltendeProgramme");
						for (int i = 0; i < arrayNachzuschaltendeProgramme.getLength(); ++i) {
							final long idNachzuschaltendeProgramme = daten.getReferenceArray("NachzuschaltendeProgramme").getReferenceValue(i).getId();
							final SystemObjekt tmpNachzuschaltendeProgramme;
							if (idNachzuschaltendeProgramme == 0) {
								tmpNachzuschaltendeProgramme = null;
							} else {
								final SystemObject soNachzuschaltendeProgramme = factory.getDav().getDataModel().getObject(idNachzuschaltendeProgramme);
								if (soNachzuschaltendeProgramme == null) {
										tmpNachzuschaltendeProgramme = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.impl.NbaProgrammUngueltig(idNachzuschaltendeProgramme);
								} else {
									tmpNachzuschaltendeProgramme = factory.getModellobjekt(soNachzuschaltendeProgramme);
								}
							}
								getNachzuschaltendeProgramme().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
								) tmpNachzuschaltendeProgramme);
						}
					// AttributListenDefinition
						final Data.Array arrayAnzeigeEigenschaften = daten.getArray("AnzeigeEigenschaften");
						for (int i = 0; i < arrayAnzeigeEigenschaften.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlNbaProgrammAnzeigeEigenschaft
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlNbaProgrammAnzeigeEigenschaft
							 ();
							atl.atl2Bean(arrayAnzeigeEigenschaften.getItem(i), factory);
							getAnzeigeEigenschaften().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setName(getName());
							klon.setAlias(getAlias());
							klon.setTyp(getTyp());
							klon.setVater(getVater());
						klon._standorte = getStandorte().clone();
							klon.setBedienerhinweise(getBedienerhinweise());
						klon._aktiveMaschen = getAktiveMaschen().clone();
						klon._nachzuschaltendeProgramme = getNachzuschaltendeProgramme().clone();
						klon._anzeigeEigenschaften = getAnzeigeEigenschaften().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.nbaProgramm";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdNbaProgramm(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
