/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class AtlNbaSchaltungEigenschaften implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
			 _programm
			;
			private 	Zeitstempel
			 _schaltzeit
			;
			private String
			 _bedienerhinweis
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _aktiv
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute.AttSchaltArt
			 _schaltArt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute.AtlNbaZeitplan
			 _zeitplan
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute.AtlNbaZeitplan
			()
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
			> _nachschaltungen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
			>(0, true);
	
		/**
		Eine optionale Referenz auf ein NBA-Schaltprogramm.
		<p>
		
		</p>
		
		@return der Wert von Programm.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
			 getProgramm() {
			return _programm;
		}
	
		/**
		Eine optionale Referenz auf ein NBA-Schaltprogramm.
		<p>
		
		</p>
		
		@param _programm der neue Wert von Programm.
		*/
		public void setProgramm(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
		 _programm) {
			this._programm = _programm;
		}
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@return der Wert von Schaltzeit.
		*/
			public 	Zeitstempel
			 getSchaltzeit() {
			return _schaltzeit;
		}
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@param _schaltzeit der neue Wert von Schaltzeit.
		*/
		public void setSchaltzeit(	Zeitstempel
		 _schaltzeit) {
			this._schaltzeit = _schaltzeit;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Bedienerhinweis.
		*/
			public String
			 getBedienerhinweis() {
			return _bedienerhinweis;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _bedienerhinweis der neue Wert von Bedienerhinweis.
		*/
		public void setBedienerhinweis(String
		 _bedienerhinweis) {
			if (_bedienerhinweis.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._bedienerhinweis = _bedienerhinweis;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von Aktiv.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getAktiv() {
			return _aktiv;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _aktiv der neue Wert von Aktiv.
		*/
		public void setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _aktiv) {
			this._aktiv = _aktiv;
		}
	
		/**
		Die Art (hier hauptsaechlich Priorisierung), wie ein
							Programm geschaltet wird.
		<p>
		
		</p>
		
		@return der Wert von SchaltArt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute.AttSchaltArt
			 getSchaltArt() {
			return _schaltArt;
		}
	
		/**
		Die Art (hier hauptsaechlich Priorisierung), wie ein
							Programm geschaltet wird.
		<p>
		
		</p>
		
		@param _schaltArt der neue Wert von SchaltArt.
		*/
		public void setSchaltArt(de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute.AttSchaltArt
		 _schaltArt) {
			this._schaltArt = _schaltArt;
		}
	
		/**
		Muss nur bei Zeitschaltungen angegeben werden.
		<p>
		
		</p>
		
		@return der Wert von Zeitplan.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute.AtlNbaZeitplan
			 getZeitplan() {
			return _zeitplan;
		}
	
		/**
		Muss nur bei Zeitschaltungen angegeben werden.
		<p>
		
		</p>
		
		@param _zeitplan der neue Wert von Zeitplan.
		*/
		public void setZeitplan(de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute.AtlNbaZeitplan
		 _zeitplan) {
			this._zeitplan = _zeitplan;
		}
	
		/**
		Eine Referenz auf ein NBA-Schaltprogramm.
		<p>
		
		</p>
		
		@return der Wert von Nachschaltungen.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
			> getNachschaltungen() {
			return _nachschaltungen;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soProgramm = getProgramm();
					final SystemObject tmpProgramm;
						if (soProgramm instanceof SystemObject) {
							tmpProgramm = (SystemObject)soProgramm;
						} else if(soProgramm instanceof SystemObjekt){
							tmpProgramm = ((SystemObjekt)soProgramm).getSystemObject();
						} else{
							tmpProgramm = null;
						}
					datum.getReferenceValue("Programm").setSystemObject(tmpProgramm);
				// ZeitstempelAttributTyp
					datum.getTimeValue("Schaltzeit").setMillis(getSchaltzeit().getTime());
				// ZeichenkettenAttributTyp
				if (getBedienerhinweis() != null) {
					datum.getTextValue("Bedienerhinweis").setText(getBedienerhinweis());
				}
				// GanzzahlAttributTyp
				if (getAktiv() != null) {
	                if (getAktiv().isZustand()) {
	                    datum.getUnscaledValue("Aktiv").setText(getAktiv().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Aktiv").set(getAktiv().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getSchaltArt() != null) {
	                if (getSchaltArt().isZustand()) {
	                    datum.getUnscaledValue("SchaltArt").setText(getSchaltArt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SchaltArt").set(getSchaltArt().getValue());
	                }
				}
				// AttributListenDefinition
					getZeitplan().bean2Atl(datum.getItem("Zeitplan"), factory);
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayNachschaltungen = datum.getReferenceArray("Nachschaltungen");
					arrayNachschaltungen.setLength(getNachschaltungen().size());
					for (int i = 0; i < arrayNachschaltungen.getLength(); ++i) {
						final Object soNachschaltungen = getNachschaltungen().get(i);
						final SystemObject tmpNachschaltungen;
						if (soNachschaltungen instanceof SystemObject) {
							tmpNachschaltungen = (SystemObject)soNachschaltungen;
						} else if(soNachschaltungen instanceof SystemObjekt){
							tmpNachschaltungen = ((SystemObjekt)soNachschaltungen).getSystemObject();
						} else{
							tmpNachschaltungen = null;
						}
						arrayNachschaltungen.getReferenceValue(i).setSystemObject(tmpNachschaltungen);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idProgramm = daten.getReferenceValue("Programm").getId();
					final SystemObjekt tmpProgramm;
					if (idProgramm == 0) {
						tmpProgramm = null;
					} else {
						final SystemObject soProgramm = factory.getDav().getDataModel().getObject(idProgramm);
						if (soProgramm == null) {
								tmpProgramm = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.impl.NbaProgrammUngueltig(idProgramm);
						} else {
							tmpProgramm = factory.getModellobjekt(soProgramm);
						}
					}
					setProgramm((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
					) tmpProgramm);
				// ZeitstempelAttributTyp
					setSchaltzeit(new
						Zeitstempel
						(daten.getTimeValue("Schaltzeit").getMillis()));
				// ZeichenkettenAttributTyp
					setBedienerhinweis(daten.getTextValue("Bedienerhinweis").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Aktiv").isState()) {
							setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Aktiv").getText()));
						} else {
						setAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Aktiv").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("SchaltArt").isState()) {
							setSchaltArt(de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute.AttSchaltArt
							.getZustand(daten.getScaledValue("SchaltArt").getText()));
						} else {
						setSchaltArt(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute.AttSchaltArt
						(daten.
							getUnscaledValue
						("SchaltArt").
								byteValue
						()));
						}
				// AttributListenDefinition
					getZeitplan().atl2Bean(daten.getItem("Zeitplan"), factory);
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayNachschaltungen = daten.getReferenceArray("Nachschaltungen");
					for (int i = 0; i < arrayNachschaltungen.getLength(); ++i) {
						final long idNachschaltungen = daten.getReferenceArray("Nachschaltungen").getReferenceValue(i).getId();
						final SystemObjekt tmpNachschaltungen;
						if (idNachschaltungen == 0) {
							tmpNachschaltungen = null;
						} else {
							final SystemObject soNachschaltungen = factory.getDav().getDataModel().getObject(idNachschaltungen);
							if (soNachschaltungen == null) {
									tmpNachschaltungen = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.impl.NbaProgrammUngueltig(idNachschaltungen);
							} else {
								tmpNachschaltungen = factory.getModellobjekt(soNachschaltungen);
							}
						}
							getNachschaltungen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.objekte.NbaProgramm
							) tmpNachschaltungen);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaSchaltungEigenschaften clone() {
		AtlNbaSchaltungEigenschaften klon = new AtlNbaSchaltungEigenschaften();
		
						klon.setProgramm(getProgramm());
						klon.setSchaltzeit(getSchaltzeit());
						klon.setBedienerhinweis(getBedienerhinweis());
						klon.setAktiv(getAktiv());
						klon.setSchaltArt(getSchaltArt());
						klon._zeitplan = getZeitplan().clone();
					klon._nachschaltungen = getNachschaltungen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
