/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
NBA-Zeitplan fuer einmalige und zyklische
					Zeitschaltungen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlNbaZeitplan implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _anfangsDatum
			;
			private 	Zeitstempel
			 _endeDatum
			;
			private 	RelativerZeitstempel
			 _startZeit
			;
			private 	RelativerZeitstempel
			 _endeZeit
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute.AttWochentag
			> _wochentage = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute.AttWochentag
			>(0, true);
	
		/**
		Zwischen Anfangsdatum und Endedatum wird das
								Programm
								geschaltet, wie in den naechsten drei Attributen
								vorgeschrieben.
		<p>
		
		</p>
		
		@return der Wert von AnfangsDatum.
		*/
			public 	Zeitstempel
			 getAnfangsDatum() {
			return _anfangsDatum;
		}
	
		/**
		Zwischen Anfangsdatum und Endedatum wird das
								Programm
								geschaltet, wie in den naechsten drei Attributen
								vorgeschrieben.
		<p>
		
		</p>
		
		@param _anfangsDatum der neue Wert von AnfangsDatum.
		*/
		public void setAnfangsDatum(	Zeitstempel
		 _anfangsDatum) {
			this._anfangsDatum = _anfangsDatum;
		}
	
		/**
		Zwischen Anfangsdatum und Endedatum wird das
								Programm
								geschaltet, wie in den naechsten drei Attributen
								vorgeschrieben.
		<p>
		
		</p>
		
		@return der Wert von EndeDatum.
		*/
			public 	Zeitstempel
			 getEndeDatum() {
			return _endeDatum;
		}
	
		/**
		Zwischen Anfangsdatum und Endedatum wird das
								Programm
								geschaltet, wie in den naechsten drei Attributen
								vorgeschrieben.
		<p>
		
		</p>
		
		@param _endeDatum der neue Wert von EndeDatum.
		*/
		public void setEndeDatum(	Zeitstempel
		 _endeDatum) {
			this._endeDatum = _endeDatum;
		}
	
		/**
		Startzeit fuer zyklische Schaltungen (Tageszeit am
								1.1.1970).
		<p>
		
		</p>
		
		@return der Wert von StartZeit.
		*/
			public 	RelativerZeitstempel
			 getStartZeit() {
			return _startZeit;
		}
	
		/**
		Startzeit fuer zyklische Schaltungen (Tageszeit am
								1.1.1970).
		<p>
		
		</p>
		
		@param _startZeit der neue Wert von StartZeit.
		*/
		public void setStartZeit(	RelativerZeitstempel
		 _startZeit) {
			this._startZeit = _startZeit;
		}
	
		/**
		Endzeit fuer zyklische Schaltungen (Tageszeit am
								1.1.1970).
		<p>
		
		</p>
		
		@return der Wert von EndeZeit.
		*/
			public 	RelativerZeitstempel
			 getEndeZeit() {
			return _endeZeit;
		}
	
		/**
		Endzeit fuer zyklische Schaltungen (Tageszeit am
								1.1.1970).
		<p>
		
		</p>
		
		@param _endeZeit der neue Wert von EndeZeit.
		*/
		public void setEndeZeit(	RelativerZeitstempel
		 _endeZeit) {
			this._endeZeit = _endeZeit;
		}
	
		/**
		die Wochentage, an denen eine Schaltung ausgeführt werden
								soll.
		<p>
		
		</p>
		
		@return der Wert von Wochentage.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute.AttWochentag
			> getWochentage() {
			return _wochentage;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("AnfangsDatum").setMillis(getAnfangsDatum().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("EndeDatum").setMillis(getEndeDatum().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("StartZeit").setMillis(getStartZeit().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("EndeZeit").setMillis(getEndeZeit().getTime());
				// GanzzahlAttributTyp
				if (getWochentage() != null) {
					final Data.NumberArray arrayWochentage = datum.
						getUnscaledArray
						("Wochentage");
					arrayWochentage.setLength(getWochentage().size());
					for (int i = 0; i < arrayWochentage.getLength(); ++i) {
						arrayWochentage.getValue(i).set(getWochentage().get(i).getValue());
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setAnfangsDatum(new
						Zeitstempel
						(daten.getTimeValue("AnfangsDatum").getMillis()));
				// ZeitstempelAttributTyp
					setEndeDatum(new
						Zeitstempel
						(daten.getTimeValue("EndeDatum").getMillis()));
				// ZeitstempelAttributTyp
					setStartZeit(new
						RelativerZeitstempel
						(daten.getTimeValue("StartZeit").getMillis()));
				// ZeitstempelAttributTyp
					setEndeZeit(new
						RelativerZeitstempel
						(daten.getTimeValue("EndeZeit").getMillis()));
				// GanzzahlAttributTyp
					final Data.NumberArray arrayWochentage = daten.
						getUnscaledArray
					("Wochentage");
	
					for (int i = 0; i < arrayWochentage.getLength(); ++i) {
	                    if (arrayWochentage.getValue(i).isState()) {
	                        getWochentage().add(de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute.AttWochentag
	                        .getZustand(arrayWochentage.getValue(i).getState().getName()));
	                    } else {
	                    getWochentage().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute.AttWochentag
	                    (arrayWochentage.
	                    		byteValue
	                    (i)));
	                    }
	                }
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaZeitplan clone() {
		AtlNbaZeitplan klon = new AtlNbaZeitplan();
		
						klon.setAnfangsDatum(getAnfangsDatum());
						klon.setEndeDatum(getEndeDatum());
						klon.setStartZeit(getStartZeit());
						klon.setEndeZeit(getEndeZeit());
					klon._wochentage = getWochentage().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
