/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Der Zustand einer Schaltung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class AttNbaSchaltZustand extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Die Schaltung könnte ausgeführt werden, wird aber durch
								eine höher priorisierte Schaltung verdrängt.
	<p>
	
	</p>
	*/
	public static final AttNbaSchaltZustand ZUSTAND_1_BEREIT = new AttNbaSchaltZustand("bereit", 		Byte
	.valueOf("1"));

	/**
	Die Daten zur Ausführung der Schaltung werden an die
								externe Schnittstelle übertragen.
	<p>
	
	</p>
	*/
	public static final AttNbaSchaltZustand ZUSTAND_2_SCHALTET = new AttNbaSchaltZustand("schaltet", 		Byte
	.valueOf("2"));

	/**
	Die Schaltung ist einen Gruppenschaltung, von der
								mindestens
								eine der Teilschaltungen gerade ausgefuehrt und mindestes eine
								gerade durch eine höher priorisierte verdrängt wird.
	<p>
	
	</p>
	*/
	public static final AttNbaSchaltZustand ZUSTAND_3_PARTIELL_ONLINE = new AttNbaSchaltZustand("partiell online", 		Byte
	.valueOf("3"));

	/**
	Die Schaltung wird gerade ausgefuehrt (ist geschaltet).
	<p>
	
	</p>
	*/
	public static final AttNbaSchaltZustand ZUSTAND_4_ONLINE = new AttNbaSchaltZustand("online", 		Byte
	.valueOf("4"));

	/**
	Die Schaltung wurde vom Anwender deaktiviert und wird in
								der Planung
								nicht berücksichtigt.
	<p>
	
	</p>
	*/
	public static final AttNbaSchaltZustand ZUSTAND_5_INAKTIV = new AttNbaSchaltZustand("inaktiv", 		Byte
	.valueOf("5"));

	/**
	Die Schaltung wird in die Planung einbezogen, der
								zugeordnete Zeitplan verhindert jedoch eine Ausführung zum
								aktuellen Zeitpunkt.
	<p>
	
	</p>
	*/
	public static final AttNbaSchaltZustand ZUSTAND_6_AKTIV = new AttNbaSchaltZustand("aktiv", 		Byte
	.valueOf("6"));

	/**
	Die Schaltung wird gemäß ihres Zeitplans nie wieder
								ausgeführt werden.
	<p>
	
	</p>
	*/
	public static final AttNbaSchaltZustand ZUSTAND_7_ABGELAUFEN = new AttNbaSchaltZustand("abgelaufen", 		Byte
	.valueOf("7"));

	/**
	Die Schaltung sollte Online sein, die externe
								Schnittstelle hat jedoch Fehler geliefert.
	<p>
	
	</p>
	*/
	public static final AttNbaSchaltZustand ZUSTAND_8_FEHLER = new AttNbaSchaltZustand("Fehler", 		Byte
	.valueOf("8"));

	/**
	Das zugeordnete Schaltungsobjekt wurde gelöscht und ist
								für weitere Schaltungsplanungen verfügbar.
	<p>
	
	</p>
	*/
	public static final AttNbaSchaltZustand ZUSTAND_9_GELOESCHT = new AttNbaSchaltZustand("gelöscht", 		Byte
	.valueOf("9"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttNbaSchaltZustand getZustand(final 		Byte
	 value) {
		for (AttNbaSchaltZustand e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttNbaSchaltZustand getZustand(final String value) {
		for (AttNbaSchaltZustand e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttNbaSchaltZustand> getZustaende() {
		List<AttNbaSchaltZustand> list = new ArrayList<AttNbaSchaltZustand>();
		list.add(ZUSTAND_1_BEREIT);
		list.add(ZUSTAND_2_SCHALTET);
		list.add(ZUSTAND_3_PARTIELL_ONLINE);
		list.add(ZUSTAND_4_ONLINE);
		list.add(ZUSTAND_5_INAKTIV);
		list.add(ZUSTAND_6_AKTIV);
		list.add(ZUSTAND_7_ABGELAUFEN);
		list.add(ZUSTAND_8_FEHLER);
		list.add(ZUSTAND_9_GELOESCHT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut NbaSchaltZustand.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttNbaSchaltZustand(final 		Byte
	 value) {
		super(value);
	}
	
	private AttNbaSchaltZustand(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
