/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition für die Wochentage.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttWochentag extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	ein Sonntag.
	<p>
	
	</p>
	*/
	public static final AttWochentag ZUSTAND_1_SONNTAG = new AttWochentag("Sonntag", 		Byte
	.valueOf("1"));

	/**
	ein Montag.
	<p>
	
	</p>
	*/
	public static final AttWochentag ZUSTAND_2_MONTAG = new AttWochentag("Montag", 		Byte
	.valueOf("2"));

	/**
	ein Dienstag.
	<p>
	
	</p>
	*/
	public static final AttWochentag ZUSTAND_3_DIENSTAG = new AttWochentag("Dienstag", 		Byte
	.valueOf("3"));

	/**
	ein Mittwoch.
	<p>
	
	</p>
	*/
	public static final AttWochentag ZUSTAND_4_MITTWOCH = new AttWochentag("Mittwoch", 		Byte
	.valueOf("4"));

	/**
	ein Donnerstag.
	<p>
	
	</p>
	*/
	public static final AttWochentag ZUSTAND_5_DONNERSTAG = new AttWochentag("Donnerstag", 		Byte
	.valueOf("5"));

	/**
	ein Freitag.
	<p>
	
	</p>
	*/
	public static final AttWochentag ZUSTAND_6_FREITAG = new AttWochentag("Freitag", 		Byte
	.valueOf("6"));

	/**
	ein Sonnabend.
	<p>
	
	</p>
	*/
	public static final AttWochentag ZUSTAND_7_SONNABEND = new AttWochentag("Sonnabend", 		Byte
	.valueOf("7"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttWochentag getZustand(final 		Byte
	 value) {
		for (AttWochentag e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttWochentag getZustand(final String value) {
		for (AttWochentag e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttWochentag> getZustaende() {
		List<AttWochentag> list = new ArrayList<AttWochentag>();
		list.add(ZUSTAND_1_SONNTAG);
		list.add(ZUSTAND_2_MONTAG);
		list.add(ZUSTAND_3_DIENSTAG);
		list.add(ZUSTAND_4_MITTWOCH);
		list.add(ZUSTAND_5_DONNERSTAG);
		list.add(ZUSTAND_6_FREITAG);
		list.add(ZUSTAND_7_SONNABEND);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut Wochentag.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttWochentag(final 		Byte
	 value) {
		super(value);
	}
	
	private AttWochentag(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
