/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Antwort des NBA-Schaltservers.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdNbaSchaltServerAntwort extends AbstractOnlineDatensatz<OdNbaSchaltServerAntwort.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Antwort,
				};
			}
	
			/**
			 * Wird zur Beantwortung von Anfragen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Antwort = new Aspekte("Antwort", "asp.antwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
				 _applikation
				;
				private String
				 _anfrageId
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _fehler
				;
				private String
				 _fehlertext
				= new String
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.objekte.NbaSchaltung
				 _schaltung
				;
		
			/**
			Attribut zur Referenzierung von Applikationen.
			<p>
			
			</p>
			
			@return der Wert von Applikation.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
				 getApplikation() {
				return _applikation;
			}
		
			/**
			Attribut zur Referenzierung von Applikationen.
			<p>
			
			</p>
			
			@param _applikation der neue Wert von Applikation.
			*/
			public void setApplikation(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
			 _applikation) {
				this._applikation = _applikation;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von AnfrageId.
			*/
				public String
				 getAnfrageId() {
				return _anfrageId;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _anfrageId der neue Wert von AnfrageId.
			*/
			public void setAnfrageId(String
			 _anfrageId) {
				if (_anfrageId.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._anfrageId = _anfrageId;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Fehler.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getFehler() {
				return _fehler;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _fehler der neue Wert von Fehler.
			*/
			public void setFehler(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _fehler) {
				this._fehler = _fehler;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Fehlertext.
			*/
				public String
				 getFehlertext() {
				return _fehlertext;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _fehlertext der neue Wert von Fehlertext.
			*/
			public void setFehlertext(String
			 _fehlertext) {
				if (_fehlertext.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._fehlertext = _fehlertext;
			}
		
			/**
			Referenz auf eine NBA-Schaltung.
			<p>
			
			</p>
			
			@return der Wert von Schaltung.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.objekte.NbaSchaltung
				 getSchaltung() {
				return _schaltung;
			}
		
			/**
			Referenz auf eine NBA-Schaltung.
			<p>
			
			</p>
			
			@param _schaltung der neue Wert von Schaltung.
			*/
			public void setSchaltung(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.objekte.NbaSchaltung
			 _schaltung) {
				this._schaltung = _schaltung;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soApplikation = getApplikation();
						final SystemObject tmpApplikation;
							if (soApplikation instanceof SystemObject) {
								tmpApplikation = (SystemObject)soApplikation;
							} else if(soApplikation instanceof SystemObjekt){
								tmpApplikation = ((SystemObjekt)soApplikation).getSystemObject();
							} else{
								tmpApplikation = null;
							}
						datum.getReferenceValue("Applikation").setSystemObject(tmpApplikation);
					// ZeichenkettenAttributTyp
					if (getAnfrageId() != null) {
						datum.getTextValue("AnfrageId").setText(getAnfrageId());
					}
					// GanzzahlAttributTyp
					if (getFehler() != null) {
		                if (getFehler().isZustand()) {
		                    datum.getUnscaledValue("Fehler").setText(getFehler().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Fehler").set(getFehler().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getFehlertext() != null) {
						datum.getTextValue("Fehlertext").setText(getFehlertext());
					}
					// ObjektReferenzAttributTyp
						final Object soSchaltung = getSchaltung();
						final SystemObject tmpSchaltung;
							if (soSchaltung instanceof SystemObject) {
								tmpSchaltung = (SystemObject)soSchaltung;
							} else if(soSchaltung instanceof SystemObjekt){
								tmpSchaltung = ((SystemObjekt)soSchaltung).getSystemObject();
							} else{
								tmpSchaltung = null;
							}
						datum.getReferenceValue("Schaltung").setSystemObject(tmpSchaltung);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idApplikation = daten.getReferenceValue("Applikation").getId();
						final SystemObjekt tmpApplikation;
						if (idApplikation == 0) {
							tmpApplikation = null;
						} else {
							final SystemObject soApplikation = factory.getDav().getDataModel().getObject(idApplikation);
							if (soApplikation == null) {
									tmpApplikation = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.ApplikationUngueltig(idApplikation);
							} else {
								tmpApplikation = factory.getModellobjekt(soApplikation);
							}
						}
						setApplikation((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
						) tmpApplikation);
					// ZeichenkettenAttributTyp
						setAnfrageId(daten.getTextValue("AnfrageId").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Fehler").isState()) {
								setFehler(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Fehler").getText()));
							} else {
							setFehler(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Fehler").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setFehlertext(daten.getTextValue("Fehlertext").getText());
					// ObjektReferenzAttributTyp
						final long idSchaltung = daten.getReferenceValue("Schaltung").getId();
						final SystemObjekt tmpSchaltung;
						if (idSchaltung == 0) {
							tmpSchaltung = null;
						} else {
							final SystemObject soSchaltung = factory.getDav().getDataModel().getObject(idSchaltung);
							if (soSchaltung == null) {
									tmpSchaltung = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.objekte.impl.NbaSchaltungUngueltig(idSchaltung);
							} else {
								tmpSchaltung = factory.getModellobjekt(soSchaltung);
							}
						}
						setSchaltung((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.objekte.NbaSchaltung
						) tmpSchaltung);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setApplikation(getApplikation());
							klon.setAnfrageId(getAnfrageId());
							klon.setFehler(getFehler());
							klon.setFehlertext(getFehlertext());
							klon.setSchaltung(getSchaltung());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.nbaSchaltServerAntwort";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdNbaSchaltServerAntwort(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
