/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbahansymbole.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Dient der Synchronisierung der unter
					typ.wzgInhaltGrafikSymbol als Parameter
					abgespeicherten Symbole mit
					der Streckenstation (also dem sofortigen Upload des
					aktuell
					parametrierten Bildes auf die Streckenstation und der
					Schaltcode-Bildname-Assoziation).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class SymbolSynchronisierungsServerImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmnbahansymbole.objekte.SymbolSynchronisierungsServer { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public SymbolSynchronisierungsServerImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public SymbolSynchronisierungsServerImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein SymbolSynchronisierungsServer.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige> verwalteteAnzeigenMitDynamischenSymbolen;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige> getVerwalteteAnzeigenMitDynamischenSymbolen() {
		if (verwalteteAnzeigenMitDynamischenSymbolen == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("VerwalteteAnzeigenMitDynamischenSymbolen") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("VerwalteteAnzeigenMitDynamischenSymbolen").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige) getObjektFactory().getModellobjekt(so));
			}
			verwalteteAnzeigenMitDynamischenSymbolen = Collections.unmodifiableCollection(menge);
		}
		return verwalteteAnzeigenMitDynamischenSymbolen;
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbahansymbole.onlinedaten.OdSymbolSynchronisierungsServerOnlineIndikator getOdSymbolSynchronisierungsServerOnlineIndikator() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbahansymbole.onlinedaten.OdSymbolSynchronisierungsServerOnlineIndikator.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
