/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert die Standardfehlerausgabe.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlFehlerAusgabe implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttOptionFehlerAusgabe
			 _optionFehlerAusgabe
			;
			private String
			 _datei
			= new String
			()
			;
	
		/**
		Verwendungsoption.
		<p>
		
		</p>
		
		@return der Wert von OptionFehlerAusgabe.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttOptionFehlerAusgabe
			 getOptionFehlerAusgabe() {
			return _optionFehlerAusgabe;
		}
	
		/**
		Verwendungsoption.
		<p>
		
		</p>
		
		@param _optionFehlerAusgabe der neue Wert von OptionFehlerAusgabe.
		*/
		public void setOptionFehlerAusgabe(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttOptionFehlerAusgabe
		 _optionFehlerAusgabe) {
			this._optionFehlerAusgabe = _optionFehlerAusgabe;
		}
	
		/**
		Datei.
		<p>
		
		</p>
		
		@return der Wert von Datei.
		*/
			public String
			 getDatei() {
			return _datei;
		}
	
		/**
		Datei.
		<p>
		
		</p>
		
		@param _datei der neue Wert von Datei.
		*/
		public void setDatei(String
		 _datei) {
			if (_datei.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._datei = _datei;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getOptionFehlerAusgabe() != null) {
	                if (getOptionFehlerAusgabe().isZustand()) {
	                    datum.getUnscaledValue("OptionFehlerAusgabe").setText(getOptionFehlerAusgabe().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("OptionFehlerAusgabe").set(getOptionFehlerAusgabe().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getDatei() != null) {
					datum.getTextValue("Datei").setText(getDatei());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("OptionFehlerAusgabe").isState()) {
							setOptionFehlerAusgabe(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttOptionFehlerAusgabe
							.getZustand(daten.getScaledValue("OptionFehlerAusgabe").getText()));
						} else {
						setOptionFehlerAusgabe(new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttOptionFehlerAusgabe
						(daten.
							getUnscaledValue
						("OptionFehlerAusgabe").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setDatei(daten.getTextValue("Datei").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlFehlerAusgabe clone() {
		AtlFehlerAusgabe klon = new AtlFehlerAusgabe();
		
						klon.setOptionFehlerAusgabe(getOptionFehlerAusgabe());
						klon.setDatei(getDatei());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
