/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Sammelt alle Stoppbedingungen zu einer Anwendung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlStoppBedingung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _nachfolger
			= new String
			()
			;
			private String
			 _rechner
			= new String
			()
			;
			private 	RelativerZeitstempel
			 _warteZeit
			;
	
		/**
		Anwendung die zuvor gestoppt sein muss.
		<p>
		
		</p>
		
		@return der Wert von Nachfolger.
		*/
			public String
			 getNachfolger() {
			return _nachfolger;
		}
	
		/**
		Anwendung die zuvor gestoppt sein muss.
		<p>
		
		</p>
		
		@param _nachfolger der neue Wert von Nachfolger.
		*/
		public void setNachfolger(String
		 _nachfolger) {
			if (_nachfolger.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._nachfolger = _nachfolger;
		}
	
		/**
		Rechner Adresse auf dem die zustoppende Anwendung läuft.
		<p>
		
		</p>
		
		@return der Wert von Rechner.
		*/
			public String
			 getRechner() {
			return _rechner;
		}
	
		/**
		Rechner Adresse auf dem die zustoppende Anwendung läuft.
		<p>
		
		</p>
		
		@param _rechner der neue Wert von Rechner.
		*/
		public void setRechner(String
		 _rechner) {
			if (_rechner.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._rechner = _rechner;
		}
	
		/**
		Zeitdauer die noch gewartet werden muss bis der Stopp der Anwendung erfolgen soll.
		<p>
		
		</p>
		
		@return der Wert von WarteZeit.
		*/
			public 	RelativerZeitstempel
			 getWarteZeit() {
			return _warteZeit;
		}
	
		/**
		Zeitdauer die noch gewartet werden muss bis der Stopp der Anwendung erfolgen soll.
		<p>
		
		</p>
		
		@param _warteZeit der neue Wert von WarteZeit.
		*/
		public void setWarteZeit(	RelativerZeitstempel
		 _warteZeit) {
			this._warteZeit = _warteZeit;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getNachfolger() != null) {
					datum.getTextValue("Nachfolger").setText(getNachfolger());
				}
				// ZeichenkettenAttributTyp
				if (getRechner() != null) {
					datum.getTextValue("Rechner").setText(getRechner());
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("WarteZeit").setMillis(getWarteZeit().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setNachfolger(daten.getTextValue("Nachfolger").getText());
				// ZeichenkettenAttributTyp
					setRechner(daten.getTextValue("Rechner").getText());
				// ZeitstempelAttributTyp
					setWarteZeit(new
						RelativerZeitstempel
						(daten.getTimeValue("WarteZeit").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlStoppBedingung clone() {
		AtlStoppBedingung klon = new AtlStoppBedingung();
		
						klon.setNachfolger(getNachfolger());
						klon.setRechner(getRechner());
						klon.setWarteZeit(getWarteZeit());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
