/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributtyp, der die Fehler in der Attributgruppe atg.startStoppAntwort beschreibt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttStartStoppFehler extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Die Anforderung (atg.startStoppAnfrage) war fehlerfrei.
	<p>
	
	</p>
	*/
	public static final AttStartStoppFehler ZUSTAND_0_KEIN_FEHLER = new AttStartStoppFehler("kein Fehler", 		Byte
	.valueOf("0"));

	/**
	Aktion nicht bekannt.
	<p>
	
	</p>
	*/
	public static final AttStartStoppFehler ZUSTAND_1_FEHLER_AKTION = new AttStartStoppFehler("Fehler Aktion", 		Byte
	.valueOf("1"));

	/**
	kein StartStopp Block mit dieser ID vorhanden.
	<p>
	
	</p>
	*/
	public static final AttStartStoppFehler ZUSTAND_2_FEHLER_STARTSTOPP_BLOCK_ID = new AttStartStoppFehler("Fehler StartStopp-Block ID", 		Byte
	.valueOf("2"));

	/**
	kein Prozess mit dieser ID vorhanden.
	<p>
	
	</p>
	*/
	public static final AttStartStoppFehler ZUSTAND_3_FEHLER_PROZESS_ID = new AttStartStoppFehler("Fehler Prozess ID", 		Byte
	.valueOf("3"));

	/**
	übergebene StartStopp Datei nicht gefunden.
	<p>
	
	</p>
	*/
	public static final AttStartStoppFehler ZUSTAND_4_DATEIFEHLER = new AttStartStoppFehler("Dateifehler", 		Byte
	.valueOf("4"));

	/**
	XML Struktur entspricht nit der DTD.
	<p>
	
	</p>
	*/
	public static final AttStartStoppFehler ZUSTAND_5_FEHLER_XML_STRUKTUR = new AttStartStoppFehler("Fehler XML-Struktur", 		Byte
	.valueOf("5"));

	/**
	kein Prozess mit diesem Namen vorhanden.
	<p>
	
	</p>
	*/
	public static final AttStartStoppFehler ZUSTAND_6_FEHLER_PROZESS_NAME = new AttStartStoppFehler("Fehler Prozess Name", 		Byte
	.valueOf("6"));

	/**
	Fehler in der Kombination Aktion - PID - Name.
	<p>
	
	</p>
	*/
	public static final AttStartStoppFehler ZUSTAND_7_FEHLER_AKTION_PID_NAME = new AttStartStoppFehler("Fehler Aktion-PID-Name", 		Byte
	.valueOf("7"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttStartStoppFehler getZustand(final 		Byte
	 value) {
		for (AttStartStoppFehler e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttStartStoppFehler getZustand(final String value) {
		for (AttStartStoppFehler e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttStartStoppFehler> getZustaende() {
		List<AttStartStoppFehler> list = new ArrayList<AttStartStoppFehler>();
		list.add(ZUSTAND_0_KEIN_FEHLER);
		list.add(ZUSTAND_1_FEHLER_AKTION);
		list.add(ZUSTAND_2_FEHLER_STARTSTOPP_BLOCK_ID);
		list.add(ZUSTAND_3_FEHLER_PROZESS_ID);
		list.add(ZUSTAND_4_DATEIFEHLER);
		list.add(ZUSTAND_5_FEHLER_XML_STRUKTUR);
		list.add(ZUSTAND_6_FEHLER_PROZESS_NAME);
		list.add(ZUSTAND_7_FEHLER_AKTION_PID_NAME);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut StartStoppFehler.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttStartStoppFehler(final 		Byte
	 value) {
		super(value);
	}
	
	private AttStartStoppFehler(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
