/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zustand einer Inkarnation oder eines StartStopp Blocks.
<p>
Der Attributtyp wird verwendet, um Zustände einzelner Inkarnationen der
			                StartStopp Applikation zu beschreiben. Einzelne Zustände werden auch
			                verwendet, um den Zustand eines StartStopp Blocks zu beschreiben.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AttStartStoppZustand extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Inkarnation&#47;StartStopp Block  wurde angelegt.
	<p>
	
	</p>
	*/
	public static final AttStartStoppZustand ZUSTAND_0_ANGELEGT = new AttStartStoppZustand("angelegt", 		Byte
	.valueOf("0"));

	/**
	Inkarnation wartet auf Erfüllung der Startbedingung.
	<p>
	
	</p>
	*/
	public static final AttStartStoppZustand ZUSTAND_1_WARTE_STARTBEDINGUNG = new AttStartStoppZustand("warte Startbedingung", 		Byte
	.valueOf("1"));

	/**
	Inkarnation ist in der Startphase.
	<p>
	
	</p>
	*/
	public static final AttStartStoppZustand ZUSTAND_3_STARTEN = new AttStartStoppZustand("starten", 		Byte
	.valueOf("3"));

	/**
	Inkarnation&#47;StartStopp Block ist gestartet.
	<p>
	
	</p>
	*/
	public static final AttStartStoppZustand ZUSTAND_4_GESTARTET = new AttStartStoppZustand("gestartet", 		Byte
	.valueOf("4"));

	/**
	Inkarnation ist initialisiert.
	<p>
	
	</p>
	*/
	public static final AttStartStoppZustand ZUSTAND_5_INITIALISIERT = new AttStartStoppZustand("initialisiert", 		Byte
	.valueOf("5"));

	/**
	Inkarnation wartet auf Erfüllung der Stoppbedingung.
	<p>
	
	</p>
	*/
	public static final AttStartStoppZustand ZUSTAND_6_WARTE_STOPPBEDINGUNG = new AttStartStoppZustand("warte Stoppbedingung", 		Byte
	.valueOf("6"));

	/**
	Inkarnation wird gestoppt.
	<p>
	
	</p>
	*/
	public static final AttStartStoppZustand ZUSTAND_7_STOPPEN = new AttStartStoppZustand("stoppen", 		Byte
	.valueOf("7"));

	/**
	Inkarnation&#47;StartStopp Block.
	<p>
	
	</p>
	*/
	public static final AttStartStoppZustand ZUSTAND_8_GESTOPPT = new AttStartStoppZustand("gestoppt", 		Byte
	.valueOf("8"));

	/**
	Inkarnation wartet auf zyklischen Neustart.
	<p>
	
	</p>
	*/
	public static final AttStartStoppZustand ZUSTAND_9_WARTE_INTERVALL = new AttStartStoppZustand("warte intervall", 		Byte
	.valueOf("9"));

	/**
	Inkarnation&#47;StartStopp Block gelöscht.
	<p>
	
	</p>
	*/
	public static final AttStartStoppZustand ZUSTAND_10_GELOESCHT = new AttStartStoppZustand("gelöscht", 		Byte
	.valueOf("10"));

	/**
	Beim Starten der Inkarnation (des StartStopp Blocks) ist ein Fehler aufgetreten.
	<p>
	
	</p>
	*/
	public static final AttStartStoppZustand ZUSTAND_1N_FEHLER = new AttStartStoppZustand("Fehler", 		Byte
	.valueOf("-1"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttStartStoppZustand getZustand(final 		Byte
	 value) {
		for (AttStartStoppZustand e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttStartStoppZustand getZustand(final String value) {
		for (AttStartStoppZustand e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttStartStoppZustand> getZustaende() {
		List<AttStartStoppZustand> list = new ArrayList<AttStartStoppZustand>();
		list.add(ZUSTAND_0_ANGELEGT);
		list.add(ZUSTAND_1_WARTE_STARTBEDINGUNG);
		list.add(ZUSTAND_3_STARTEN);
		list.add(ZUSTAND_4_GESTARTET);
		list.add(ZUSTAND_5_INITIALISIERT);
		list.add(ZUSTAND_6_WARTE_STOPPBEDINGUNG);
		list.add(ZUSTAND_7_STOPPEN);
		list.add(ZUSTAND_8_GESTOPPT);
		list.add(ZUSTAND_9_WARTE_INTERVALL);
		list.add(ZUSTAND_10_GELOESCHT);
		list.add(ZUSTAND_1N_FEHLER);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut StartStoppZustand.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttStartStoppZustand(final 		Byte
	 value) {
		super(value);
	}
	
	private AttStartStoppZustand(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
