/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Informationen zum Zeitserver:AktuellerZeitserver,Zeitserverliste,Zeitkorrektur mit Zeitstempel.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdDcfStatus extends AbstractOnlineDatensatz<OdDcfStatus.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Zustand,
				};
			}
	
			/**
			 * Zustand.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Zustand = new Aspekte("Zustand", "asp.zustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _aktuellerZeitServer
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlVorhandeneZeitServer
				> _vorhandeneZeitServer = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlVorhandeneZeitServer
				>(0, true);
				private String
				 _letzteZeitKorrektur
				= new String
				()
				;
		
			/**
			Name AktuellerZeitserver.
			<p>
			
			</p>
			
			@return der Wert von AktuellerZeitServer.
			*/
				public String
				 getAktuellerZeitServer() {
				return _aktuellerZeitServer;
			}
		
			/**
			Name AktuellerZeitserver.
			<p>
			
			</p>
			
			@param _aktuellerZeitServer der neue Wert von AktuellerZeitServer.
			*/
			public void setAktuellerZeitServer(String
			 _aktuellerZeitServer) {
				if (_aktuellerZeitServer.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._aktuellerZeitServer = _aktuellerZeitServer;
			}
		
			/**
			Enthält alle Zeitserver.
			<p>
			
			</p>
			
			@return der Wert von VorhandeneZeitServer.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlVorhandeneZeitServer
				> getVorhandeneZeitServer() {
				return _vorhandeneZeitServer;
			}
		
		
			/**
			Info Zeitkorrektur.
			<p>
			
			</p>
			
			@return der Wert von LetzteZeitKorrektur.
			*/
				public String
				 getLetzteZeitKorrektur() {
				return _letzteZeitKorrektur;
			}
		
			/**
			Info Zeitkorrektur.
			<p>
			
			</p>
			
			@param _letzteZeitKorrektur der neue Wert von LetzteZeitKorrektur.
			*/
			public void setLetzteZeitKorrektur(String
			 _letzteZeitKorrektur) {
				if (_letzteZeitKorrektur.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._letzteZeitKorrektur = _letzteZeitKorrektur;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getAktuellerZeitServer() != null) {
						datum.getTextValue("AktuellerZeitServer").setText(getAktuellerZeitServer());
					}
					// AttributListenDefinition
						final Data.Array arrayVorhandeneZeitServer = datum.getArray("VorhandeneZeitServer");
						arrayVorhandeneZeitServer.setLength(getVorhandeneZeitServer().size());
						for (int i = 0; i < arrayVorhandeneZeitServer.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlVorhandeneZeitServer
							 atl = getVorhandeneZeitServer().get(i);
							atl.bean2Atl(arrayVorhandeneZeitServer.getItem(i), factory);
		
						}
					// ZeichenkettenAttributTyp
					if (getLetzteZeitKorrektur() != null) {
						datum.getTextValue("LetzteZeitKorrektur").setText(getLetzteZeitKorrektur());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setAktuellerZeitServer(daten.getTextValue("AktuellerZeitServer").getText());
					// AttributListenDefinition
						final Data.Array arrayVorhandeneZeitServer = daten.getArray("VorhandeneZeitServer");
						for (int i = 0; i < arrayVorhandeneZeitServer.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlVorhandeneZeitServer
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlVorhandeneZeitServer
							 ();
							atl.atl2Bean(arrayVorhandeneZeitServer.getItem(i), factory);
							getVorhandeneZeitServer().add(atl);
						}
					// ZeichenkettenAttributTyp
						setLetzteZeitKorrektur(daten.getTextValue("LetzteZeitKorrektur").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAktuellerZeitServer(getAktuellerZeitServer());
						klon._vorhandeneZeitServer = getVorhandeneZeitServer().clone();
							klon.setLetzteZeitKorrektur(getLetzteZeitKorrektur());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.dcfStatus";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdDcfStatus(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
