/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
4 verschiedene Formen von StartStoppAnfragen vom Datenverteiler.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class OdStartStoppAnfrage extends AbstractOnlineDatensatz<OdStartStoppAnfrage.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Anfrage,
				};
			}
	
			/**
			 * Wird zur Anfrage von Informationen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Anfrage = new Aspekte("Anfrage", "asp.anfrage");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
				 _absenderId
				;
				private String
				 _absenderZeichen
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV1
				> _v1 = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV1
				>(1, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV2
				> _v2 = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV2
				>(1, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV3
				> _v3 = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV3
				>(1, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV4
				> _v4 = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV4
				>(1, true);
		
			/**
			Id des Absenderobjekts.
			<p>
			
			</p>
			
			@return der Wert von AbsenderId.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
				 getAbsenderId() {
				return _absenderId;
			}
		
			/**
			Id des Absenderobjekts.
			<p>
			
			</p>
			
			@param _absenderId der neue Wert von AbsenderId.
			*/
			public void setAbsenderId(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
			 _absenderId) {
				this._absenderId = _absenderId;
			}
		
			/**
			Kennzeichnung, die von der anfragenden Applikation beliebig vergeben wird.
			<p>
			
			</p>
			
			@return der Wert von AbsenderZeichen.
			*/
				public String
				 getAbsenderZeichen() {
				return _absenderZeichen;
			}
		
			/**
			Kennzeichnung, die von der anfragenden Applikation beliebig vergeben wird.
			<p>
			
			</p>
			
			@param _absenderZeichen der neue Wert von AbsenderZeichen.
			*/
			public void setAbsenderZeichen(String
			 _absenderZeichen) {
				if (_absenderZeichen.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._absenderZeichen = _absenderZeichen;
			}
		
			/**
			Übergabe der Start&#47;Stopp Informationen als Attribute.
			<p>
			
			</p>
			
			@return der Wert von V1.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV1
				> getV1() {
				return _v1;
			}
		
		
			/**
			Übergabe der Start&#47;Stopp Informationen in einer XML-Struktur.
			<p>
			
			</p>
			
			@return der Wert von V2.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV2
				> getV2() {
				return _v2;
			}
		
		
			/**
			Übergabe der Start&#47;Stopp Informationen in einer XML-Datei.
			<p>
			
			</p>
			
			@return der Wert von V3.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV3
				> getV3() {
				return _v3;
			}
		
		
			/**
			Übergabe der Start&#47;Stopp Informationen durch Angabe eines Inkarnationsnamen.
			<p>
			
			</p>
			
			@return der Wert von V4.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV4
				> getV4() {
				return _v4;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soAbsenderId = getAbsenderId();
						final SystemObject tmpAbsenderId;
							if (soAbsenderId instanceof SystemObject) {
								tmpAbsenderId = (SystemObject)soAbsenderId;
							} else if(soAbsenderId instanceof SystemObjekt){
								tmpAbsenderId = ((SystemObjekt)soAbsenderId).getSystemObject();
							} else{
								tmpAbsenderId = null;
							}
						datum.getReferenceValue("absenderId").setSystemObject(tmpAbsenderId);
					// ZeichenkettenAttributTyp
					if (getAbsenderZeichen() != null) {
						datum.getTextValue("absenderZeichen").setText(getAbsenderZeichen());
					}
					// AttributListenDefinition
						final Data.Array arrayV1 = datum.getArray("V1");
						arrayV1.setLength(getV1().size());
						for (int i = 0; i < arrayV1.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV1
							 atl = getV1().get(i);
							atl.bean2Atl(arrayV1.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayV2 = datum.getArray("V2");
						arrayV2.setLength(getV2().size());
						for (int i = 0; i < arrayV2.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV2
							 atl = getV2().get(i);
							atl.bean2Atl(arrayV2.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayV3 = datum.getArray("V3");
						arrayV3.setLength(getV3().size());
						for (int i = 0; i < arrayV3.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV3
							 atl = getV3().get(i);
							atl.bean2Atl(arrayV3.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayV4 = datum.getArray("V4");
						arrayV4.setLength(getV4().size());
						for (int i = 0; i < arrayV4.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV4
							 atl = getV4().get(i);
							atl.bean2Atl(arrayV4.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idAbsenderId = daten.getReferenceValue("absenderId").getId();
						final SystemObjekt tmpAbsenderId;
						if (idAbsenderId == 0) {
							tmpAbsenderId = null;
						} else {
							final SystemObject soAbsenderId = factory.getDav().getDataModel().getObject(idAbsenderId);
							if (soAbsenderId == null) {
									tmpAbsenderId = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.ApplikationUngueltig(idAbsenderId);
							} else {
								tmpAbsenderId = factory.getModellobjekt(soAbsenderId);
							}
						}
						setAbsenderId((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
						) tmpAbsenderId);
					// ZeichenkettenAttributTyp
						setAbsenderZeichen(daten.getTextValue("absenderZeichen").getText());
					// AttributListenDefinition
						final Data.Array arrayV1 = daten.getArray("V1");
						for (int i = 0; i < arrayV1.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV1
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV1
							 ();
							atl.atl2Bean(arrayV1.getItem(i), factory);
							getV1().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayV2 = daten.getArray("V2");
						for (int i = 0; i < arrayV2.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV2
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV2
							 ();
							atl.atl2Bean(arrayV2.getItem(i), factory);
							getV2().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayV3 = daten.getArray("V3");
						for (int i = 0; i < arrayV3.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV3
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV3
							 ();
							atl.atl2Bean(arrayV3.getItem(i), factory);
							getV3().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayV4 = daten.getArray("V4");
						for (int i = 0; i < arrayV4.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV4
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlV4
							 ();
							atl.atl2Bean(arrayV4.getItem(i), factory);
							getV4().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAbsenderId(getAbsenderId());
							klon.setAbsenderZeichen(getAbsenderZeichen());
						klon._v1 = getV1().clone();
						klon._v2 = getV2().clone();
						klon._v3 = getV3().clone();
						klon._v4 = getV4().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.startStoppAnfrage";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdStartStoppAnfrage(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
