/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zur Übertragung von Antwortnachrichten von Start&#47;Stopp auf Anfragen an Start&#47;Stopp.
<p>
Wird für die Übertragung von entsprechende Antworten auf Anfragen an Start&#47;Stopp benutzt.
							Die Anfragen werden unter typ.rechner&#47;atg.startStoppAnfrage gestellt.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class OdStartStoppAntwort extends AbstractOnlineDatensatz<OdStartStoppAntwort.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Antwort,
				};
			}
	
			/**
			 * Wird zur Beantwortung von Anfragen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Antwort = new Aspekte("Antwort", "asp.antwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _absenderZeichen
				= new String
				()
				;
				private String
				 _id
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppIdArt
				 _art
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppZustand
				 _zustand
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppFehler
				 _fehler
				;
		
			/**
			Kennzeichnung, die von der anfragenden Applikation beliebig vergeben wird.
			<p>
			
			</p>
			
			@return der Wert von AbsenderZeichen.
			*/
				public String
				 getAbsenderZeichen() {
				return _absenderZeichen;
			}
		
			/**
			Kennzeichnung, die von der anfragenden Applikation beliebig vergeben wird.
			<p>
			
			</p>
			
			@param _absenderZeichen der neue Wert von AbsenderZeichen.
			*/
			public void setAbsenderZeichen(String
			 _absenderZeichen) {
				if (_absenderZeichen.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._absenderZeichen = _absenderZeichen;
			}
		
			/**
			Id des Prozesses bzw. des StartStopp Blocks auf die sich die Antwort bezieht.
			<p>
			Eindeutige Id zur Zuordnung der Antwort zu dem entsprechenden Prozess bzw. StartStopp Block
			</p>
			
			@return der Wert von Id.
			*/
				public String
				 getId() {
				return _id;
			}
		
			/**
			Id des Prozesses bzw. des StartStopp Blocks auf die sich die Antwort bezieht.
			<p>
			Eindeutige Id zur Zuordnung der Antwort zu dem entsprechenden Prozess bzw. StartStopp Block
			</p>
			
			@param _id der neue Wert von Id.
			*/
			public void setId(String
			 _id) {
				if (_id.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._id = _id;
			}
		
			/**
			Art der Id.
			<p>
			Kennung ob es sich bei der Id um die ID eines Prozesses oder eines StartStopp Blocks
											handelt.
			</p>
			
			@return der Wert von Art.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppIdArt
				 getArt() {
				return _art;
			}
		
			/**
			Art der Id.
			<p>
			Kennung ob es sich bei der Id um die ID eines Prozesses oder eines StartStopp Blocks
											handelt.
			</p>
			
			@param _art der neue Wert von Art.
			*/
			public void setArt(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppIdArt
			 _art) {
				this._art = _art;
			}
		
			/**
			Zustand des Prozesses bzw. des StartStopp Blocks.
			<p>
			Zustand des Prozesses bzw. des StartStopp Blocks
			</p>
			
			@return der Wert von Zustand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppZustand
				 getZustand() {
				return _zustand;
			}
		
			/**
			Zustand des Prozesses bzw. des StartStopp Blocks.
			<p>
			Zustand des Prozesses bzw. des StartStopp Blocks
			</p>
			
			@param _zustand der neue Wert von Zustand.
			*/
			public void setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppZustand
			 _zustand) {
				this._zustand = _zustand;
			}
		
			/**
			Fehler in der StartStoppAnforderung.
			<p>
			Fehler in der StartStoppAnforderung
			</p>
			
			@return der Wert von Fehler.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppFehler
				 getFehler() {
				return _fehler;
			}
		
			/**
			Fehler in der StartStoppAnforderung.
			<p>
			Fehler in der StartStoppAnforderung
			</p>
			
			@param _fehler der neue Wert von Fehler.
			*/
			public void setFehler(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppFehler
			 _fehler) {
				this._fehler = _fehler;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getAbsenderZeichen() != null) {
						datum.getTextValue("absenderZeichen").setText(getAbsenderZeichen());
					}
					// ZeichenkettenAttributTyp
					if (getId() != null) {
						datum.getTextValue("id").setText(getId());
					}
					// GanzzahlAttributTyp
					if (getArt() != null) {
		                if (getArt().isZustand()) {
		                    datum.getUnscaledValue("art").setText(getArt().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("art").set(getArt().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getZustand() != null) {
		                if (getZustand().isZustand()) {
		                    datum.getUnscaledValue("zustand").setText(getZustand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("zustand").set(getZustand().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFehler() != null) {
		                if (getFehler().isZustand()) {
		                    datum.getUnscaledValue("fehler").setText(getFehler().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("fehler").set(getFehler().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setAbsenderZeichen(daten.getTextValue("absenderZeichen").getText());
					// ZeichenkettenAttributTyp
						setId(daten.getTextValue("id").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("art").isState()) {
								setArt(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppIdArt
								.getZustand(daten.getScaledValue("art").getText()));
							} else {
							setArt(new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppIdArt
							(daten.
								getUnscaledValue
							("art").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("zustand").isState()) {
								setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppZustand
								.getZustand(daten.getScaledValue("zustand").getText()));
							} else {
							setZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppZustand
							(daten.
								getUnscaledValue
							("zustand").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("fehler").isState()) {
								setFehler(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppFehler
								.getZustand(daten.getScaledValue("fehler").getText()));
							} else {
							setFehler(new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppFehler
							(daten.
								getUnscaledValue
							("fehler").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAbsenderZeichen(getAbsenderZeichen());
							klon.setId(getId());
							klon.setArt(getArt());
							klon.setZustand(getZustand());
							klon.setFehler(getFehler());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.startStoppAntwort";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdStartStoppAntwort(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
