/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zusammenfassung aller je Fahrstreifen ermittelten Sensorikwerte.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlGmaUmfelddatenFuerFahrstreifen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnOberFlaechenTemperatur
			> _fahrBahnOberFlaechenTemperatur = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnOberFlaechenTemperatur
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnFeuchte
			> _fahrBahnFeuchte = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnFeuchte
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRestSalz
			> _restSalz = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRestSalz
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsGefrierTemperatur
			> _gefrierTemperatur = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsGefrierTemperatur
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe1
			> _temperaturInTiefe1 = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe1
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe2
			> _temperaturInTiefe2 = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe2
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe3
			> _temperaturInTiefe3 = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe3
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnOberFlaechenZustand
			> _fahrBahnOberFlaechenZustand = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnOberFlaechenZustand
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
			> _wasserFilmDicke = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsTauStoffKonzentration
			> _tauStoffKonzentration = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsTauStoffKonzentration
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnGlaette
			> _fahrBahnGlaette = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnGlaette
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsGlaettewarnungHersteller
			> _glaettewarnungHersteller = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsGlaettewarnungHersteller
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsZeitreserveEisglaette
			> _zeitreserveEisglaette = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsZeitreserveEisglaette
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsZeitreserveReifglaette
			> _zeitreserveReifglaette = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsZeitreserveReifglaette
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			> _aktuellerZustand = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			> _prognoseZustandIn5Minuten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			> _prognoseZustandIn15Minuten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			> _prognoseZustandIn30Minuten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			> _prognoseZustandIn60Minuten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			> _prognoseZustandIn90Minuten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			>(1, true);
	
		/**
		Temperatur der Oberfläche der Fahrbahn.
		<p>
		Werden andere Zustände an der Oberfläche (z.B. Benetzung) erfasst, so muss die Oberflächentemperatur in örtlichen Bezug zu diesen Größen stehen. Die Fahrbahnoberflächentemperatur wird in Grad Celsius angegeben. Es wird der IST-Wert übertragen.
		</p>
		
		@return der Wert von FahrBahnOberFlaechenTemperatur.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnOberFlaechenTemperatur
			> getFahrBahnOberFlaechenTemperatur() {
			return _fahrBahnOberFlaechenTemperatur;
		}
	
	
		/**
		Typ 50 - Fahrbahnfeuchte.
		<p>
		DE-Typ 50 nicht mehr für Neuanwendungen verwenden. Der DE-Typ wird durch "Wasserfilmdicke" (DE-Typ 72) ersetzt.
		</p>
		
		@return der Wert von FahrBahnFeuchte.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnFeuchte
			> getFahrBahnFeuchte() {
			return _fahrBahnFeuchte;
		}
	
	
		/**
		Restsalz.
		<p>
		Sättigungsgrad des gelösten Salzes auf der Fahrbahn (bzw. auf der Fahrbahnsensorik). SR wird in Prozent (%) angegeben. Es wird der IST-Wert übertragen.
		</p>
		
		@return der Wert von RestSalz.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRestSalz
			> getRestSalz() {
			return _restSalz;
		}
	
	
		/**
		Gefriertemperatur.
		<p>
		&lt;absatz&gt;
								Die Gefriertemperatur ist diejenige Temperatur in Grad Celsius, bei der die an der Oberfläche der Sonde vorhandene wässrige Taumittel-Lösung gefrieren (Übergang in den festen Aggregatszustand) könnte. Es wird der IST-Wert übertragen.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								0 °C Keine Gefriertemperatur-Erniedrigung bzw. keine Taumittelkonzentration messbar bzw. die Bedingungen lassen eine Bestimmung nicht zu. Wenn gleichzeitig auch ?Salzrest? (DE-Typ 52) übertragen wird ist auch dieser Wert zu betrachten (255 = nicht messbar).
							&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von GefrierTemperatur.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsGefrierTemperatur
			> getGefrierTemperatur() {
			return _gefrierTemperatur;
		}
	
	
		/**
		Bodentemperatur.
		<p>
		Temperatur gemessen in der Tiefe 1, 2 oder 3 unter der Fahrbahn. Ist eine Fahrbahnsonde in die Oberfläche eingelassen, so befindet sich die Messstelle direkt unter der Fahrbahnsonde in der betreffenden Tiefe Es wird der IST-Wert übertragen.
		</p>
		
		@return der Wert von TemperaturInTiefe1.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe1
			> getTemperaturInTiefe1() {
			return _temperaturInTiefe1;
		}
	
	
		/**
		Bodentemperatur.
		<p>
		Temperatur gemessen in der Tiefe 1, 2 oder 3 unter der Fahrbahn. Ist eine Fahrbahnsonde in die Oberfläche eingelassen, so befindet sich die Messstelle direkt unter der Fahrbahnsonde in der betreffenden Tiefe Es wird der IST-Wert übertragen.
		</p>
		
		@return der Wert von TemperaturInTiefe2.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe2
			> getTemperaturInTiefe2() {
			return _temperaturInTiefe2;
		}
	
	
		/**
		Bodentemperatur.
		<p>
		Temperatur gemessen in der Tiefe 1, 2 oder 3 unter der Fahrbahn. Ist eine Fahrbahnsonde in die Oberfläche eingelassen, so befindet sich die Messstelle direkt unter der Fahrbahnsonde in der betreffenden Tiefe Es wird der IST-Wert übertragen.
		</p>
		
		@return der Wert von TemperaturInTiefe3.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe3
			> getTemperaturInTiefe3() {
			return _temperaturInTiefe3;
		}
	
	
		/**
		Zustand der Fahrbahnoberfläche.
		<p>
		
		</p>
		
		@return der Wert von FahrBahnOberFlaechenZustand.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnOberFlaechenZustand
			> getFahrBahnOberFlaechenZustand() {
			return _fahrBahnOberFlaechenZustand;
		}
	
	
		/**
		Wasserfilmdicke.
		<p>
		Bei WFD oberhalb 0,1 mm wird nur eine Messgenauigkeit im 1&#47;10 mm Bereich erreicht. Bei WFD oberhalb 2 mm liegt die Messgenauigkeit in der Regel im mm Bereich. Die rechnerische Wasserfilmdicke gibt die Fahrbahnbenetzung in mm (= Liter&#47;m2 ) mit Wasser oder wässriger Lösung (Salzgemisch) an, welche sich am Messort bzw. auf der in der Fahrbahn eingelassenen Sonde befindet. Die Wasserfilmdicke ist immer bezogen auf eine glatte ebene Fläche.
		</p>
		
		@return der Wert von WasserFilmDicke.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
			> getWasserFilmDicke() {
			return _wasserFilmDicke;
		}
	
	
		/**
		Taustoffkonzentration.
		<p>
		Prozentualer Anteil des gelösten Taustoffs im Wasser auf der
		          Fahrbahn (bzw. auf der Fahrbahnsensorik).
		</p>
		
		@return der Wert von TauStoffKonzentration.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsTauStoffKonzentration
			> getTauStoffKonzentration() {
			return _tauStoffKonzentration;
		}
	
	
		/**
		Ergebnisse der Glättewarnung und Prognose.
		<p>
		
		</p>
		
		@return der Wert von FahrBahnGlaette.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnGlaette
			> getFahrBahnGlaette() {
			return _fahrBahnGlaette;
		}
	
	
		/**
		Attribut fasst GlätteMeldungen verschiedener Hersteller zusammen.
		<p>
		&lt;absatz&gt;Die einem Status intern zugeordnete Nummer, wurde durch folgende 4-Byte-Kodierung bestimmt:&lt;&#47;absatz&gt;
		          &lt;absatz&gt;1. Byte: Herstellercode (att.tlsHersteller: 17=MicKS, 21=Boschung, 44=Vaisala)&lt;&#47;absatz&gt;
		          &lt;absatz&gt;2. zweites Byte: DE-Typ&lt;&#47;absatz&gt;
		          &lt;absatz&gt;3.u.4. Byte: herstellerspezifischer Zustand&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von GlaettewarnungHersteller.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsGlaettewarnungHersteller
			> getGlaettewarnungHersteller() {
			return _glaettewarnungHersteller;
		}
	
	
		/**
		Zeitreserve Eisglätte.
		<p>
		Gibt die Zeit bis zu einer möglichen Eisglätte an.
		</p>
		
		@return der Wert von ZeitreserveEisglaette.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsZeitreserveEisglaette
			> getZeitreserveEisglaette() {
			return _zeitreserveEisglaette;
		}
	
	
		/**
		Zeitreserve Reifglätte.
		<p>
		Gibt die Zeit bis zu einer möglichen Reifglätte an.
		</p>
		
		@return der Wert von ZeitreserveReifglaette.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsZeitreserveReifglaette
			> getZeitreserveReifglaette() {
			return _zeitreserveReifglaette;
		}
	
	
		/**
		Aktueller Wert der Glätteprognose.
		<p>
		
		</p>
		
		@return der Wert von AktuellerZustand.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			> getAktuellerZustand() {
			return _aktuellerZustand;
		}
	
	
		/**
		Wert der Glätteprognose für den Prognosehorizont 5 Minuten.
		<p>
		
		</p>
		
		@return der Wert von PrognoseZustandIn5Minuten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			> getPrognoseZustandIn5Minuten() {
			return _prognoseZustandIn5Minuten;
		}
	
	
		/**
		Wert der Glätteprognose für den Prognosehorizont 15 Minuten.
		<p>
		
		</p>
		
		@return der Wert von PrognoseZustandIn15Minuten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			> getPrognoseZustandIn15Minuten() {
			return _prognoseZustandIn15Minuten;
		}
	
	
		/**
		Wert der Glätteprognose für den Prognosehorizont 30 Minuten.
		<p>
		
		</p>
		
		@return der Wert von PrognoseZustandIn30Minuten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			> getPrognoseZustandIn30Minuten() {
			return _prognoseZustandIn30Minuten;
		}
	
	
		/**
		Wert der Glätteprognose für den Prognosehorizont 60 Minuten.
		<p>
		
		</p>
		
		@return der Wert von PrognoseZustandIn60Minuten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			> getPrognoseZustandIn60Minuten() {
			return _prognoseZustandIn60Minuten;
		}
	
	
		/**
		Wert der Glätteprognose für den Prognosehorizont 90 Minuten.
		<p>
		
		</p>
		
		@return der Wert von PrognoseZustandIn90Minuten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			> getPrognoseZustandIn90Minuten() {
			return _prognoseZustandIn90Minuten;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getFahrBahnOberFlaechenTemperatur() != null) {
					final Data.NumberArray arrayFahrBahnOberFlaechenTemperatur = datum.
						getScaledArray
						("FahrBahnOberFlächenTemperatur");
					arrayFahrBahnOberFlaechenTemperatur.setLength(getFahrBahnOberFlaechenTemperatur().size());
					for (int i = 0; i < arrayFahrBahnOberFlaechenTemperatur.getLength(); ++i) {
						arrayFahrBahnOberFlaechenTemperatur.getValue(i).set(getFahrBahnOberFlaechenTemperatur().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getFahrBahnFeuchte() != null) {
					final Data.NumberArray arrayFahrBahnFeuchte = datum.
						getUnscaledArray
						("FahrBahnFeuchte");
					arrayFahrBahnFeuchte.setLength(getFahrBahnFeuchte().size());
					for (int i = 0; i < arrayFahrBahnFeuchte.getLength(); ++i) {
						arrayFahrBahnFeuchte.getValue(i).set(getFahrBahnFeuchte().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getRestSalz() != null) {
					final Data.NumberArray arrayRestSalz = datum.
						getUnscaledArray
						("RestSalz");
					arrayRestSalz.setLength(getRestSalz().size());
					for (int i = 0; i < arrayRestSalz.getLength(); ++i) {
						arrayRestSalz.getValue(i).set(getRestSalz().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getGefrierTemperatur() != null) {
					final Data.NumberArray arrayGefrierTemperatur = datum.
						getScaledArray
						("GefrierTemperatur");
					arrayGefrierTemperatur.setLength(getGefrierTemperatur().size());
					for (int i = 0; i < arrayGefrierTemperatur.getLength(); ++i) {
						arrayGefrierTemperatur.getValue(i).set(getGefrierTemperatur().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getTemperaturInTiefe1() != null) {
					final Data.NumberArray arrayTemperaturInTiefe1 = datum.
						getScaledArray
						("TemperaturInTiefe1");
					arrayTemperaturInTiefe1.setLength(getTemperaturInTiefe1().size());
					for (int i = 0; i < arrayTemperaturInTiefe1.getLength(); ++i) {
						arrayTemperaturInTiefe1.getValue(i).set(getTemperaturInTiefe1().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getTemperaturInTiefe2() != null) {
					final Data.NumberArray arrayTemperaturInTiefe2 = datum.
						getScaledArray
						("TemperaturInTiefe2");
					arrayTemperaturInTiefe2.setLength(getTemperaturInTiefe2().size());
					for (int i = 0; i < arrayTemperaturInTiefe2.getLength(); ++i) {
						arrayTemperaturInTiefe2.getValue(i).set(getTemperaturInTiefe2().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getTemperaturInTiefe3() != null) {
					final Data.NumberArray arrayTemperaturInTiefe3 = datum.
						getScaledArray
						("TemperaturInTiefe3");
					arrayTemperaturInTiefe3.setLength(getTemperaturInTiefe3().size());
					for (int i = 0; i < arrayTemperaturInTiefe3.getLength(); ++i) {
						arrayTemperaturInTiefe3.getValue(i).set(getTemperaturInTiefe3().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getFahrBahnOberFlaechenZustand() != null) {
					final Data.NumberArray arrayFahrBahnOberFlaechenZustand = datum.
						getUnscaledArray
						("FahrBahnOberFlächenZustand");
					arrayFahrBahnOberFlaechenZustand.setLength(getFahrBahnOberFlaechenZustand().size());
					for (int i = 0; i < arrayFahrBahnOberFlaechenZustand.getLength(); ++i) {
						arrayFahrBahnOberFlaechenZustand.getValue(i).set(getFahrBahnOberFlaechenZustand().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getWasserFilmDicke() != null) {
					final Data.NumberArray arrayWasserFilmDicke = datum.
						getScaledArray
						("WasserFilmDicke");
					arrayWasserFilmDicke.setLength(getWasserFilmDicke().size());
					for (int i = 0; i < arrayWasserFilmDicke.getLength(); ++i) {
						arrayWasserFilmDicke.getValue(i).set(getWasserFilmDicke().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getTauStoffKonzentration() != null) {
					final Data.NumberArray arrayTauStoffKonzentration = datum.
						getUnscaledArray
						("TauStoffKonzentration");
					arrayTauStoffKonzentration.setLength(getTauStoffKonzentration().size());
					for (int i = 0; i < arrayTauStoffKonzentration.getLength(); ++i) {
						arrayTauStoffKonzentration.getValue(i).set(getTauStoffKonzentration().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getFahrBahnGlaette() != null) {
					final Data.NumberArray arrayFahrBahnGlaette = datum.
						getUnscaledArray
						("FahrBahnGlätte");
					arrayFahrBahnGlaette.setLength(getFahrBahnGlaette().size());
					for (int i = 0; i < arrayFahrBahnGlaette.getLength(); ++i) {
						arrayFahrBahnGlaette.getValue(i).set(getFahrBahnGlaette().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getGlaettewarnungHersteller() != null) {
					final Data.NumberArray arrayGlaettewarnungHersteller = datum.
						getUnscaledArray
						("GlättewarnungHersteller");
					arrayGlaettewarnungHersteller.setLength(getGlaettewarnungHersteller().size());
					for (int i = 0; i < arrayGlaettewarnungHersteller.getLength(); ++i) {
						arrayGlaettewarnungHersteller.getValue(i).set(getGlaettewarnungHersteller().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getZeitreserveEisglaette() != null) {
					final Data.NumberArray arrayZeitreserveEisglaette = datum.
						getUnscaledArray
						("ZeitreserveEisglätte");
					arrayZeitreserveEisglaette.setLength(getZeitreserveEisglaette().size());
					for (int i = 0; i < arrayZeitreserveEisglaette.getLength(); ++i) {
						arrayZeitreserveEisglaette.getValue(i).set(getZeitreserveEisglaette().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getZeitreserveReifglaette() != null) {
					final Data.NumberArray arrayZeitreserveReifglaette = datum.
						getUnscaledArray
						("ZeitreserveReifglätte");
					arrayZeitreserveReifglaette.setLength(getZeitreserveReifglaette().size());
					for (int i = 0; i < arrayZeitreserveReifglaette.getLength(); ++i) {
						arrayZeitreserveReifglaette.getValue(i).set(getZeitreserveReifglaette().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getAktuellerZustand() != null) {
					final Data.NumberArray arrayAktuellerZustand = datum.
						getUnscaledArray
						("AktuellerZustand");
					arrayAktuellerZustand.setLength(getAktuellerZustand().size());
					for (int i = 0; i < arrayAktuellerZustand.getLength(); ++i) {
						arrayAktuellerZustand.getValue(i).set(getAktuellerZustand().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getPrognoseZustandIn5Minuten() != null) {
					final Data.NumberArray arrayPrognoseZustandIn5Minuten = datum.
						getUnscaledArray
						("PrognoseZustandIn5Minuten");
					arrayPrognoseZustandIn5Minuten.setLength(getPrognoseZustandIn5Minuten().size());
					for (int i = 0; i < arrayPrognoseZustandIn5Minuten.getLength(); ++i) {
						arrayPrognoseZustandIn5Minuten.getValue(i).set(getPrognoseZustandIn5Minuten().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getPrognoseZustandIn15Minuten() != null) {
					final Data.NumberArray arrayPrognoseZustandIn15Minuten = datum.
						getUnscaledArray
						("PrognoseZustandIn15Minuten");
					arrayPrognoseZustandIn15Minuten.setLength(getPrognoseZustandIn15Minuten().size());
					for (int i = 0; i < arrayPrognoseZustandIn15Minuten.getLength(); ++i) {
						arrayPrognoseZustandIn15Minuten.getValue(i).set(getPrognoseZustandIn15Minuten().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getPrognoseZustandIn30Minuten() != null) {
					final Data.NumberArray arrayPrognoseZustandIn30Minuten = datum.
						getUnscaledArray
						("PrognoseZustandIn30Minuten");
					arrayPrognoseZustandIn30Minuten.setLength(getPrognoseZustandIn30Minuten().size());
					for (int i = 0; i < arrayPrognoseZustandIn30Minuten.getLength(); ++i) {
						arrayPrognoseZustandIn30Minuten.getValue(i).set(getPrognoseZustandIn30Minuten().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getPrognoseZustandIn60Minuten() != null) {
					final Data.NumberArray arrayPrognoseZustandIn60Minuten = datum.
						getUnscaledArray
						("PrognoseZustandIn60Minuten");
					arrayPrognoseZustandIn60Minuten.setLength(getPrognoseZustandIn60Minuten().size());
					for (int i = 0; i < arrayPrognoseZustandIn60Minuten.getLength(); ++i) {
						arrayPrognoseZustandIn60Minuten.getValue(i).set(getPrognoseZustandIn60Minuten().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getPrognoseZustandIn90Minuten() != null) {
					final Data.NumberArray arrayPrognoseZustandIn90Minuten = datum.
						getUnscaledArray
						("PrognoseZustandIn90Minuten");
					arrayPrognoseZustandIn90Minuten.setLength(getPrognoseZustandIn90Minuten().size());
					for (int i = 0; i < arrayPrognoseZustandIn90Minuten.getLength(); ++i) {
						arrayPrognoseZustandIn90Minuten.getValue(i).set(getPrognoseZustandIn90Minuten().get(i).getValue());
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
					final Data.NumberArray arrayFahrBahnOberFlaechenTemperatur = daten.
						getScaledArray
					("FahrBahnOberFlächenTemperatur");
	
					for (int i = 0; i < arrayFahrBahnOberFlaechenTemperatur.getLength(); ++i) {
	                    if (arrayFahrBahnOberFlaechenTemperatur.getValue(i).isState()) {
	                        getFahrBahnOberFlaechenTemperatur().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnOberFlaechenTemperatur
	                        .getZustand(arrayFahrBahnOberFlaechenTemperatur.getValue(i).getState().getName()));
	                    } else {
	                    getFahrBahnOberFlaechenTemperatur().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnOberFlaechenTemperatur
	                    (arrayFahrBahnOberFlaechenTemperatur.
	                    	doubleValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayFahrBahnFeuchte = daten.
						getUnscaledArray
					("FahrBahnFeuchte");
	
					for (int i = 0; i < arrayFahrBahnFeuchte.getLength(); ++i) {
	                    if (arrayFahrBahnFeuchte.getValue(i).isState()) {
	                        getFahrBahnFeuchte().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnFeuchte
	                        .getZustand(arrayFahrBahnFeuchte.getValue(i).getState().getName()));
	                    } else {
	                    getFahrBahnFeuchte().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnFeuchte
	                    (arrayFahrBahnFeuchte.
	                    		byteValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayRestSalz = daten.
						getUnscaledArray
					("RestSalz");
	
					for (int i = 0; i < arrayRestSalz.getLength(); ++i) {
	                    if (arrayRestSalz.getValue(i).isState()) {
	                        getRestSalz().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRestSalz
	                        .getZustand(arrayRestSalz.getValue(i).getState().getName()));
	                    } else {
	                    getRestSalz().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRestSalz
	                    (arrayRestSalz.
	                    		shortValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayGefrierTemperatur = daten.
						getScaledArray
					("GefrierTemperatur");
	
					for (int i = 0; i < arrayGefrierTemperatur.getLength(); ++i) {
	                    if (arrayGefrierTemperatur.getValue(i).isState()) {
	                        getGefrierTemperatur().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsGefrierTemperatur
	                        .getZustand(arrayGefrierTemperatur.getValue(i).getState().getName()));
	                    } else {
	                    getGefrierTemperatur().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsGefrierTemperatur
	                    (arrayGefrierTemperatur.
	                    	doubleValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayTemperaturInTiefe1 = daten.
						getScaledArray
					("TemperaturInTiefe1");
	
					for (int i = 0; i < arrayTemperaturInTiefe1.getLength(); ++i) {
	                    if (arrayTemperaturInTiefe1.getValue(i).isState()) {
	                        getTemperaturInTiefe1().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe1
	                        .getZustand(arrayTemperaturInTiefe1.getValue(i).getState().getName()));
	                    } else {
	                    getTemperaturInTiefe1().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe1
	                    (arrayTemperaturInTiefe1.
	                    	doubleValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayTemperaturInTiefe2 = daten.
						getScaledArray
					("TemperaturInTiefe2");
	
					for (int i = 0; i < arrayTemperaturInTiefe2.getLength(); ++i) {
	                    if (arrayTemperaturInTiefe2.getValue(i).isState()) {
	                        getTemperaturInTiefe2().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe2
	                        .getZustand(arrayTemperaturInTiefe2.getValue(i).getState().getName()));
	                    } else {
	                    getTemperaturInTiefe2().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe2
	                    (arrayTemperaturInTiefe2.
	                    	doubleValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayTemperaturInTiefe3 = daten.
						getScaledArray
					("TemperaturInTiefe3");
	
					for (int i = 0; i < arrayTemperaturInTiefe3.getLength(); ++i) {
	                    if (arrayTemperaturInTiefe3.getValue(i).isState()) {
	                        getTemperaturInTiefe3().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe3
	                        .getZustand(arrayTemperaturInTiefe3.getValue(i).getState().getName()));
	                    } else {
	                    getTemperaturInTiefe3().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe3
	                    (arrayTemperaturInTiefe3.
	                    	doubleValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayFahrBahnOberFlaechenZustand = daten.
						getUnscaledArray
					("FahrBahnOberFlächenZustand");
	
					for (int i = 0; i < arrayFahrBahnOberFlaechenZustand.getLength(); ++i) {
	                    if (arrayFahrBahnOberFlaechenZustand.getValue(i).isState()) {
	                        getFahrBahnOberFlaechenZustand().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnOberFlaechenZustand
	                        .getZustand(arrayFahrBahnOberFlaechenZustand.getValue(i).getState().getName()));
	                    } else {
	                    getFahrBahnOberFlaechenZustand().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnOberFlaechenZustand
	                    (arrayFahrBahnOberFlaechenZustand.
	                    		byteValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayWasserFilmDicke = daten.
						getScaledArray
					("WasserFilmDicke");
	
					for (int i = 0; i < arrayWasserFilmDicke.getLength(); ++i) {
	                    if (arrayWasserFilmDicke.getValue(i).isState()) {
	                        getWasserFilmDicke().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
	                        .getZustand(arrayWasserFilmDicke.getValue(i).getState().getName()));
	                    } else {
	                    getWasserFilmDicke().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
	                    (arrayWasserFilmDicke.
	                    	doubleValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayTauStoffKonzentration = daten.
						getUnscaledArray
					("TauStoffKonzentration");
	
					for (int i = 0; i < arrayTauStoffKonzentration.getLength(); ++i) {
	                    if (arrayTauStoffKonzentration.getValue(i).isState()) {
	                        getTauStoffKonzentration().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsTauStoffKonzentration
	                        .getZustand(arrayTauStoffKonzentration.getValue(i).getState().getName()));
	                    } else {
	                    getTauStoffKonzentration().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsTauStoffKonzentration
	                    (arrayTauStoffKonzentration.
	                    		shortValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayFahrBahnGlaette = daten.
						getUnscaledArray
					("FahrBahnGlätte");
	
					for (int i = 0; i < arrayFahrBahnGlaette.getLength(); ++i) {
	                    if (arrayFahrBahnGlaette.getValue(i).isState()) {
	                        getFahrBahnGlaette().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnGlaette
	                        .getZustand(arrayFahrBahnGlaette.getValue(i).getState().getName()));
	                    } else {
	                    getFahrBahnGlaette().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnGlaette
	                    (arrayFahrBahnGlaette.
	                    		byteValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayGlaettewarnungHersteller = daten.
						getUnscaledArray
					("GlättewarnungHersteller");
	
					for (int i = 0; i < arrayGlaettewarnungHersteller.getLength(); ++i) {
	                    if (arrayGlaettewarnungHersteller.getValue(i).isState()) {
	                        getGlaettewarnungHersteller().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsGlaettewarnungHersteller
	                        .getZustand(arrayGlaettewarnungHersteller.getValue(i).getState().getName()));
	                    } else {
	                    getGlaettewarnungHersteller().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsGlaettewarnungHersteller
	                    (arrayGlaettewarnungHersteller.
	                    		longValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayZeitreserveEisglaette = daten.
						getUnscaledArray
					("ZeitreserveEisglätte");
	
					for (int i = 0; i < arrayZeitreserveEisglaette.getLength(); ++i) {
	                    if (arrayZeitreserveEisglaette.getValue(i).isState()) {
	                        getZeitreserveEisglaette().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsZeitreserveEisglaette
	                        .getZustand(arrayZeitreserveEisglaette.getValue(i).getState().getName()));
	                    } else {
	                    getZeitreserveEisglaette().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsZeitreserveEisglaette
	                    (arrayZeitreserveEisglaette.
	                    		shortValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayZeitreserveReifglaette = daten.
						getUnscaledArray
					("ZeitreserveReifglätte");
	
					for (int i = 0; i < arrayZeitreserveReifglaette.getLength(); ++i) {
	                    if (arrayZeitreserveReifglaette.getValue(i).isState()) {
	                        getZeitreserveReifglaette().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsZeitreserveReifglaette
	                        .getZustand(arrayZeitreserveReifglaette.getValue(i).getState().getName()));
	                    } else {
	                    getZeitreserveReifglaette().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute.AttUfdsZeitreserveReifglaette
	                    (arrayZeitreserveReifglaette.
	                    		shortValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayAktuellerZustand = daten.
						getUnscaledArray
					("AktuellerZustand");
	
					for (int i = 0; i < arrayAktuellerZustand.getLength(); ++i) {
	                    if (arrayAktuellerZustand.getValue(i).isState()) {
	                        getAktuellerZustand().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
	                        .getZustand(arrayAktuellerZustand.getValue(i).getState().getName()));
	                    } else {
	                    getAktuellerZustand().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
	                    (arrayAktuellerZustand.
	                    		byteValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayPrognoseZustandIn5Minuten = daten.
						getUnscaledArray
					("PrognoseZustandIn5Minuten");
	
					for (int i = 0; i < arrayPrognoseZustandIn5Minuten.getLength(); ++i) {
	                    if (arrayPrognoseZustandIn5Minuten.getValue(i).isState()) {
	                        getPrognoseZustandIn5Minuten().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
	                        .getZustand(arrayPrognoseZustandIn5Minuten.getValue(i).getState().getName()));
	                    } else {
	                    getPrognoseZustandIn5Minuten().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
	                    (arrayPrognoseZustandIn5Minuten.
	                    		byteValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayPrognoseZustandIn15Minuten = daten.
						getUnscaledArray
					("PrognoseZustandIn15Minuten");
	
					for (int i = 0; i < arrayPrognoseZustandIn15Minuten.getLength(); ++i) {
	                    if (arrayPrognoseZustandIn15Minuten.getValue(i).isState()) {
	                        getPrognoseZustandIn15Minuten().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
	                        .getZustand(arrayPrognoseZustandIn15Minuten.getValue(i).getState().getName()));
	                    } else {
	                    getPrognoseZustandIn15Minuten().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
	                    (arrayPrognoseZustandIn15Minuten.
	                    		byteValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayPrognoseZustandIn30Minuten = daten.
						getUnscaledArray
					("PrognoseZustandIn30Minuten");
	
					for (int i = 0; i < arrayPrognoseZustandIn30Minuten.getLength(); ++i) {
	                    if (arrayPrognoseZustandIn30Minuten.getValue(i).isState()) {
	                        getPrognoseZustandIn30Minuten().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
	                        .getZustand(arrayPrognoseZustandIn30Minuten.getValue(i).getState().getName()));
	                    } else {
	                    getPrognoseZustandIn30Minuten().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
	                    (arrayPrognoseZustandIn30Minuten.
	                    		byteValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayPrognoseZustandIn60Minuten = daten.
						getUnscaledArray
					("PrognoseZustandIn60Minuten");
	
					for (int i = 0; i < arrayPrognoseZustandIn60Minuten.getLength(); ++i) {
	                    if (arrayPrognoseZustandIn60Minuten.getValue(i).isState()) {
	                        getPrognoseZustandIn60Minuten().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
	                        .getZustand(arrayPrognoseZustandIn60Minuten.getValue(i).getState().getName()));
	                    } else {
	                    getPrognoseZustandIn60Minuten().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
	                    (arrayPrognoseZustandIn60Minuten.
	                    		byteValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayPrognoseZustandIn90Minuten = daten.
						getUnscaledArray
					("PrognoseZustandIn90Minuten");
	
					for (int i = 0; i < arrayPrognoseZustandIn90Minuten.getLength(); ++i) {
	                    if (arrayPrognoseZustandIn90Minuten.getValue(i).isState()) {
	                        getPrognoseZustandIn90Minuten().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
	                        .getZustand(arrayPrognoseZustandIn90Minuten.getValue(i).getState().getName()));
	                    } else {
	                    getPrognoseZustandIn90Minuten().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
	                    (arrayPrognoseZustandIn90Minuten.
	                    		byteValue
	                    (i)));
	                    }
	                }
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlGmaUmfelddatenFuerFahrstreifen clone() {
		AtlGmaUmfelddatenFuerFahrstreifen klon = new AtlGmaUmfelddatenFuerFahrstreifen();
		
					klon._fahrBahnOberFlaechenTemperatur = getFahrBahnOberFlaechenTemperatur().clone();
					klon._fahrBahnFeuchte = getFahrBahnFeuchte().clone();
					klon._restSalz = getRestSalz().clone();
					klon._gefrierTemperatur = getGefrierTemperatur().clone();
					klon._temperaturInTiefe1 = getTemperaturInTiefe1().clone();
					klon._temperaturInTiefe2 = getTemperaturInTiefe2().clone();
					klon._temperaturInTiefe3 = getTemperaturInTiefe3().clone();
					klon._fahrBahnOberFlaechenZustand = getFahrBahnOberFlaechenZustand().clone();
					klon._wasserFilmDicke = getWasserFilmDicke().clone();
					klon._tauStoffKonzentration = getTauStoffKonzentration().clone();
					klon._fahrBahnGlaette = getFahrBahnGlaette().clone();
					klon._glaettewarnungHersteller = getGlaettewarnungHersteller().clone();
					klon._zeitreserveEisglaette = getZeitreserveEisglaette().clone();
					klon._zeitreserveReifglaette = getZeitreserveReifglaette().clone();
					klon._aktuellerZustand = getAktuellerZustand().clone();
					klon._prognoseZustandIn5Minuten = getPrognoseZustandIn5Minuten().clone();
					klon._prognoseZustandIn15Minuten = getPrognoseZustandIn15Minuten().clone();
					klon._prognoseZustandIn30Minuten = getPrognoseZustandIn30Minuten().clone();
					klon._prognoseZustandIn60Minuten = getPrognoseZustandIn60Minuten().clone();
					klon._prognoseZustandIn90Minuten = getPrognoseZustandIn90Minuten().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
