/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Position des Fahrbahnsensors (BUFR Codetabelle 0 02 242).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 15L,
	einheit = ""
)
public class AttUfdPositionFahrbahnSensor extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MIN_VALUE =
				Byte
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MAX_VALUE =
				Byte
		.valueOf("15");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_0_UEBERHOLFAHRSTREIFEN_ZWISCHEN_DEN_ROLLSPUREN = new AttUfdPositionFahrbahnSensor("Überholfahrstreifen zwischen den Rollspuren", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_1_UEBERHOLFAHRSTREIFEN_ZWISCHEN_DEN_ROLLSPUREN_IN_GEGENRICHTUNG = new AttUfdPositionFahrbahnSensor("Überholfahrstreifen zwischen den Rollspuren in Gegenrichtung", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_2_UEBERHOLFAHRSTREIFEN_IN_DEN_ROLLSPUREN = new AttUfdPositionFahrbahnSensor("Überholfahrstreifen in den Rollspuren", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_3_UEBERHOLFAHRSTREIFEN_IN_DEN_ROLLSPUREN_IN_GEGENRICHTUNG = new AttUfdPositionFahrbahnSensor("Überholfahrstreifen in den Rollspuren in Gegenrichtung", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_4_HAUPTFAHRSTREIFEN_ZWISCHEN_DEN_ROLLSPUREN = new AttUfdPositionFahrbahnSensor("Hauptfahrstreifen zwischen den Rollspuren", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_5_HAUPTFAHRSTREIFEN_ZWISCHEN_DEN_ROLLSPUREN_IN_GEGENRICHTUNG = new AttUfdPositionFahrbahnSensor("Hauptfahrstreifen zwischen den Rollspuren in Gegenrichtung", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_6_HAUPTFAHRSTREIFEN_IN_DEN_ROLLSPUREN = new AttUfdPositionFahrbahnSensor("Hauptfahrstreifen in den Rollspuren", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_7_HAUPTFAHRSTREIFEN_IN_DEN_ROLLSPUREN_IN_GEGENRICHTUNG = new AttUfdPositionFahrbahnSensor("Hauptfahrstreifen in den Rollspuren in Gegenrichtung", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_8__8_RESERVIERT_ = new AttUfdPositionFahrbahnSensor("8 (reserviert)", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_9__9_RESERVIERT_ = new AttUfdPositionFahrbahnSensor("9 (reserviert)", 		Byte
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_10__10_RESERVIERT_ = new AttUfdPositionFahrbahnSensor("10 (reserviert)", 		Byte
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_11__11_RESERVIERT_ = new AttUfdPositionFahrbahnSensor("11 (reserviert)", 		Byte
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_12__12_RESERVIERT_ = new AttUfdPositionFahrbahnSensor("12 (reserviert)", 		Byte
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_13__13_RESERVIERT_ = new AttUfdPositionFahrbahnSensor("13 (reserviert)", 		Byte
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_14__14_RESERVIERT_ = new AttUfdPositionFahrbahnSensor("14 (reserviert)", 		Byte
	.valueOf("14"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdPositionFahrbahnSensor ZUSTAND_15_UNBEKANNT = new AttUfdPositionFahrbahnSensor("unbekannt", 		Byte
	.valueOf("15"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttUfdPositionFahrbahnSensor getZustand(final 		Byte
	 value) {
		for (AttUfdPositionFahrbahnSensor e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttUfdPositionFahrbahnSensor getZustand(final String value) {
		for (AttUfdPositionFahrbahnSensor e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttUfdPositionFahrbahnSensor> getZustaende() {
		List<AttUfdPositionFahrbahnSensor> list = new ArrayList<AttUfdPositionFahrbahnSensor>();
		list.add(ZUSTAND_0_UEBERHOLFAHRSTREIFEN_ZWISCHEN_DEN_ROLLSPUREN);
		list.add(ZUSTAND_1_UEBERHOLFAHRSTREIFEN_ZWISCHEN_DEN_ROLLSPUREN_IN_GEGENRICHTUNG);
		list.add(ZUSTAND_2_UEBERHOLFAHRSTREIFEN_IN_DEN_ROLLSPUREN);
		list.add(ZUSTAND_3_UEBERHOLFAHRSTREIFEN_IN_DEN_ROLLSPUREN_IN_GEGENRICHTUNG);
		list.add(ZUSTAND_4_HAUPTFAHRSTREIFEN_ZWISCHEN_DEN_ROLLSPUREN);
		list.add(ZUSTAND_5_HAUPTFAHRSTREIFEN_ZWISCHEN_DEN_ROLLSPUREN_IN_GEGENRICHTUNG);
		list.add(ZUSTAND_6_HAUPTFAHRSTREIFEN_IN_DEN_ROLLSPUREN);
		list.add(ZUSTAND_7_HAUPTFAHRSTREIFEN_IN_DEN_ROLLSPUREN_IN_GEGENRICHTUNG);
		list.add(ZUSTAND_8__8_RESERVIERT_);
		list.add(ZUSTAND_9__9_RESERVIERT_);
		list.add(ZUSTAND_10__10_RESERVIERT_);
		list.add(ZUSTAND_11__11_RESERVIERT_);
		list.add(ZUSTAND_12__12_RESERVIERT_);
		list.add(ZUSTAND_13__13_RESERVIERT_);
		list.add(ZUSTAND_14__14_RESERVIERT_);
		list.add(ZUSTAND_15_UNBEKANNT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut PositionFahrbahnSensor.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttUfdPositionFahrbahnSensor(final 		Byte
	 value) {
		super(value);
	}
	
	private AttUfdPositionFahrbahnSensor(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
