/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Art des Fahrbahnbelags (BUFR Codetabelle 0 02 245).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 15L,
	einheit = ""
)
public class AttUfdStreckenTypFahrbahnBelag extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MIN_VALUE =
				Byte
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MAX_VALUE =
				Byte
		.valueOf("15");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_0_ASPHALT = new AttUfdStreckenTypFahrbahnBelag("Asphalt", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_1_BETON = new AttUfdStreckenTypFahrbahnBelag("Beton", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_2_BETONKONSTRUKTION = new AttUfdStreckenTypFahrbahnBelag("Betonkonstruktion", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_3_STAHLKONSTRUKTION = new AttUfdStreckenTypFahrbahnBelag("Stahlkonstruktion", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_4_HOHLKASTENBRUECKE = new AttUfdStreckenTypFahrbahnBelag("Hohlkastenbrücke", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_5_ORTHOTROPE_PLATTE = new AttUfdStreckenTypFahrbahnBelag("orthotrope Platte", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_6_DRAINASPHALT = new AttUfdStreckenTypFahrbahnBelag("Drainasphalt", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_7__7_RESERVIERT_ = new AttUfdStreckenTypFahrbahnBelag("7 (reserviert)", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_8__8_RESERVIERT_ = new AttUfdStreckenTypFahrbahnBelag("8 (reserviert)", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_9__9_RESERVIERT_ = new AttUfdStreckenTypFahrbahnBelag("9 (reserviert)", 		Byte
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_10__10_RESERVIERT_ = new AttUfdStreckenTypFahrbahnBelag("10 (reserviert)", 		Byte
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_11__11_RESERVIERT_ = new AttUfdStreckenTypFahrbahnBelag("11 (reserviert)", 		Byte
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_12__12_RESERVIERT_ = new AttUfdStreckenTypFahrbahnBelag("12 (reserviert)", 		Byte
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_13__13_RESERVIERT_ = new AttUfdStreckenTypFahrbahnBelag("13 (reserviert)", 		Byte
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_14__14_RESERVIERT_ = new AttUfdStreckenTypFahrbahnBelag("14 (reserviert)", 		Byte
	.valueOf("14"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypFahrbahnBelag ZUSTAND_15_UNBEKANNT = new AttUfdStreckenTypFahrbahnBelag("unbekannt", 		Byte
	.valueOf("15"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttUfdStreckenTypFahrbahnBelag getZustand(final 		Byte
	 value) {
		for (AttUfdStreckenTypFahrbahnBelag e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttUfdStreckenTypFahrbahnBelag getZustand(final String value) {
		for (AttUfdStreckenTypFahrbahnBelag e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttUfdStreckenTypFahrbahnBelag> getZustaende() {
		List<AttUfdStreckenTypFahrbahnBelag> list = new ArrayList<AttUfdStreckenTypFahrbahnBelag>();
		list.add(ZUSTAND_0_ASPHALT);
		list.add(ZUSTAND_1_BETON);
		list.add(ZUSTAND_2_BETONKONSTRUKTION);
		list.add(ZUSTAND_3_STAHLKONSTRUKTION);
		list.add(ZUSTAND_4_HOHLKASTENBRUECKE);
		list.add(ZUSTAND_5_ORTHOTROPE_PLATTE);
		list.add(ZUSTAND_6_DRAINASPHALT);
		list.add(ZUSTAND_7__7_RESERVIERT_);
		list.add(ZUSTAND_8__8_RESERVIERT_);
		list.add(ZUSTAND_9__9_RESERVIERT_);
		list.add(ZUSTAND_10__10_RESERVIERT_);
		list.add(ZUSTAND_11__11_RESERVIERT_);
		list.add(ZUSTAND_12__12_RESERVIERT_);
		list.add(ZUSTAND_13__13_RESERVIERT_);
		list.add(ZUSTAND_14__14_RESERVIERT_);
		list.add(ZUSTAND_15_UNBEKANNT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut StreckentypFahrbahnbelag.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttUfdStreckenTypFahrbahnBelag(final 		Byte
	 value) {
		super(value);
	}
	
	private AttUfdStreckenTypFahrbahnBelag(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
