/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmswis.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Charakterisierende Daten einer Glättemeldeanlage (als logisches Strukturelement).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdGma extends AbstractKonfigurationsDatensatz<KdGma.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _dWDKennung
				= new String
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
				 _strasse
				;
				private 	Double
				 _station
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttGmaHoehe
				 _hoehe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
				 _himmelsrichtung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _gMANummer
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.UfdSensorGruppe
				 _atmosphaerendaten
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.UfdSensorGruppe
				> _fahrstreifendaten = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.UfdSensorGruppe
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdErweiterterStationsTyp
				 _stationstyp
				;
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von DWDKennung.
			*/
				public String
				 getDWDKennung() {
				return _dWDKennung;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _dWDKennung der neue Wert von DWDKennung.
			*/
			public void setDWDKennung(String
			 _dWDKennung) {
				if (_dWDKennung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._dWDKennung = _dWDKennung;
			}
		
			/**
			Verweis auf Straße.
			<p>
			
			</p>
			
			@return der Wert von Strasse.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
				 getStrasse() {
				return _strasse;
			}
		
			/**
			Verweis auf Straße.
			<p>
			
			</p>
			
			@param _strasse der neue Wert von Strasse.
			*/
			public void setStrasse(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
			 _strasse) {
				this._strasse = _strasse;
			}
		
			/**
			Stationierung auf der Strecken die über zwei Netzknoten eindeutig referenziert werden kann.
			<p>
			
			</p>
			
			@return der Wert von Station.
			*/
				public 	Double
				 getStation() {
				return _station;
			}
		
			/**
			Stationierung auf der Strecken die über zwei Netzknoten eindeutig referenziert werden kann.
			<p>
			
			</p>
			
			@param _station der neue Wert von Station.
			*/
			public void setStation(	Double
			 _station) {
				this._station = _station;
			}
		
			/**
			Höhe der GMA über Gelände.
			<p>
			
			</p>
			
			@return der Wert von Hoehe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttGmaHoehe
				 getHoehe() {
				return _hoehe;
			}
		
			/**
			Höhe der GMA über Gelände.
			<p>
			
			</p>
			
			@param _hoehe der neue Wert von Hoehe.
			*/
			public void setHoehe(de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttGmaHoehe
			 _hoehe) {
				this._hoehe = _hoehe;
			}
		
			/**
			Himmelsrichtung zur Angabe der Richtung u.a. von Richtungsquerschnitten.
			<p>
			
			</p>
			
			@return der Wert von Himmelsrichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
				 getHimmelsrichtung() {
				return _himmelsrichtung;
			}
		
			/**
			Himmelsrichtung zur Angabe der Richtung u.a. von Richtungsquerschnitten.
			<p>
			
			</p>
			
			@param _himmelsrichtung der neue Wert von Himmelsrichtung.
			*/
			public void setHimmelsrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
			 _himmelsrichtung) {
				this._himmelsrichtung = _himmelsrichtung;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von GMANummer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getGMANummer() {
				return _gMANummer;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _gMANummer der neue Wert von GMANummer.
			*/
			public void setGMANummer(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _gMANummer) {
				this._gMANummer = _gMANummer;
			}
		
			/**
			Referenz auf eine UfdSensorGruppe.
			<p>
			
			</p>
			
			@return der Wert von Atmosphaerendaten.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.UfdSensorGruppe
				 getAtmosphaerendaten() {
				return _atmosphaerendaten;
			}
		
			/**
			Referenz auf eine UfdSensorGruppe.
			<p>
			
			</p>
			
			@param _atmosphaerendaten der neue Wert von Atmosphaerendaten.
			*/
			public void setAtmosphaerendaten(	de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.UfdSensorGruppe
			 _atmosphaerendaten) {
				this._atmosphaerendaten = _atmosphaerendaten;
			}
		
			/**
			Referenz auf eine UfdSensorGruppe.
			<p>
			
			</p>
			
			@return der Wert von Fahrstreifendaten.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.UfdSensorGruppe
				> getFahrstreifendaten() {
				return _fahrstreifendaten;
			}
		
		
			/**
			Erweiterter Stationstyp (BUFR Codetabelle 0 02 243).
			<p>
			
			</p>
			
			@return der Wert von Stationstyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdErweiterterStationsTyp
				 getStationstyp() {
				return _stationstyp;
			}
		
			/**
			Erweiterter Stationstyp (BUFR Codetabelle 0 02 243).
			<p>
			
			</p>
			
			@param _stationstyp der neue Wert von Stationstyp.
			*/
			public void setStationstyp(de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdErweiterterStationsTyp
			 _stationstyp) {
				this._stationstyp = _stationstyp;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getDWDKennung() != null) {
						datum.getTextValue("DWDKennung").setText(getDWDKennung());
					}
					// ObjektReferenzAttributTyp
						final Object soStrasse = getStrasse();
						final SystemObject tmpStrasse;
							if (soStrasse instanceof SystemObject) {
								tmpStrasse = (SystemObject)soStrasse;
							} else if(soStrasse instanceof SystemObjekt){
								tmpStrasse = ((SystemObjekt)soStrasse).getSystemObject();
							} else{
								tmpStrasse = null;
							}
						datum.getReferenceValue("Straße").setSystemObject(tmpStrasse);
					// KommazahlAttributTyp
					if (getStation() != null) {
						datum.getUnscaledValue("Station").set(getStation());
					}
					// GanzzahlAttributTyp
					if (getHoehe() != null) {
		                if (getHoehe().isZustand()) {
		                    datum.getUnscaledValue("Höhe").setText(getHoehe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Höhe").set(getHoehe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getHimmelsrichtung() != null) {
		                if (getHimmelsrichtung().isZustand()) {
		                    datum.getUnscaledValue("Himmelsrichtung").setText(getHimmelsrichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Himmelsrichtung").set(getHimmelsrichtung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getGMANummer() != null) {
		                if (getGMANummer().isZustand()) {
		                    datum.getUnscaledValue("GMANummer").setText(getGMANummer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("GMANummer").set(getGMANummer().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Object soAtmosphaerendaten = getAtmosphaerendaten();
						final SystemObject tmpAtmosphaerendaten;
							if (soAtmosphaerendaten instanceof SystemObject) {
								tmpAtmosphaerendaten = (SystemObject)soAtmosphaerendaten;
							} else if(soAtmosphaerendaten instanceof SystemObjekt){
								tmpAtmosphaerendaten = ((SystemObjekt)soAtmosphaerendaten).getSystemObject();
							} else{
								tmpAtmosphaerendaten = null;
							}
						datum.getReferenceValue("Atmosphärendaten").setSystemObject(tmpAtmosphaerendaten);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayFahrstreifendaten = datum.getReferenceArray("Fahrstreifendaten");
						arrayFahrstreifendaten.setLength(getFahrstreifendaten().size());
						for (int i = 0; i < arrayFahrstreifendaten.getLength(); ++i) {
							final Object soFahrstreifendaten = getFahrstreifendaten().get(i);
							final SystemObject tmpFahrstreifendaten;
							if (soFahrstreifendaten instanceof SystemObject) {
								tmpFahrstreifendaten = (SystemObject)soFahrstreifendaten;
							} else if(soFahrstreifendaten instanceof SystemObjekt){
								tmpFahrstreifendaten = ((SystemObjekt)soFahrstreifendaten).getSystemObject();
							} else{
								tmpFahrstreifendaten = null;
							}
							arrayFahrstreifendaten.getReferenceValue(i).setSystemObject(tmpFahrstreifendaten);
						}
					// GanzzahlAttributTyp
					if (getStationstyp() != null) {
		                if (getStationstyp().isZustand()) {
		                    datum.getUnscaledValue("Stationstyp").setText(getStationstyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Stationstyp").set(getStationstyp().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setDWDKennung(daten.getTextValue("DWDKennung").getText());
					// ObjektReferenzAttributTyp
						final long idStrasse = daten.getReferenceValue("Straße").getId();
						final SystemObjekt tmpStrasse;
						if (idStrasse == 0) {
							tmpStrasse = null;
						} else {
							final SystemObject soStrasse = factory.getDav().getDataModel().getObject(idStrasse);
							if (soStrasse == null) {
									tmpStrasse = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrasseUngueltig(idStrasse);
							} else {
								tmpStrasse = factory.getModellobjekt(soStrasse);
							}
						}
						setStrasse((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
						) tmpStrasse);
					// KommazahlAttributTyp
						setStation(daten.getUnscaledValue("Station").
							doubleValue()
						);
					// GanzzahlAttributTyp
							setHoehe(new de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttGmaHoehe
							(daten.
								getUnscaledValue
							("Höhe").
									shortValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Himmelsrichtung").isState()) {
								setHimmelsrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
								.getZustand(daten.getScaledValue("Himmelsrichtung").getText()));
							} else {
							setHimmelsrichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
							(daten.
								getUnscaledValue
							("Himmelsrichtung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setGMANummer(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("GMANummer").
									longValue
							()));
					// ObjektReferenzAttributTyp
						final long idAtmosphaerendaten = daten.getReferenceValue("Atmosphärendaten").getId();
						final SystemObjekt tmpAtmosphaerendaten;
						if (idAtmosphaerendaten == 0) {
							tmpAtmosphaerendaten = null;
						} else {
							final SystemObject soAtmosphaerendaten = factory.getDav().getDataModel().getObject(idAtmosphaerendaten);
							if (soAtmosphaerendaten == null) {
									tmpAtmosphaerendaten = new de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.impl.UfdSensorGruppeUngueltig(idAtmosphaerendaten);
							} else {
								tmpAtmosphaerendaten = factory.getModellobjekt(soAtmosphaerendaten);
							}
						}
						setAtmosphaerendaten((	de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.UfdSensorGruppe
						) tmpAtmosphaerendaten);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayFahrstreifendaten = daten.getReferenceArray("Fahrstreifendaten");
						for (int i = 0; i < arrayFahrstreifendaten.getLength(); ++i) {
							final long idFahrstreifendaten = daten.getReferenceArray("Fahrstreifendaten").getReferenceValue(i).getId();
							final SystemObjekt tmpFahrstreifendaten;
							if (idFahrstreifendaten == 0) {
								tmpFahrstreifendaten = null;
							} else {
								final SystemObject soFahrstreifendaten = factory.getDav().getDataModel().getObject(idFahrstreifendaten);
								if (soFahrstreifendaten == null) {
										tmpFahrstreifendaten = new de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.impl.UfdSensorGruppeUngueltig(idFahrstreifendaten);
								} else {
									tmpFahrstreifendaten = factory.getModellobjekt(soFahrstreifendaten);
								}
							}
								getFahrstreifendaten().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.UfdSensorGruppe
								) tmpFahrstreifendaten);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Stationstyp").isState()) {
								setStationstyp(de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdErweiterterStationsTyp
								.getZustand(daten.getScaledValue("Stationstyp").getText()));
							} else {
							setStationstyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdErweiterterStationsTyp
							(daten.
								getUnscaledValue
							("Stationstyp").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setDWDKennung(getDWDKennung());
							klon.setStrasse(getStrasse());
							klon.setStation(getStation());
							klon.setHoehe(getHoehe());
							klon.setHimmelsrichtung(getHimmelsrichtung());
							klon.setGMANummer(getGMANummer());
							klon.setAtmosphaerendaten(getAtmosphaerendaten());
						klon._fahrstreifendaten = getFahrstreifendaten().clone();
							klon.setStationstyp(getStationstyp());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.gma";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdGma(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
