/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Gruppierung von Umfelddatensensoren zu einer logischen Einheit (z.B. alle atmosphärischen Sensoren).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface UfdSensorGruppe extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.ufdSensorGruppe"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
Menge der Umfelddatensensoren, die eine Umfelddatenmessstelle bilden.
<p>

</p>

@return die Menge UmfeldDatenSensoren oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> getUmfeldDatenSensoren();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Fuzzy-Set (Parameter) für Fahrbahnzustand.
	<p>
	
	</p>
	@return der Datensatz UfdmsParameterFahrBahnZustandFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterFahrBahnZustandFuzzy getPdUfdmsParameterFahrBahnZustandFuzzy();
	
	/**
	Parameter für die meteorologische Kontrolle der Pl Prüfung Logisch UFD ab Version 2.0.
	<p>
	
	</p>
	@return der Datensatz UfdmsParameterMeteorologischeKontrolle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterMeteorologischeKontrolle getPdUfdmsParameterMeteorologischeKontrolle();
	
	/**
	Sichtverhältnisse einer Umfelddatenmessstelle als lingustische Variable.
	<p>
	
	</p>
	@return der Datensatz UfdmsSichtVerhaeltnisseFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsSichtVerhaeltnisseFuzzy getOdUfdmsSichtVerhaeltnisseFuzzy();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Charakterisierende Daten einer Sensorengruppe (als logisches Strukturelement).
	<p>
	
	</p>
	@return der Datensatz UfdSensorGruppe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmswis.konfigurationsdaten.KdUfdSensorGruppe getKdUfdSensorGruppe();
	
	/**
	Parameter für die Abbildung der Abtrocknungsphasen beim Übergang zwischen verschiedenen NässeStufen.
	<p>
	
	</p>
	@return der Datensatz UfdmsAbtrockungsPhasen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsAbtrockungsPhasen getPdUfdmsAbtrockungsPhasen();
	
	/**
	Fuzzy-Set (Parameter) für SichtVerhältnisse.
	<p>
	
	</p>
	@return der Datensatz UfdmsParameterSichtVerhaeltnisseFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterSichtVerhaeltnisseFuzzy getPdUfdmsParameterSichtVerhaeltnisseFuzzy();
	
	/**
	Ergebnisse der Glättewarnung und Prognose für diese Umfelddatenmessstelle.
	<p>
	
	</p>
	@return der Datensatz UfdmsGlaette.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsGlaette getOdUfdmsGlaette();
	
	/**
	Referenz auf ein Linienobjekt mit Offsetangabe vom Begin der Linie. Darüber läßt sich dessen Koordinate ermitteln. Liegen mehrer Objekte auf einem Linienobjekt, läßt sich über die Offsets die Topologie ermitteln.
	<p>
	
	</p>
	@return der Datensatz PunktLiegtAufLinienObjekt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt getKdPunktLiegtAufLinienObjekt();
	
	/**
	Fuzzy-Set (Parameter) für Glätte.
	<p>
	
	</p>
	@return der Datensatz UfdmsParameterGlaetteFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterGlaetteFuzzy getPdUfdmsParameterGlaetteFuzzy();
	
	/**
	Glätte einer Umfelddatenmessstelle als lingustische Variable.
	<p>
	
	</p>
	@return der Datensatz UfdmsGlaetteFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsGlaetteFuzzy getOdUfdmsGlaetteFuzzy();
	
	/**
	Der aus der relativen Luftfeuchte und der Lufttemperatur ermittelte Taupunkt.
	<p>
	
	</p>
	@return der Datensatz UfdmsTaupunktTemperaturLuft.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsTaupunktTemperaturLuft getOdUfdmsTaupunktTemperaturLuft();
	
	/**
	Der aus der relativen Luftfeuchte und der Fahrbahntemperatur ermittelte Taupunkt.
	<p>
	
	</p>
	@return der Datensatz UfdmsTaupunktTemperaturFahrBahn.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsTaupunktTemperaturFahrBahn getOdUfdmsTaupunktTemperaturFahrBahn();
	
	/**
	Fahrbahnzustand an einer Umfelddatenmessstelle als lingustische Variable.
	<p>
	
	</p>
	@return der Datensatz UfdmsFahrBahnZustandFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsFahrBahnZustandFuzzy getOdUfdmsFahrBahnZustandFuzzy();
	
	/**
	Die aus der NiederschlagIntensitätsStufe und der WasserfilddickenStufe ermittlete NässeStufe.
	<p>
	
	</p>
	@return der Datensatz UfdmsNaesseStufe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsNaesseStufe getOdUfdmsNaesseStufe();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz UmfeldDatenMessStelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.konfigurationsdaten.KdUmfeldDatenMessStelle getKdUmfeldDatenMessStelle();
	
	/**
	Fuzzy-Regelbasis.
	<p>
	
	</p>
	@return der Datensatz FuzzyRegelbasis.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFuzzyRegelbasis getPdFuzzyRegelbasis();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
