/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Gruppierung von Umfelddatensensoren zu einer logischen Einheit (z.B. alle atmosphärischen Sensoren).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class UfdSensorGruppeUngueltig extends BaseUngueltigesSystemObjekt implements de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.UfdSensorGruppe { 

	private long id;

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public UfdSensorGruppeUngueltig() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param id
	 *            die ID des Systemobjekt.
	 */
	public UfdSensorGruppeUngueltig(final long id) {
		super(id);
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> getUmfeldDatenSensoren() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterFahrBahnZustandFuzzy getPdUfdmsParameterFahrBahnZustandFuzzy() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterMeteorologischeKontrolle getPdUfdmsParameterMeteorologischeKontrolle() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsSichtVerhaeltnisseFuzzy getOdUfdmsSichtVerhaeltnisseFuzzy() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmswis.konfigurationsdaten.KdUfdSensorGruppe getKdUfdSensorGruppe() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsAbtrockungsPhasen getPdUfdmsAbtrockungsPhasen() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterSichtVerhaeltnisseFuzzy getPdUfdmsParameterSichtVerhaeltnisseFuzzy() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsGlaette getOdUfdmsGlaette() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt getKdPunktLiegtAufLinienObjekt() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterGlaetteFuzzy getPdUfdmsParameterGlaetteFuzzy() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsGlaetteFuzzy getOdUfdmsGlaetteFuzzy() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsTaupunktTemperaturLuft getOdUfdmsTaupunktTemperaturLuft() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsTaupunktTemperaturFahrBahn getOdUfdmsTaupunktTemperaturFahrBahn() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsFahrBahnZustandFuzzy getOdUfdmsFahrBahnZustandFuzzy() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsNaesseStufe getOdUfdmsNaesseStufe() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.konfigurationsdaten.KdUmfeldDatenMessStelle getKdUmfeldDatenMessStelle() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFuzzyRegelbasis getPdFuzzyRegelbasis() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */

	// Sonderfall Klasse AttributImpl
	 

}
