/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmswis.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Umfelddaten einer Glättemeldeanlage, zusammengefasst für maßgebliche Sensoren.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdGmaUmfelddaten extends AbstractOnlineDatensatz<OdGmaUmfelddaten.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.AggregationsIntervall15Minuten,
					Aspekte.AggregationsIntervallTag,
					Aspekte.TlsAntwort,
					Aspekte.AggregationsIntervallStunde,
					Aspekte.AggregationsIntervallJahr,
					Aspekte.AggregationsIntervallMonat,
				};
			}
	
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 15 Minuten zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervall15Minuten = new Aspekte("AggregationsIntervall15Minuten", "asp.aggregationsIntervall15Minuten");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Tag (24 Stunden) zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallTag = new Aspekte("AggregationsIntervallTag", "asp.aggregationsIntervallTag");
			
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Stunde (60 Minuten) zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallStunde = new Aspekte("AggregationsIntervallStunde", "asp.aggregationsIntervallStunde");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Jahr zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallJahr = new Aspekte("AggregationsIntervallJahr", "asp.aggregationsIntervallJahr");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Monat zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallMonat = new Aspekte("AggregationsIntervallMonat", "asp.aggregationsIntervallMonat");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlGmaAtmosphaerendaten
				 _atmosphaerendaten
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlGmaAtmosphaerendaten
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlGmaUmfelddatenFuerFahrstreifen
				> _umfelddatenFuerFahrstreifen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlGmaUmfelddatenFuerFahrstreifen
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlSwisAlarm
				> _swisAlarm = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlSwisAlarm
				>(1, true);
		
			/**
			Sensorikdaten die nicht fahrsteifenbezogen sind (Lufttemperatur, Wind, ...).
			<p>
			
			</p>
			
			@return der Wert von Atmosphaerendaten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlGmaAtmosphaerendaten
				 getAtmosphaerendaten() {
				return _atmosphaerendaten;
			}
		
			/**
			Sensorikdaten die nicht fahrsteifenbezogen sind (Lufttemperatur, Wind, ...).
			<p>
			
			</p>
			
			@param _atmosphaerendaten der neue Wert von Atmosphaerendaten.
			*/
			public void setAtmosphaerendaten(de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlGmaAtmosphaerendaten
			 _atmosphaerendaten) {
				this._atmosphaerendaten = _atmosphaerendaten;
			}
		
			/**
			Sensorikdaten für die jeweiligen Fahrstreifen, Indizierung bzw. Sortierung ergibt sich aus den Konfigurationsangaben der GMA.
			<p>
			
			</p>
			
			@return der Wert von UmfelddatenFuerFahrstreifen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlGmaUmfelddatenFuerFahrstreifen
				> getUmfelddatenFuerFahrstreifen() {
				return _umfelddatenFuerFahrstreifen;
			}
		
		
			/**
			Gibt an, ob ein Alarm für die GMA anliegt und ob ein Alarm noch unbestätigt ist.
			<p>
			
			</p>
			
			@return der Wert von SwisAlarm.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlSwisAlarm
				> getSwisAlarm() {
				return _swisAlarm;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getAtmosphaerendaten().bean2Atl(datum.getItem("Atmosphärendaten"), factory);
					// AttributListenDefinition
						final Data.Array arrayUmfelddatenFuerFahrstreifen = datum.getArray("UmfelddatenFuerFahrstreifen");
						arrayUmfelddatenFuerFahrstreifen.setLength(getUmfelddatenFuerFahrstreifen().size());
						for (int i = 0; i < arrayUmfelddatenFuerFahrstreifen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlGmaUmfelddatenFuerFahrstreifen
							 atl = getUmfelddatenFuerFahrstreifen().get(i);
							atl.bean2Atl(arrayUmfelddatenFuerFahrstreifen.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arraySwisAlarm = datum.getArray("SwisAlarm");
						arraySwisAlarm.setLength(getSwisAlarm().size());
						for (int i = 0; i < arraySwisAlarm.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlSwisAlarm
							 atl = getSwisAlarm().get(i);
							atl.bean2Atl(arraySwisAlarm.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getAtmosphaerendaten().atl2Bean(daten.getItem("Atmosphärendaten"), factory);
					// AttributListenDefinition
						final Data.Array arrayUmfelddatenFuerFahrstreifen = daten.getArray("UmfelddatenFuerFahrstreifen");
						for (int i = 0; i < arrayUmfelddatenFuerFahrstreifen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlGmaUmfelddatenFuerFahrstreifen
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlGmaUmfelddatenFuerFahrstreifen
							 ();
							atl.atl2Bean(arrayUmfelddatenFuerFahrstreifen.getItem(i), factory);
							getUmfelddatenFuerFahrstreifen().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arraySwisAlarm = daten.getArray("SwisAlarm");
						for (int i = 0; i < arraySwisAlarm.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlSwisAlarm
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlSwisAlarm
							 ();
							atl.atl2Bean(arraySwisAlarm.getItem(i), factory);
							getSwisAlarm().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._atmosphaerendaten = getAtmosphaerendaten().clone();
						klon._umfelddatenFuerFahrstreifen = getUmfelddatenFuerFahrstreifen().clone();
						klon._swisAlarm = getSwisAlarm().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.gmaUmfelddaten";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdGmaUmfelddaten(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
