/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Typ eines Kalenders, der einzelne Systemkalender und
					Ereigniskalendereinträge verwaltet.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KalenderImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.objekte.Kalender { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public KalenderImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public KalenderImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein Kalender.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp> ereignisTypen;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp> getEreignisTypen() {
		if (ereignisTypen == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("EreignisTypen") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			ereignisTypen = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp>(getObjektFactory(), (MutableSet)ko.getObjectSet("EreignisTypen"), 0, 0, this);
		}
		return ereignisTypen;
	}
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.Ereignis> ereignisse;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.Ereignis> getEreignisse() {
		if (ereignisse == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Ereignisse") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			ereignisse = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.Ereignis>(getObjektFactory(), (MutableSet)ko.getObjectSet("Ereignisse"), 0, 0, this);
		}
		return ereignisse;
	}
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.objekte.SystemKalenderEintrag> systemKalenderEintraege;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.objekte.SystemKalenderEintrag> getSystemKalenderEintraege() {
		if (systemKalenderEintraege == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("SystemKalenderEinträge") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			systemKalenderEintraege = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.objekte.SystemKalenderEintrag>(getObjektFactory(), (MutableSet)ko.getObjectSet("SystemKalenderEinträge"), 0, 0, this);
		}
		return systemKalenderEintraege;
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.onlinedaten.OdEreignisKalenderAnfrage getOdEreignisKalenderAnfrage() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.onlinedaten.OdEreignisKalenderAnfrage.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.parameter.PdStatusBaustelleAlsEreignis getPdStatusBaustelleAlsEreignis() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.parameter.PdStatusBaustelleAlsEreignis.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
